from app.entities.models import AMSAsset
from rest_framework import serializers


class AMSAssetSerializer(serializers.ModelSerializer):
    
    def to_representation(self, instance):
        ret = super().to_representation(instance)
        ret['asset_type'] = instance.asset_type.name
        ret['in_qty'] = instance.ams_asset_to_assetdetail.filter(status='In-Store').count()
        ret['out_qty'] = instance.ams_asset_to_assetdetail.filter(status='Deployed').count()
        ret['unavailable'] = instance.ams_asset_to_assetdetail.filter(status='Faulty').count()
        ret['created_by'] = instance.created_by.name
        return ret

    class Meta:
        model = AMSAsset
        fields = '__all__'
        read_only_fields = ('created_by',)
