from app.entities import models
from rest_framework import serializers
from app.applicationlayer.utils import model_to_dict


class ChangeRequestFormApproversSerializer(
    serializers.ModelSerializer
):
    def to_representation(self, instance):
        ret = super().to_representation(instance)
        try:
            ret['company'] = model_to_dict(instance.user.department.company)
            ret['department'] = model_to_dict(instance.user.department)
            user_object = {
                "id": instance.user.id,
                "name": instance.user.name,
                "username": instance.user.username,
                "code": instance.user.code,
                "email": instance.user.email,
                "contact_no": instance.user.contact_no
            }
            ret['user'] = user_object

            if instance.tmp_approver:
                if instance.form_code.status == '' or instance.form_code.status == 'Draft':
                    if instance.tmp_approver.delegation.lower() == 'requestor':
                        ret['is_editable'] = False
                    elif instance.tmp_approver.user:
                        ret['is_editable'] = False
                    else:
                        ret['is_editable'] = True
                else:
                    ret['is_editable'] = False    
            else:
                ret['is_editable'] = False

            return ret
        
        except Exception as e:
            ret['user'] = "none"
            ret['department'] = "none"
            ret['company'] = "none"
            
            if instance.tmp_approver:
                if instance.form_code.status == '' or instance.form_code.status == 'Draft':
                    if instance.tmp_approver.delegation.lower() == 'requestor':
                        ret['is_editable'] = False
                    elif instance.tmp_approver.user:
                        ret['is_editable'] = False
                    else:
                        ret['is_editable'] = True
                else:
                    ret['is_editable'] = False    
            else:
                ret['is_editable'] = False

            return ret

    class Meta:
        model = models.ChangeRequestFormApprovers
        fields = '__all__'
        read_only_fields = ['created', 'code']

