import configparser
import shutil
import os
from django.shortcuts import render
from rest_framework import viewsets
from rest_framework.views import APIView
from app.entities import models

from datetime import datetime
from datetime import timedelta

from rest_framework.response import Response
from rest_framework import status, views

from rest_framework.decorators import action
from django.http import Http404
from django.db.models import Q
import requests
from django.conf import settings
from rest_framework.exceptions import ValidationError
from django.db import transaction, IntegrityError, connection
from app.applicationlayer.utils import (QuerySetHelper,
                                        status_message_response,
                                        send_broadcast_message)
from app.businesslayer.changerequest import change_request

from app.applicationlayer.cms.utils_cr import (number_generator,
                                               send_mail_requestor,
                                               next_approver_email,
                                               crhistory_save,
                                               send_mail_vendor,
                                               get_max_batchno,
                                               generate_template_id,
                                               crhistory_create_save,
                                               entity_log_bulk,
                                               reminder_trigger_save,
                                               overdue_trigger_save,
                                               reset_autoemail_tables)

from app.entities import enums
from app.applicationlayer.utils import model_to_dict
import json
from django.shortcuts import get_object_or_404
from django.db.models import Min
from app.applicationlayer.utils import (CustomPagination,
                                        status_message_response)

from rest_framework.exceptions import ParseError
from app.businesslayer.changerequest.change_request import (
    form_add_edit_delete
)

from app.applicationlayer.cms.form.approver.serializers import ChangeRequestFormApproversSerializer
from app.applicationlayer.cms.form.stakeholder.serializers import ChangeRequestFormStakeHoldersSerializer
from app.applicationlayer.cms.form.details.serializers import ChangeRequestFormDetailsSerializer
from app.applicationlayer.cms.form.attachment.serializers import (
    ChangeRequestFormAttachmentsFileUploadSerializer,
    ChangeRequestFormAttachmentsSerializer)
from app.applicationlayer.cms.form.header.serializers import (
    ChangeRequestFormHeaderSerializer,
    ChangeRequestFormHeaderSerializerList)
from app.applicationlayer.cms.form.header.table_filters import HeaderFilterSet

from rest_framework.filters import SearchFilter, OrderingFilter
from django_filters import rest_framework as filters
from django_filters.rest_framework import DjangoFilterBackend
import json
from app.applicationlayer.utils import main_threading

from django.core.files.base import ContentFile
from django.conf import settings
from io import BytesIO
from django.http import HttpResponse
from xhtml2pdf import pisa


config = configparser.ConfigParser()
config_file = os.path.join('./', 'env.ini')
config.read(config_file)

APPROVER_MESSAGE = settings.APPROVER_MESSAGE
REQUESTOR_MESSAGE = settings.REQUESTOR_MESSAGE
REQUESTOR_REJECT_MESSAGE = settings.REQUESTOR_REJECT_MESSAGE
VENDOR_ACKNOWLEDGE_MESSAGE = settings.VENDOR_ACKNOWLEDGE_MESSAGE
REQUESTOR_ACKNOWLEDGE_MESSAGE = settings.REQUESTOR_ACKNOWLEDGE_MESSAGE
REQUESTOR_COMPLETION_MESSAGE = settings.REQUESTOR_COMPLETION_MESSAGE
VENDOR_ACCEPTANCE_MESSAGE = settings.VENDOR_ACCEPTANCE_MESSAGE
VENDOR_REJECT_MESSAGE = settings.VENDOR_REJECT_MESSAGE


class ChangeRequestFormsViewset(viewsets.ModelViewSet):

    queryset = models.ChangeRequestFormHeader.objects.select_related(
        'requested_by_user', 'requested_by_department', 'template_no'
    ).all()
    serializer_class = ChangeRequestFormHeaderSerializer
    pagination_class = CustomPagination
    lookup_field = 'form_code'
    filter_backends = (DjangoFilterBackend, SearchFilter, OrderingFilter)
    filterset_class = HeaderFilterSet
    ordering_fields = (
        'form_code',
        'requested_to_template_id',
        'requested_to_user__name',
        'requested_to_department__company__name',
        'requested_to_department__name',
        'requested_by_user__name',
        'status',
        'requested_to_priority',
        'created',
        'requested_to_target_date'
    )

    search_fields = (
        "form_code", "status", "requested_to_template_id", "requested_by_user__name",
        "requested_by_user__code", "requested_by_department__name",
        "requested_to_company__name", "requested_to_department__name",
        "requested_to_user__name", "requested_to_template_name",
        "requested_to_objective", "requested_to_priority", "description"
    )

    def list(self, request, *args, **kwargs):
        
        self.serializer_class = ChangeRequestFormHeaderSerializerList
        
        behalf_user = self.request.user.code

        user_active_included = []
        active_users = models.ChangeRequestSettings.objects.filter(
            behalf_user=behalf_user)
        
        for active_user in active_users:
            user_active_included.append(active_user.active_user.code)

        self.queryset = change_request.list_by_onbehalf_without_dept(
            user_active_included)
        
        self.queryset = change_request.filter_onbehalf_crlist(
            self.queryset,
            user_active_included)

        self.queryset = change_request.filter_base(
            self.queryset,
            request.query_params.get('company_requested_to'),
            request.query_params.get('department_requested_to'),
            request.query_params.get('date_modified_from'),
            request.query_params.get('date_modified_to'),
            request.query_params.get('date_required_from'),
            request.query_params.get('date_required_to'),
            request.query_params.get('form_type'),
        )
        
        queryset = self.filter_queryset(self.queryset)

        page = self.paginate_queryset(queryset)
        
        if page is not None:
            serializer = self.get_serializer(page, many=True)

            message = status_message_response(
                200,
                'success',
                'List of Change Request Forms for on behalf found',
                serializer.data
            )

            return self.get_paginated_response(message)

        serializer = self.get_serializer(self.queryset, many=True)

        return Response(
            serializer.data,
            status=status.HTTP_200_OK
        )
            
    def retrieve(self, request, *args, **kwargs):
        id_number = self.request.user.code
        form_code = kwargs['form_code']

        instance = self.get_object()
        serializer = self.get_serializer(instance)
        
        return Response(serializer.data)
