from rest_framework import viewsets, status
from rest_framework.response import Response
from app.applicationlayer.utils import model_to_dict
from rest_framework.filters import SearchFilter, OrderingFilter
from django_filters import rest_framework as filters
from app.entities.models import Department
from app.applicationlayer.utils import (
    CustomPagination, status_message_response
)

from django_filters.rest_framework import DjangoFilterBackend
from app.businesslayer.department import serializer
from app.businesslayer.department.table_filters import AdminDepartmentFilterSet
from app.helper.decorators import rms


class AdminDepartmentViewSet(viewsets.ModelViewSet):
    queryset = Department.objects.all()
    serializer_class = serializer.AdminDepartmentSerializer
    pagination_class = CustomPagination
    filter_backends = (DjangoFilterBackend, SearchFilter, OrderingFilter)
    filterset_class = AdminDepartmentFilterSet
    ordering_fields = '__all__'
    search_fields = ('name',)

    @rms.department_list
    def list(self, request, *args, **kwargs):

        queryset = self.filter_queryset(self.get_queryset())
        page = self.paginate_queryset(queryset)

        if page is not None:
            serializer = self.get_serializer(page, many=True)

            message = status_message_response(
                200,
                'success',
                'list of Department found',
                serializer.data
            )
            return self.get_paginated_response(message)

        serializer = self.get_serializer(queryset, many=True)
        return Response(serializer.data)
