from .base import *
import configparser

DEBUG = True

ALLOWED_HOSTS = ['*']

config = configparser.ConfigParser()
config_file = os.path.join('./', 'env.ini')
config.read(config_file)

DATABASES = {
    'default': {
        'ENGINE': config['DEV']['DATABASE_ENGINE'],
        'NAME': config['DEV']['DATABASE_NAME'],
        'USER': config['DEV']['DATABASE_USER'],
        'PASSWORD': config['DEV']['DATABASE_PASSWORD'],
        'HOST': config['DEV']['DATABASE_HOST'],
        'PORT': config['DEV']['DATABASE_PORT'],
    }
}

# ****************
# PROGRAM SETTINGS
# ****************
SESSION_TIMEOUT = config['DEV']['SESSION_TIMEOUT']
FRONT_END_URL = config['DEV']['FRONT_END_URL']
AUTH_ACCESSS_TOKEN_TIMEOUT = config['DEV']['AUTH_ACCESSS_TOKEN_TIMEOUT']
USER_DEFAULT_PASSWORD = config['DEV']['USER_DEFAULT_PASSWORD']
REALTIMESERVER_IP = config['NOTIFICATION']['REALTIMESERVER_IP']