from app.entities import models
from rest_framework import serializers
from django.db.models import Q
from django.conf import settings
from app.applicationlayer.utils import model_to_dict
from drf_writable_nested import WritableNestedModelSerializer
from app.applicationlayer.cms.utils_cr import (get_account_details,
                                               get_dept_details,
                                               get_companies_details)


from app.applicationlayer.cms.template.approver.serializers import ChangeRequestTemplateApproversSerializer
from app.applicationlayer.cms.template.stakeholder.serializers import ChangeRequestTemplateStakeHoldersSerializer
from app.applicationlayer.cms.template.attachment.serializers import ChangeRequestTemplateAttachmentsSerializer
from app.applicationlayer.cms.template.details.serializers import ChangeRequestTemplateDetailsSerializer

from django.conf import settings

from rest_framework.exceptions import ValidationError
from app.applicationlayer.cms.utils_cr import (
    BadRequestException
)


class ChangeRequestTemplatesSerializer(
    serializers.ModelSerializer
):
    tmp_approvers = ChangeRequestTemplateApproversSerializer(
        many=True, read_only=True)
    tmp_stakes = ChangeRequestTemplateStakeHoldersSerializer(
        many=True, read_only=True)
    tmp_attachments = ChangeRequestTemplateAttachmentsSerializer(
        many=True, read_only=True)
    tmp_details = ChangeRequestTemplateDetailsSerializer(
        many=True, read_only=True)

    def to_representation(self, instance):
        ret = super().to_representation(instance)
        try:
            requested_to_user_object = {
                "id": instance.requested_to_user.id,
                "name": instance.requested_to_user.name,
                "username": instance.requested_to_user.username,
                "code": instance.requested_to_user.code,
                "email": instance.requested_to_user.email,
                "contact_no": instance.requested_to_user.contact_no,
                "company_code": instance.requested_to_user.department.company.code,
                "company_name": instance.requested_to_user.department.company.name,
                "department_code": instance.requested_to_user.department.code,
                "department_name": instance.requested_to_user.department.name
            }
            
            ret['requested_to_company'] = {
                "id": instance.requested_to_company.id,
                "code": instance.requested_to_company.code,
                "name": instance.requested_to_company.name
            }
            ret['requested_to_department'] = {
                "id": instance.requested_to_department.id,
                "code": instance.requested_to_department.code,
                "name": instance.requested_to_department.name
            }
            ret['requested_to_user'] = requested_to_user_object

            ret['company'] = instance.requested_to_company.name
            ret['department'] = instance.requested_to_department.name
            ret['point_of_contact'] = instance.requested_to_user.name
            ret['created_by'] = instance.created_by_user.name

            return ret

        except Exception as e:
            
            ret['requested_to_company'] = "none"
            ret['requested_to_department'] = "none"
            ret['requested_to_user'] = "none"

            ret['company'] = "none"
            ret['department'] = "none"
            ret['point_of_contact'] = "none"
            ret['created_by'] = "none"

            return ret
    
    class Meta:
        model = models.ChangeRequestTemplateHeader
        fields = ('template_no', 'requested_to_template_name',
                  'requested_to_objective', 'requested_to_target_date',
                  'requested_to_priority', 'description', 'created',
                  'requested_to_template_id', 'requested_to_company',
                  'requested_to_department', 'requested_to_user',
                  'created_by_user', 'created_by_department',
                  'tmp_approvers', 'tmp_stakes', 'tmp_attachments',
                  'tmp_details')

        read_only_fields = ['created', 'template_no']


class ChangeRequestTemplatesSerializerList(
    serializers.ModelSerializer
):

    def to_representation(self, instance):
        ret = super().to_representation(instance)
        try:
            ret['company'] = instance.requested_to_company.name
            ret['department'] = instance.requested_to_department.name
            ret['point_of_contact'] = instance.requested_to_user.name
            ret['created_by'] = instance.created_by_user.name
            child = models.ChangeRequestFormHeader.objects.filter(
                template_no=instance.template_no
            )


            can_delete = ''

            if child.count() > 0:

                can_delete = False

            else:

                can_delete = True

            ret['can_delete'] = can_delete

            return ret
        except Exception as e:
            ret['company'] = "none"
            ret['department'] = "none"
            ret['point_of_contact'] = "none"
            ret['created_by'] = "none"
            
            return ret

    class Meta:
        model = models.ChangeRequestTemplateHeader
        fields = '__all__'
        read_only_fields = ['created', 'template_no']