from django.shortcuts import render

from rest_framework import viewsets as meviewsets
from rest_framework.views import APIView
from app.applicationlayer.cms.form import serializers
from app.entities import models
from app.applicationlayer import paginators

from datetime import datetime
from datetime import timedelta

from rest_framework.response import Response
from rest_framework import status, views

from rest_framework.decorators import action
from django.http import Http404

from django.db.models import Q
import requests
from django.conf import settings
from rest_framework.exceptions import ValidationError
from django.db import transaction, IntegrityError, connection
from app.applicationlayer.utils import QuerySetHelper
from app.businesslayer.changerequest import change_request
from app.applicationlayer.cms.utils_cr import (number_generator,
                                               send_mail_requestor,
                                               next_approver_email,
                                               crhistory_save,
                                               send_mail_vendor)
from app.entities import enums
from django.forms.models import model_to_dict
import json
from django.shortcuts import get_object_or_404


APPROVER_MESSAGE = settings.APPROVER_MESSAGE
REQUESTOR_MESSAGE = settings.REQUESTOR_MESSAGE
REQUESTOR_REJECT_MESSAGE = settings.REQUESTOR_REJECT_MESSAGE
VENDOR_ACKNOWLEDGE_MESSAGE = settings.VENDOR_ACKNOWLEDGE_MESSAGE
REQUESTOR_ACKNOWLEDGE_MESSAGE = settings.REQUESTOR_ACKNOWLEDGE_MESSAGE
REQUESTOR_COMPLETION_MESSAGE = settings.REQUESTOR_COMPLETION_MESSAGE
VENDOR_ACCEPTANCE_MESSAGE = settings.VENDOR_ACCEPTANCE_MESSAGE
VENDOR_REJECT_MESSAGE = settings.VENDOR_REJECT_MESSAGE


# Change Request Form Views

class ChangeRequestFormsViewset(meviewsets.ModelViewSet):

    serializer_class = serializers.ChangeRequestFormHeaderSerializer
    pagination_class = paginators.SimplePageNumberPagination
    queryset = models.ChangeRequestFormHeader.objects.all()
    lookup_field = 'form_code'

    def list(self, request, *args, **kwargs):
        id_number = self.request.user.code
        
        self.queryset = change_request.list_by_user(id_number)
        
        self.queryset = change_request.filter_base(
            self.queryset,
            request.query_params.get('company_requested_to'),
            request.query_params.get('department_requested_to'),
            request.query_params.get('date_modified_from'),
            request.query_params.get('date_modified_to'),
            request.query_params.get('date_required_from'),
            request.query_params.get('date_required_to'),
            request.query_params.get('form_type'),
        )

        if self.request.query_params.get('search'):
            search_key = self.request.query_params.get('search')
        
            self.queryset = self.queryset.filter(
                Q(requested_to_template_name__icontains=search_key.lower()) |
                Q(requested_to_template_id__icontains=search_key.lower())
            )
        
        self.queryset = self.queryset.order_by('-created')
        self.queryset = QuerySetHelper.Sort(self)
        
        return super(ChangeRequestFormsViewset, self).list(request)

    @action(detail=False,
            methods=['get'],
            url_path='dashboard',
            name="Dashboard Summary")
    def dashboard_view(self, request):
        id_number = self.request.user.code
        
        self.queryset = change_request.list_by_user(id_number)

        self.queryset = change_request.filter_base(
            self.queryset,
            request.query_params.get('company_requested_to'),
            request.query_params.get('department_requested_to'),
            request.query_params.get('date_modified_from'),
            request.query_params.get('date_modified_to'),
            request.query_params.get('date_required_from'),
            request.query_params.get('date_required_to'),
            request.query_params.get('form_type'),
        )

        pending = self.queryset.filter(
            status__iexact='Pending'
        ).count()

        approved = self.queryset.filter(
            status__iexact='Approved'
        ).count()

        rejected = self.queryset.filter(
            status__iexact='Rejected'
        ).count()

        cancelled = self.queryset.filter(
            status__iexact='Cancelled'
        ).count()

        completed = self.queryset.filter(
            status__iexact='Closed'  #Completed
        ).count()

        high = self.queryset.filter(
            requested_to_priority='High'
        ).count()

        normal = self.queryset.filter(
            requested_to_priority='Normal'
        ).count()

        awaiting_filtered = change_request.filter_awaiting(self.queryset, id_number)

        # awaiting = awaiting_filtered.count()
        awaiting = 0

        for awaits in awaiting_filtered:

            if awaits.status.lower() == 'rejected':
                print("rejected")
            elif awaits.status.lower() == 'closed':
                print("closed")
            elif awaits.status.lower() == 'cancelled':
                print("cancelled")
            else:
                awaiting = awaiting + 1
        
        overdue_filtered = change_request.filter_overdue(self.queryset)

        overdue = overdue_filtered.count()
        
        message = {
            'account_no': id_number,
            'pending': pending,
            'approved': approved,
            'rejected': rejected,
            'cancelled': cancelled,
            'completed': completed,
            'high': high,
            'normal': normal,
            'awaiting': awaiting,
            'overdue': overdue,
            'code': 200,
            'status': 'success',
            'message': 'Dashboard Summary'
        }
       
        return Response(message, status=status.HTTP_200_OK)        

    @action(detail=False,
            methods=['get'],
            url_path='status',
            name="Dashboard Summary Status")
    def list_by_status_view(self, request):

        id_number = self.request.user.code

        self.queryset = change_request.list_by_user(id_number)

        self.queryset = change_request.filter_status(
            self.queryset,
            request.query_params.get('status')
        )

        self.queryset = change_request.filter_base(
            self.queryset,
            request.query_params.get('company_requested_to'),
            request.query_params.get('department_requested_to'),
            request.query_params.get('date_modified_from'),
            request.query_params.get('date_modified_to'),
            request.query_params.get('date_required_from'),
            request.query_params.get('date_required_to'),
            request.query_params.get('form_type'),
        )
        
        self.queryset = self.queryset.order_by('-created')
        self.queryset = QuerySetHelper.Sort(self)
        # self.queryset = QuerySetHelper.Filter(self)
        return super(ChangeRequestFormsViewset, self).list(request)
    
    
    @action(detail=False,
            methods=['get'],
            url_path='overdue',
            name="Dashboard Summary Overdue")
    def list_by_overdue_view(self, request):

        id_number = self.request.user.code

        self.queryset = change_request.list_by_user(id_number)

        self.queryset = change_request.filter_overdue(self.queryset)

        self.queryset = change_request.filter_base(
            self.queryset,
            request.query_params.get('company_requested_to'),
            request.query_params.get('department_requested_to'),
            request.query_params.get('date_modified_from'),
            request.query_params.get('date_modified_to'),
            request.query_params.get('date_required_from'),
            request.query_params.get('date_required_to'),
            request.query_params.get('form_type'),
        )

        self.queryset = self.queryset.order_by('-created')
        self.queryset = QuerySetHelper.Sort(self)
        return super(ChangeRequestFormsViewset, self).list(request)


    @action(detail=False,
            methods=['get'],
            url_path='awaiting',
            name="Dashboard Summary Awaiting")
    def list_by_awaiting_view(self, request):

        id_number = self.request.user.code

        self.queryset = change_request.list_by_user(id_number)

        self.queryset = change_request.filter_awaiting(self.queryset, id_number.code)

        self.queryset = change_request.filter_base(
            self.queryset,
            request.query_params.get('company_requested_to'),
            request.query_params.get('department_requested_to'),
            request.query_params.get('date_modified_from'),
            request.query_params.get('date_modified_to'),
            request.query_params.get('date_required_from'),
            request.query_params.get('date_required_to'),
            request.query_params.get('form_type'),
        )

        self.queryset = self.queryset.filter(
            ~Q(status='Rejected') | 
            ~Q(status='Closed') | 
            ~Q(status='Cancelled'))
        
        self.queryset = self.queryset.order_by('-created')
        self.queryset = QuerySetHelper.Sort(self)
        return super(ChangeRequestFormsViewset, self).list(request)


    def retrieve(self, request, *args, **kwargs):
        instance = self.queryset.filter(
            form_code=str(self.kwargs.get('form_code'))
        ).first()
        serializer = self.get_serializer(instance)
        return Response(serializer.data)

    @action(
        methods=['PATCH'], detail=True,
        url_path='re_route', url_name='re_route'
    )
    def re_route(self, request, *args, **kwargs):

        form_code = kwargs['form_code']
        
        # get old data
        old_instance = models.ChangeRequestFormHeader.objects.filter(
            form_code=form_code).values()

        old_instance = list(old_instance)

        # update status to pending
        models.ChangeRequestFormHeader.objects.filter(
            form_code=form_code).update(status='Pending')

        # get new data
        new_instance = models.ChangeRequestFormHeader.objects.filter(
            form_code=form_code).values()

        new_instance = list(new_instance)
        
        # save history in form header
        crhistory_save(
            "BATCH-20190920-000001",
            enums.CREnum.REROUTE.value,
            enums.CREnum.UPDATE.value,
            enums.CREntitiesEnum.CR_FRM_HEADER.value,
            form_code,
            old_instance,
            new_instance
        )
        
        # get all approvers of form
        approvers = models.ChangeRequestFormApprovers.objects.filter(
            form_code=form_code)
        
        for approver in approvers:
            # get old data
            old_instance = models.ChangeRequestFormApprovers.objects.filter(
                code=approver.code).values()

            old_instance = list(old_instance)

            # reset details
            models.ChangeRequestFormApprovers.objects.filter(
                code=approver.code).update(action=None, remarks=None,
                                           date_sent=None, created=None)

            # get new data
            new_instance = models.ChangeRequestFormApprovers.objects.filter(
                code=approver.code).values()
            
            new_instance = list(new_instance)

            # save history in form approver
            crhistory_save(
                "BATCH-20190920-000001",
                enums.CREnum.REROUTE.value,
                enums.CREnum.UPDATE.value,
                enums.CREntitiesEnum.CR_FRM_APPROVER.value,
                form_code,
                old_instance,
                new_instance
            )
        
        return Response(
            "Change request form successfully re routed",
                status=status.HTTP_200_OK
        )
    
    @action(
        methods=['PATCH'], detail=True,
        url_path='re_submit', url_name='re_submit'
    )
    def re_submit(self, request, *args, **kwargs):

        form_code = kwargs['form_code']

        # get old data
        old_instance = models.ChangeRequestFormHeader.objects.filter(
            form_code=form_code).values()

        old_instance = list(old_instance)
        
        # get template no
        tmp_no = models.ChangeRequestFormHeader.objects.values_list(
            'template_no', flat=True).get(form_code=form_code)
        
        # count total records in cr
        frm_count = models.ChangeRequestFormHeader.objects.all().count()
        frm_count = frm_count + 1
        
        # get prefix of template
        CR_Prefix = models.ChangeRequestTemplateHeader.objects.values_list(
            'requested_to_template_id', flat=True).get(template_no=tmp_no)
        
        # generate new template id
        generate_tmp = number_generator(CR_Prefix, frm_count)

        # update form header to draft and update new template id
        models.ChangeRequestFormHeader.objects.filter(
            form_code=form_code).update(requested_to_template_id=generate_tmp,
                                        status='Draft')

        # get new data
        new_instance = models.ChangeRequestFormHeader.objects.filter(
            form_code=form_code).values()

        new_instance = list(new_instance)
        
        # save history in form header
        crhistory_save(
            "BATCH-20190920-000001",
            enums.CREnum.RESUBMIT.value,
            enums.CREnum.UPDATE.value,
            enums.CREntitiesEnum.CR_FRM_HEADER.value,
            form_code,
            old_instance,
            new_instance
        )
        
        # get all approvers of form
        approvers = models.ChangeRequestFormApprovers.objects.filter(
            form_code=form_code)
        
        for approver in approvers:
            # get old data
            old_instance = models.ChangeRequestFormApprovers.objects.filter(
                code=approver.code).values()

            old_instance = list(old_instance)

            # reset details
            models.ChangeRequestFormApprovers.objects.filter(
                code=approver.code).update(action=None, remarks=None,
                                           date_sent=None, created=None)

            # get new data
            new_instance = models.ChangeRequestFormApprovers.objects.filter(
                code=approver.code).values()
            
            new_instance = list(new_instance)

            # save history in form approver
            crhistory_save(
                "BATCH-20190920-000001",
                enums.CREnum.RESUBMIT.value,
                enums.CREnum.UPDATE.value,
                enums.CREntitiesEnum.CR_FRM_APPROVER.value,
                form_code,
                old_instance,
                new_instance
            )
        
        return Response(
            "Change request form successfully resubmitted",
                status=status.HTTP_200_OK
        )

    # actions
    @action(
        methods=['PATCH'], detail=False,
        url_path='actions', url_name='actions'
    )
    def actions(self, request, *args, **kwargs):
        
        # get request data
        id = request.data['id']
        # current_user = request.data['user']
        current_user = self.request.user.code
        form_code = request.data['form_code']
        delegation = request.data['delegation']
        action = request.data['action']
        level = request.data['level']
        next_level = int(request.data['level']) + 1
        remarks = request.data['remarks']

        # get old data
        old_instance = models.ChangeRequestFormApprovers.objects.filter(
            pk=id).values()

        old_instance = list(old_instance)
        
        # update current row in routing table
        models.ChangeRequestFormApprovers.objects.filter(
                                    pk=id).update(action=action,
                                                  remarks=remarks,
                                                  action_date=datetime.now())
        
        # get new data
        new_instance = models.ChangeRequestFormApprovers.objects.filter(
            pk=id).values()
        
        new_instance = list(new_instance)

        crenum = action.upper()
        # save history in form approver
        crhistory_save(
            "BATCH-20190920-000001",
            "ACTION",
            crenum,
            enums.CREntitiesEnum.CR_FRM_APPROVER.value,
            form_code,
            old_instance,
            new_instance
        )

        # get details of next approver/s
        next_approver = models.ChangeRequestFormApprovers.objects.filter(
                                                    level=str(next_level),
                                                    form_code=form_code
                                                    )
        if action.lower() == 'approved':
            
            # NOTIF MSG FOR REQUESTOR
            requestor_notification_msg = REQUESTOR_MESSAGE.split(';')[0]
            
            # NOTIF MSG FOR NEXT APPROVER
            notification_msg = APPROVER_MESSAGE.split(';')[0]
            
            # SEND EMAIL AND NOTIF TO REQUESTOR
            send_mail_requestor(
                current_user, form_code, delegation,
                requestor_notification_msg, action,
                remarks, level
            )

            # LOOP on next approver for sending email
            for n_approver in next_approver:
                
                if n_approver.delegation.lower() == 'vendor/implementor':
                    notification_msg = VENDOR_ACKNOWLEDGE_MESSAGE.split(';')[0]
                    
                next_approver_email(
                    n_approver.user.code, form_code, delegation,
                    notification_msg
                )
            
            # update next approver details
            models.ChangeRequestFormApprovers.objects.filter(
                Q(form_code=form_code) & Q(level=str(next_level))
                ).update(
                    date_sent=datetime.now()
                )

        elif action.lower() == 'rejected':
            
            # send email to vendor
            if delegation.lower() == 'requestor':
                notification_msg = VENDOR_REJECT_MESSAGE.split(';')[0]
                
                send_mail_vendor(
                    current_user, form_code, delegation,
                    notification_msg, action,
                    remarks, level
                )
            
            else:
                # EMAIL CODE FOR REQUESTOR
                requestor_notification_msg = REQUESTOR_REJECT_MESSAGE.split(';')[0]
                
                # SEND EMAIL AND NOTIF TO REQUESTOR
                send_mail_requestor(
                    current_user, form_code, delegation,
                    requestor_notification_msg, action,
                    remarks, level
                )

        elif action.lower() == 'completed':

            # EMAIL CODE FOR REQUESTOR
            requestor_notification_msg = REQUESTOR_COMPLETION_MESSAGE.split(';')[0]
            
            send_mail_requestor(
                current_user, form_code, delegation,
                requestor_notification_msg, action,
                remarks, level
            )

            models.ChangeRequestFormApprovers.objects.filter(
                Q(level=str(next_level))
                ).update(
                    date_sent=datetime.now()
            )

        elif action.lower() == 'acknowledged':

            # EMAIL CODE FOR REQUESTOR
            requestor_notification_msg = REQUESTOR_ACKNOWLEDGE_MESSAGE.split(';')[0]
            
            send_mail_requestor(
                current_user, form_code, delegation,
                requestor_notification_msg, action,
                remarks, level
            )

        elif action.lower() == 'accepted':

            # EMAIL CODE FOR VENDOR
            requestor_notification_msg = VENDOR_ACCEPTANCE_MESSAGE.split(';')[0]

            send_mail_vendor(
                current_user, form_code, delegation,
                requestor_notification_msg, action,
                remarks, level
            )

        elif action.lower() == 'cancelled':
            
            # changed form status to cancelled

            models.ChangeRequestFormHeader.objects.filter(
                form_code=form_code).update(status='Cancelled')

        return Response(
            "Action performed",
                status=status.HTTP_200_OK
        )

    
    @action(
        methods=['PATCH'], detail=True,
        url_path='save', url_name='save'
    )
    def save(self, request, *args, **kwargs):
        
        form_code = kwargs['form_code']
        form_header_data = request.data

        # get pk
        frm_id = models.ChangeRequestFormHeader.objects.get(form_code=form_code)
        
        # get old data
        old_instance = models.ChangeRequestFormHeader.objects.filter(
            form_code=form_code).values()

        old_instance = list(old_instance)

        # get data CR Form Header
        form_header = get_object_or_404(
            models.ChangeRequestFormHeader.objects.all(), pk=frm_id.id)
        
        serializer = serializers.ChangeRequestFormHeaderSerializer(
            form_header, data=form_header_data)

        if serializer.is_valid():
            serializer.save()
        
        # get new data
        new_instance = models.ChangeRequestFormHeader.objects.filter(
            form_code=form_code).values()

        new_instance = list(new_instance)
        
        # save history in form header
        crhistory_save(
            "BATCH-20190920-000001",
            enums.CREnum.SAVE.value,
            enums.CREnum.UPDATE.value,
            enums.CREntitiesEnum.CR_FRM_HEADER.value,
            form_code,
            old_instance,
            new_instance
        )

        # ---------------------------------------------------------------------
        # get approvers data
        approver_id = models.ChangeRequestFormApprovers.objects.filter(
            form_code=form_code)

        # list existing id to variable
        existing_approver_ids = [item.id for item in approver_id]

        frm_approvers = form_header_data['frm_approvers']

        updated_approver_ids = []

        # get all ids
        for frm_approver in frm_approvers:
            if "id" in frm_approver:
                updated_approver_ids.append(frm_approver['id'])
        
        # Delete any approvers not included in the request
        for e in existing_approver_ids:
            if e not in updated_approver_ids:
                
                # get old data
                old_instance = models.ChangeRequestFormApprovers.objects.filter(
                    pk=e).values()

                old_instance = list(old_instance)

                models.ChangeRequestFormApprovers.objects.filter(
                    pk=e).delete()

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SAVE.value,
                    enums.CREnum.DELETED.value,
                    enums.CREntitiesEnum.CR_FRM_APPROVER.value,
                    form_code,
                    old_instance,
                    None
                )
        
        # Create or update approver data that are in the request
        for frm_approver in frm_approvers:
            
            if "id" in frm_approver:

                # get old data
                old_instance = models.ChangeRequestFormApprovers.objects.filter(
                    pk=frm_approver['id']).values()

                old_instance = list(old_instance)
                
                models.ChangeRequestFormApprovers.objects.filter(
                    pk=frm_approver['id']).update(level=frm_approver['level'],
                                    delegation=frm_approver['delegation'],
                                    created=datetime.now(),
                                    remarks=None,
                                    action=None,
                                    action_date=None,
                                    date_sent=None,
                                    user=frm_approver['user'],
                                    tmp_approver=frm_approver['tmp_approver'])

                # get new data
                new_instance = models.ChangeRequestFormApprovers.objects.filter(
                    pk=frm_approver['id']).values()
                
                new_instance = list(new_instance)

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SAVE.value,
                    enums.CREnum.UPDATE.value,
                    enums.CREntitiesEnum.CR_FRM_APPROVER.value,
                    form_code,
                    old_instance,
                    new_instance
                )

            else:

                user_instance = models.User.objects.get(
                                    code=frm_approver['user'])
                
                cre = models.ChangeRequestFormApprovers.objects.create(
                                    level=frm_approver['level'],
                                    delegation=frm_approver['delegation'],
                                    created=datetime.now(),
                                    user=user_instance,
                                    form_code=frm_id,
                                    code='try')

                code = number_generator(enums.GenerateCode.FORM_APPROVER.value, cre.id)
                
                models.ChangeRequestFormApprovers.objects.filter(
                                    id=cre.id).update(code=code)

                # get new data
                new_instance = models.ChangeRequestFormApprovers.objects.filter(
                    pk=cre.id).values()
                
                new_instance = list(new_instance)

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SAVE.value,
                    enums.CREnum.ADD.value,
                    enums.CREntitiesEnum.CR_FRM_APPROVER.value,
                    form_code,
                    None,
                    new_instance
                )
        # ---------------------------------------------------------------------
        # get stakes data
        stakes_id = models.ChangeRequestFormStakeHolders.objects.filter(
            form_code=form_code)

        # list existing id to variable
        existing_stakes_ids = [item.id for item in stakes_id]

        frm_stakes = form_header_data['frm_stakes']

        updated_stakes_ids = []
        
        # get all ids
        for frm_stake in frm_stakes:
            if "id" in frm_stake:
                updated_stakes_ids.append(frm_stake['id'])
        
        # Delete any stakes not included in the request
        for e in existing_stakes_ids:
            if e not in updated_stakes_ids:

                # get old data
                old_instance = models.ChangeRequestFormStakeHolders.objects.filter(
                    pk=e).values()

                old_instance = list(old_instance)

                models.ChangeRequestFormStakeHolders.objects.filter(
                    pk=e).delete()

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SAVE.value,
                    enums.CREnum.DELETED.value,
                    enums.CREntitiesEnum.CR_FRM_STAKE.value,
                    form_code,
                    old_instance,
                    None
                )
        
        # Create or update stake data that are in the request
        for frm_stake in frm_stakes:
            
            if "id" in frm_stake:

                # get old data
                old_instance = models.ChangeRequestFormStakeHolders.objects.filter(
                    pk=frm_stake['id']).values()

                old_instance = list(old_instance)
                
                models.ChangeRequestFormStakeHolders.objects.filter(
                    pk=frm_stake['id']).update(
                                    delegation=frm_stake['delegation'],
                                    created=datetime.now(),
                                    user=frm_stake['user'],
                                    tmp_stake=frm_stake['tmp_stake'])

                # get new data
                new_instance = models.ChangeRequestFormStakeHolders.objects.filter(
                    pk=frm_stake['id']).values()
                
                new_instance = list(new_instance)

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SAVE.value,
                    enums.CREnum.UPDATE.value,
                    enums.CREntitiesEnum.CR_FRM_STAKE.value,
                    form_code,
                    old_instance,
                    new_instance
                )
            else:
                
                user_instance = models.User.objects.get(
                                    code=frm_stake['user'])
                
                cre = models.ChangeRequestFormStakeHolders.objects.create(
                                    delegation=frm_stake['delegation'],
                                    created=datetime.now(),
                                    user=user_instance,
                                    form_code=frm_id,
                                    code='try')

                code = number_generator(enums.GenerateCode.FORM_STAKE.value, cre.id)
                
                models.ChangeRequestFormStakeHolders.objects.filter(
                                    id=cre.id).update(code=code)

                # get new data
                new_instance = models.ChangeRequestFormStakeHolders.objects.filter(
                    pk=cre.id).values()
                
                new_instance = list(new_instance)

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SAVE.value,
                    enums.CREnum.ADD.value,
                    enums.CREntitiesEnum.CR_FRM_STAKE.value,
                    form_code,
                    None,
                    new_instance
                )

        # ---------------------------------------------------------------------
        # get attachments data
        attach_id = models.ChangeRequestFormAttachments.objects.filter(
            form_code=form_code)

        # list existing id to variable
        existing_attach_ids = [item.id for item in attach_id]

        frm_attach = form_header_data['frm_attachments']

        updated_attach_ids = []
        
        # get all ids
        for frm_att in frm_attach:
            if "id" in frm_att:
                updated_attach_ids.append(frm_att['id'])
        
        # Delete any  attachments not included in the request
        for e in existing_attach_ids:
            if e not in updated_attach_ids:
                
                # get old data
                old_instance = models.ChangeRequestFormAttachments.objects.filter(
                    pk=e).values()

                old_instance = list(old_instance)

                models.ChangeRequestFormAttachments.objects.filter(
                    pk=e).delete()

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SAVE.value,
                    enums.CREnum.DELETED.value,
                    enums.CREntitiesEnum.CR_FRM_ATTACHMENT.value,
                    form_code,
                    old_instance,
                    None
                )
        
        # Create or update attachments data that are in the request
        for frm_att in frm_attach:
            
            if "id" in frm_att:

                # get old data
                old_instance = models.ChangeRequestFormAttachments.objects.filter(
                    pk=frm_att['id']).values()

                old_instance = list(old_instance)
                
                models.ChangeRequestFormAttachments.objects.filter(
                    pk=frm_att['id']).update(
                                    attachment_type=frm_att['attachment_type'],
                                    attachment_name=frm_att['attachment_name'],
                                    file_name=frm_att['file_name'],
                                    description=frm_att['description'],
                                    file_upload=frm_att['file_upload'],
                                    uploaded_by=frm_att['uploaded_by'],
                                    created=datetime.now())

                # get new data
                new_instance = models.ChangeRequestFormAttachments.objects.filter(
                    pk=frm_att['id']).values()
                
                new_instance = list(new_instance)

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SAVE.value,
                    enums.CREnum.UPDATE.value,
                    enums.CREntitiesEnum.CR_FRM_ATTACHMENT.value,
                    form_code,
                    old_instance,
                    new_instance
                )

            else:
                
                user_instance = models.User.objects.get(
                                    code=frm_att['uploaded_by'])
                
                cre = models.ChangeRequestFormAttachments.objects.create(
                                    attachment_type=frm_att['attachment_type'],
                                    attachment_name=frm_att['attachment_name'],
                                    file_name=frm_att['file_name'],
                                    description=frm_att['description'],
                                    file_upload=frm_att['file_upload'],
                                    uploaded_by=user_instance,
                                    created=datetime.now(),
                                    form_code=frm_id,
                                    code='try')
                
                code = number_generator(enums.GenerateCode.FORM_ATTACH.value, cre.id)
                
                models.ChangeRequestFormAttachments.objects.filter(
                                    id=cre.id).update(code=code)

                # get new data
                new_instance = models.ChangeRequestFormAttachments.objects.filter(
                    pk=cre.id).values()
                
                new_instance = list(new_instance)

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SAVE.value,
                    enums.CREnum.ADD.value,
                    enums.CREntitiesEnum.CR_FRM_ATTACHMENT.value,
                    form_code,
                    None,
                    new_instance
                )

        # ---------------------------------------------------------------------
        # get details data
        detail_id = models.ChangeRequestFormDetails.objects.filter(
            form_code=form_code)

        # list existing id to variable
        existing_detail_ids = [item.id for item in detail_id]

        frm_details = form_header_data['frm_details']

        updated_detail_ids = []
        
        # get all ids
        for frm_detail in frm_details:
            if "id" in frm_detail:
                updated_detail_ids.append(frm_detail['id'])
        
        # Delete any  attachments not included in the request
        for e in existing_detail_ids:
            if e not in updated_detail_ids:
                
                # get old data
                old_instance = models.ChangeRequestFormDetails.objects.filter(
                    pk=e).values()

                old_instance = list(old_instance)

                models.ChangeRequestFormDetails.objects.filter(
                    pk=e).delete()

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SAVE.value,
                    enums.CREnum.DELETED.value,
                    enums.CREntitiesEnum.CR_FRM_DETAIL.value,
                    form_code,
                    old_instance,
                    None
                )
        
        # Create or update attachments data that are in the request
        for frm_detail in frm_details:
            
            if "id" in frm_detail:

                # get old data
                old_instance = models.ChangeRequestFormDetails.objects.filter(
                    pk=frm_detail['id']).values()

                old_instance = list(old_instance)
                
                models.ChangeRequestFormDetails.objects.filter(
                    pk=frm_detail['id']).update(
                                    field_idx=frm_detail['field_idx'],
                                    field_ref=frm_detail['field_ref'],
                                    field_val=frm_detail['field_val'],
                                    field_props=frm_detail['field_props'],
                                    created=datetime.now())

                # get new data
                new_instance = models.ChangeRequestFormDetails.objects.filter(
                    pk=frm_detail['id']).values()
                
                new_instance = list(new_instance)

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SAVE.value,
                    enums.CREnum.UPDATE.value,
                    enums.CREntitiesEnum.CR_FRM_DETAIL.value,
                    form_code,
                    old_instance,
                    new_instance
                )

            else:
                
                cre = models.ChangeRequestFormDetails.objects.create(
                                    field_idx=frm_detail['field_idx'],
                                    field_ref=frm_detail['field_ref'],
                                    field_val=frm_detail['field_val'],
                                    field_props=frm_detail['field_props'],
                                    created=datetime.now(),
                                    code='try',
                                    form_code=frm_id)
                
                code = number_generator(enums.GenerateCode.FORM_DETAIL.value, cre.id)
                
                models.ChangeRequestFormDetails.objects.filter(
                                    id=cre.id).update(code=code)

                # get new data
                new_instance = models.ChangeRequestFormDetails.objects.filter(
                    pk=cre.id).values()
                
                new_instance = list(new_instance)

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SAVE.value,
                    enums.CREnum.ADD.value,
                    enums.CREntitiesEnum.CR_FRM_DETAIL.value,
                    form_code,
                    None,
                    new_instance
                )

        return Response(serializer.data)
        

    @action(
        methods=['PATCH'], detail=True,
        url_path='submit', url_name='submit'
    )
    def submit(self, request, *args, **kwargs):

        form_code = kwargs['form_code']
        form_header_data = request.data

        # get pk
        frm_id = models.ChangeRequestFormHeader.objects.get(form_code=form_code)
        
        # get old data
        old_instance = models.ChangeRequestFormHeader.objects.filter(
            form_code=form_code).values()

        old_instance = list(old_instance)

        # get data CR Form Header
        form_header = get_object_or_404(
            models.ChangeRequestFormHeader.objects.all(), pk=frm_id.id)
        
        serializer = serializers.ChangeRequestFormHeaderSerializer(
            form_header, data=form_header_data)

        if serializer.is_valid():
            serializer.save()
        
        # get new data
        new_instance = models.ChangeRequestFormHeader.objects.filter(
            form_code=form_code).values()

        new_instance = list(new_instance)
        
        # save history in form header
        crhistory_save(
            "BATCH-20190920-000001",
            enums.CREnum.SUBMIT.value,
            enums.CREnum.UPDATE.value,
            enums.CREntitiesEnum.CR_FRM_HEADER.value,
            form_code,
            old_instance,
            new_instance
        )

        # ---------------------------------------------------------------------
        # get approvers data
        approver_id = models.ChangeRequestFormApprovers.objects.filter(
            form_code=form_code)

        # list existing id to variable
        existing_approver_ids = [item.id for item in approver_id]

        frm_approvers = form_header_data['frm_approvers']

        updated_approver_ids = []

        # get all ids
        for frm_approver in frm_approvers:
            if "id" in frm_approver:
                updated_approver_ids.append(frm_approver['id'])
        
        # Delete any approvers not included in the request
        for e in existing_approver_ids:
            if e not in updated_approver_ids:
                
                # get old data
                old_instance = models.ChangeRequestFormApprovers.objects.filter(
                    pk=e).values()

                old_instance = list(old_instance)

                models.ChangeRequestFormApprovers.objects.filter(
                    pk=e).delete()

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SUBMIT.value,
                    enums.CREnum.DELETED.value,
                    enums.CREntitiesEnum.CR_FRM_APPROVER.value,
                    form_code,
                    old_instance,
                    None
                )
        
        # Create or update approver data that are in the request
        for frm_approver in frm_approvers:
            
            if "id" in frm_approver:

                # get old data
                old_instance = models.ChangeRequestFormApprovers.objects.filter(
                    pk=frm_approver['id']).values()

                old_instance = list(old_instance)
                
                models.ChangeRequestFormApprovers.objects.filter(
                    pk=frm_approver['id']).update(level=frm_approver['level'],
                                    delegation=frm_approver['delegation'],
                                    created=datetime.now(),
                                    remarks=None,
                                    action=None,
                                    action_date=None,
                                    date_sent=None,
                                    user=frm_approver['user'],
                                    tmp_approver=frm_approver['tmp_approver'])

                # get new data
                new_instance = models.ChangeRequestFormApprovers.objects.filter(
                    pk=frm_approver['id']).values()
                
                new_instance = list(new_instance)

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SUBMIT.value,
                    enums.CREnum.UPDATE.value,
                    enums.CREntitiesEnum.CR_FRM_APPROVER.value,
                    form_code,
                    old_instance,
                    new_instance
                )

            else:

                user_instance = models.User.objects.get(
                                    code=frm_approver['user'])
                
                cre = models.ChangeRequestFormApprovers.objects.create(
                                    level=frm_approver['level'],
                                    delegation=frm_approver['delegation'],
                                    created=datetime.now(),
                                    user=user_instance,
                                    form_code=frm_id,
                                    code='try')

                code = number_generator(enums.GenerateCode.FORM_APPROVER.value, cre.id)
                
                models.ChangeRequestFormApprovers.objects.filter(
                                    id=cre.id).update(code=code)

                # get new data
                new_instance = models.ChangeRequestFormApprovers.objects.filter(
                    pk=cre.id).values()
                
                new_instance = list(new_instance)

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SUBMIT.value,
                    enums.CREnum.ADD.value,
                    enums.CREntitiesEnum.CR_FRM_APPROVER.value,
                    form_code,
                    None,
                    new_instance
                )
        # ---------------------------------------------------------------------
        # get stakes data
        stakes_id = models.ChangeRequestFormStakeHolders.objects.filter(
            form_code=form_code)

        # list existing id to variable
        existing_stakes_ids = [item.id for item in stakes_id]

        frm_stakes = form_header_data['frm_stakes']

        updated_stakes_ids = []
        
        # get all ids
        for frm_stake in frm_stakes:
            if "id" in frm_stake:
                updated_stakes_ids.append(frm_stake['id'])
        
        # Delete any stakes not included in the request
        for e in existing_stakes_ids:
            if e not in updated_stakes_ids:

                # get old data
                old_instance = models.ChangeRequestFormStakeHolders.objects.filter(
                    pk=e).values()

                old_instance = list(old_instance)

                models.ChangeRequestFormStakeHolders.objects.filter(
                    pk=e).delete()

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SUBMIT.value,
                    enums.CREnum.DELETED.value,
                    enums.CREntitiesEnum.CR_FRM_STAKE.value,
                    form_code,
                    old_instance,
                    None
                )
        
        # Create or update stake data that are in the request
        for frm_stake in frm_stakes:
            
            if "id" in frm_stake:

                # get old data
                old_instance = models.ChangeRequestFormStakeHolders.objects.filter(
                    pk=frm_stake['id']).values()

                old_instance = list(old_instance)
                
                models.ChangeRequestFormStakeHolders.objects.filter(
                    pk=frm_stake['id']).update(
                                    delegation=frm_stake['delegation'],
                                    created=datetime.now(),
                                    user=frm_stake['user'],
                                    tmp_stake=frm_stake['tmp_stake'])

                # get new data
                new_instance = models.ChangeRequestFormStakeHolders.objects.filter(
                    pk=frm_stake['id']).values()
                
                new_instance = list(new_instance)

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SUBMIT.value,
                    enums.CREnum.UPDATE.value,
                    enums.CREntitiesEnum.CR_FRM_STAKE.value,
                    form_code,
                    old_instance,
                    new_instance
                )
            else:
                
                user_instance = models.User.objects.get(
                                    code=frm_stake['user'])
                
                cre = models.ChangeRequestFormStakeHolders.objects.create(
                                    delegation=frm_stake['delegation'],
                                    created=datetime.now(),
                                    user=user_instance,
                                    form_code=frm_id,
                                    code='try')

                code = number_generator(enums.GenerateCode.FORM_STAKE.value, cre.id)
                
                models.ChangeRequestFormStakeHolders.objects.filter(
                                    id=cre.id).update(code=code)

                # get new data
                new_instance = models.ChangeRequestFormStakeHolders.objects.filter(
                    pk=cre.id).values()
                
                new_instance = list(new_instance)

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SUBMIT.value,
                    enums.CREnum.ADD.value,
                    enums.CREntitiesEnum.CR_FRM_STAKE.value,
                    form_code,
                    None,
                    new_instance
                )

        # ---------------------------------------------------------------------
        # get attachments data
        attach_id = models.ChangeRequestFormAttachments.objects.filter(
            form_code=form_code)

        # list existing id to variable
        existing_attach_ids = [item.id for item in attach_id]

        frm_attach = form_header_data['frm_attachments']

        updated_attach_ids = []
        
        # get all ids
        for frm_att in frm_attach:
            if "id" in frm_att:
                updated_attach_ids.append(frm_att['id'])
        
        # Delete any  attachments not included in the request
        for e in existing_attach_ids:
            if e not in updated_attach_ids:
                
                # get old data
                old_instance = models.ChangeRequestFormAttachments.objects.filter(
                    pk=e).values()

                old_instance = list(old_instance)

                models.ChangeRequestFormAttachments.objects.filter(
                    pk=e).delete()

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SUBMIT.value,
                    enums.CREnum.DELETED.value,
                    enums.CREntitiesEnum.CR_FRM_ATTACHMENT.value,
                    form_code,
                    old_instance,
                    None
                )
        
        # Create or update attachments data that are in the request
        for frm_att in frm_attach:
            
            if "id" in frm_att:

                # get old data
                old_instance = models.ChangeRequestFormAttachments.objects.filter(
                    pk=frm_att['id']).values()

                old_instance = list(old_instance)
                
                models.ChangeRequestFormAttachments.objects.filter(
                    pk=frm_att['id']).update(
                                    attachment_type=frm_att['attachment_type'],
                                    attachment_name=frm_att['attachment_name'],
                                    file_name=frm_att['file_name'],
                                    description=frm_att['description'],
                                    file_upload=frm_att['file_upload'],
                                    uploaded_by=frm_att['uploaded_by'],
                                    created=datetime.now())

                # get new data
                new_instance = models.ChangeRequestFormAttachments.objects.filter(
                    pk=frm_att['id']).values()
                
                new_instance = list(new_instance)

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SUBMIT.value,
                    enums.CREnum.UPDATE.value,
                    enums.CREntitiesEnum.CR_FRM_ATTACHMENT.value,
                    form_code,
                    old_instance,
                    new_instance
                )

            else:
                
                user_instance = models.User.objects.get(
                                    code=frm_att['uploaded_by'])
                
                cre = models.ChangeRequestFormAttachments.objects.create(
                                    attachment_type=frm_att['attachment_type'],
                                    attachment_name=frm_att['attachment_name'],
                                    file_name=frm_att['file_name'],
                                    description=frm_att['description'],
                                    file_upload=frm_att['file_upload'],
                                    uploaded_by=user_instance,
                                    created=datetime.now(),
                                    form_code=frm_id,
                                    code='try')
                
                code = number_generator(enums.GenerateCode.FORM_ATTACH.value, cre.id)
                
                models.ChangeRequestFormAttachments.objects.filter(
                                    id=cre.id).update(code=code)

                # get new data
                new_instance = models.ChangeRequestFormAttachments.objects.filter(
                    pk=cre.id).values()
                
                new_instance = list(new_instance)

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SUBMIT.value,
                    enums.CREnum.ADD.value,
                    enums.CREntitiesEnum.CR_FRM_ATTACHMENT.value,
                    form_code,
                    None,
                    new_instance
                )

        # ---------------------------------------------------------------------
        # get details data
        detail_id = models.ChangeRequestFormDetails.objects.filter(
            form_code=form_code)

        # list existing id to variable
        existing_detail_ids = [item.id for item in detail_id]

        frm_details = form_header_data['frm_details']

        updated_detail_ids = []
        
        # get all ids
        for frm_detail in frm_details:
            if "id" in frm_detail:
                updated_detail_ids.append(frm_detail['id'])
        
        # Delete any  attachments not included in the request
        for e in existing_detail_ids:
            if e not in updated_detail_ids:
                
                # get old data
                old_instance = models.ChangeRequestFormDetails.objects.filter(
                    pk=e).values()

                old_instance = list(old_instance)

                models.ChangeRequestFormDetails.objects.filter(
                    pk=e).delete()

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SUBMIT.value,
                    enums.CREnum.DELETED.value,
                    enums.CREntitiesEnum.CR_FRM_DETAIL.value,
                    form_code,
                    old_instance,
                    None
                )
        
        # Create or update attachments data that are in the request
        for frm_detail in frm_details:
            
            if "id" in frm_detail:

                # get old data
                old_instance = models.ChangeRequestFormDetails.objects.filter(
                    pk=frm_detail['id']).values()

                old_instance = list(old_instance)
                
                models.ChangeRequestFormDetails.objects.filter(
                    pk=frm_detail['id']).update(
                                    field_idx=frm_detail['field_idx'],
                                    field_ref=frm_detail['field_ref'],
                                    field_val=frm_detail['field_val'],
                                    field_props=frm_detail['field_props'],
                                    created=datetime.now())

                # get new data
                new_instance = models.ChangeRequestFormDetails.objects.filter(
                    pk=frm_detail['id']).values()
                
                new_instance = list(new_instance)

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SUBMIT.value,
                    enums.CREnum.UPDATE.value,
                    enums.CREntitiesEnum.CR_FRM_DETAIL.value,
                    form_code,
                    old_instance,
                    new_instance
                )

            else:
                
                cre = models.ChangeRequestFormDetails.objects.create(
                                    field_idx=frm_detail['field_idx'],
                                    field_ref=frm_detail['field_ref'],
                                    field_val=frm_detail['field_val'],
                                    field_props=frm_detail['field_props'],
                                    created=datetime.now(),
                                    code='try',
                                    form_code=frm_id)
                
                code = number_generator(enums.GenerateCode.FORM_DETAIL.value, cre.id)
                
                models.ChangeRequestFormDetails.objects.filter(
                                    id=cre.id).update(code=code)

                # get new data
                new_instance = models.ChangeRequestFormDetails.objects.filter(
                    pk=cre.id).values()
                
                new_instance = list(new_instance)

                # save history in form approver
                crhistory_save(
                    "BATCH-20190920-000001",
                    enums.CREnum.SUBMIT.value,
                    enums.CREnum.ADD.value,
                    enums.CREntitiesEnum.CR_FRM_DETAIL.value,
                    form_code,
                    None,
                    new_instance
                )

        return Response(serializer.data)

class ChangeRequestFormApproversViewset(meviewsets.ModelViewSet):

    queryset = models.ChangeRequestFormApprovers.objects.all()
    serializer_class = serializers.ChangeRequestFormApproversSerializer
    pagination_class = paginators.SimplePageNumberPagination
    lookup_field = 'code'

    # def create(self, request, *args, **kwargs):
    #     ObjectId = request.data.get('id')
    #     sent = False
    #     if 'form_status' in request.data:
            
    #         # for email
    #         if str(request.data['level']) == '1' and request.data['form_status'].lower() == 'pending':
    #             user = request.data['user']
    #             form_code = request.data['form_code']
    #             delegation = request.data['delegation']
    #             # initial_email(user, form_code, delegation)

    #             # EMAIL CODE FOR APPROVER
    #             notification_msg = APPROVER_MESSAGE.split(';')[0]
    #             email_code = APPROVER_MESSAGE.split(';')[1]

    #             next_appover_email(
    #                 user, form_code, delegation,
    #                 notification_msg, 'initial', email_code
    #             )

    #             request.data['date_sent'] = datetime.now().strftime('%Y-%m-%d, %H:%M:%S')
    #             request.data['created'] = datetime.now().strftime('%Y-%m-%d, %H:%M:%S') #correct
    #             sent = True

    #     serializer = self.get_serializer(data=request.data)
    #     serializer.is_valid(raise_exception=True)
    
    #     if ObjectId:
    #         dbExisting = models.ChangeRequestFormApprovers.objects.filter(
    #             id=ObjectId,
    #             archived_at=None).first()

    #         if dbExisting:
    #             dbExisting.archived_at = datetime.now()
    #             dbExisting.save()

    #     # x = self.perform_create(serializer)
    #     serializer.id = None

    #     x = serializer.save()
    #     if sent == True:
    #         x.date_sent = datetime.now().strftime('%Y-%m-%d, %H:%M:%S')
    #         x.created = datetime.now().strftime('%Y-%m-%d, %H:%M:%S')  #correct
    #         x.save()

    #     headers = self.get_success_headers(serializer.data)
    #     return Response(
    #         serializer.data,
    #         status=status.HTTP_201_CREATED,
    #         headers=headers
    #     )

    def list(self, request, *args, **kwargs):
        self.queryset = QuerySetHelper.Sort(self)
        return super(ChangeRequestFormApproversViewset, self).list(request)

    def retrieve(self, request, *args, **kwargs):
        instance = self.queryset.filter(archived_at=None).first()
        serializer = self.get_serializer(instance)
        return Response(serializer.data)


class ChangeRequestFormAttachmentsViewset(meviewsets.ModelViewSet):
    queryset = models.ChangeRequestFormAttachments.objects.all()
    serializer_class = serializers.ChangeRequestFormAttachmentsSerializer
    pagination_class = paginators.SimplePageNumberPagination

    def list(self, request, *args, **kwargs):
        self.queryset = self.queryset.filter(archived_at=None)
        self.queryset = QuerySetHelper.Sort(self)
        self.queryset = QuerySetHelper.Filter(self)
        return super(
            ChangeRequestFormAttachmentsViewset, self
        ).list(request)

    def create(self, request, *args, **kwargs):
        attachment_no = request.data.get('attachment_no')
        ObjectId = request.data.get('id')
        serializer = self.get_serializer(data=request.data)
        serializer.is_valid(raise_exception=True)

        if ObjectId:
            dbExisting = models.ChangeRequestFormAttachments.objects.filter(
                id=ObjectId).first()

            if dbExisting:
                dbExisting.archived_at = datetime.now()
                dbExisting.save()

        self.perform_create(serializer)

        if not attachment_no:
            id = serializer.data['id']
            db_counter = models.ChangeRequestFormAttachments.objects.all().count()
            db_counter = db_counter + 1
            models.ChangeRequestFormAttachments.objects.filter(id=id).update(
                set__attachment_no=number_generator(
                    "ATCH", db_counter
                )
            )

        headers = self.get_success_headers(serializer.data)
        return Response(
            serializer.data,
            status=status.HTTP_201_CREATED,
            headers=headers
        )

    def retrieve(self, request, *args, **kwargs):
        instance = self.queryset.filter(archived_at=None).first()
        serializer = self.get_serializer(instance)
        return Response(serializer.data)


class ChangeRequestFormStakeHoldersViewset(meviewsets.ModelViewSet):

    queryset = models.ChangeRequestFormStakeHolders.objects.all()
    serializer_class = serializers.ChangeRequestFormStakeHoldersSerializer
    pagination_class = paginators.SimplePageNumberPagination

    def list(self, request, *args, **kwargs):
        self.queryset = self.queryset.filter(archived_at=None)
        self.queryset = QuerySetHelper.Sort(self)
        self.queryset = QuerySetHelper.Filter(self)
        return super(ChangeRequestFormStakeHoldersViewset, self).list(request)

    def create(self, request, *args, **kwargs):
        ObjectId = request.data.get('id')
        serializer = self.get_serializer(data=request.data)
        serializer.is_valid(raise_exception=True)

        if ObjectId:
            dbExisting = models.ChangeRequestFormStakeHolders.objects.filter(
                id=ObjectId).first()

            if dbExisting:
                dbExisting.save()

        self.perform_create(serializer)

        headers = self.get_success_headers(serializer.data)
        return Response(
            serializer.data,
            status=status.HTTP_201_CREATED,
            headers=headers
        )

    def retrieve(self, request, *args, **kwargs):
        instance = self.queryset.filter(archived_at=None).first()
        serializer = self.get_serializer(instance)
        return Response(serializer.data)


class ChangeRequestFormDetailsViewset(meviewsets.ModelViewSet):

    queryset = models.ChangeRequestFormDetails.objects.all()
    serializer_class = serializers.ChangeRequestFormDetailsSerializer
    pagination_class = paginators.SimplePageNumberPagination

    def list(self, request, *args, **kwargs):
        self.queryset = self.queryset.filter(archived_at=None)
        self.queryset = QuerySetHelper.Sort(self)
        self.queryset = QuerySetHelper.Filter(self)
        return super(ChangeRequestFormDetailsViewset, self).list(request)

    def create(self, request, *args, **kwargs):
        ObjectId = request.data.get('id')
        serializer = self.get_serializer(data=request.data)
        serializer.is_valid(raise_exception=True)

        if ObjectId:
            dbExisting = models.ChangeRequestFormDetails.objects.filter(
                id=ObjectId).first()

            if dbExisting:
                dbExisting.save()

        self.perform_create(serializer)

        headers = self.get_success_headers(serializer.data)
        return Response(
            serializer.data,
            status=status.HTTP_201_CREATED,
            headers=headers
        )

    def retrieve(self, request, *args, **kwargs):
        instance = self.queryset.filter(archived_at=None).first()
        serializer = self.get_serializer(instance)
        return Response(serializer.data)


class ChangeRequestFormPost(APIView):

    @transaction.atomic()
    def post(self, request):
        form_header = request.data

        try:
            data_list_approver = []
            data_list_stake = []
            data_list_attach = []
            data_list_detail = []

            form_header_data = {
                'requested_to_template_name': form_header['requested_to_template_name'],
                'requested_to_template_id': form_header['requested_to_template_id'],
                'requested_to_objective': form_header['requested_to_objective'],
                'requested_to_target_date': form_header['requested_to_target_date'],
                'requested_to_priority': form_header['requested_to_priority'],
                'description': form_header['description'],
                'status': form_header['status'],
                'company_desc': form_header['company_desc'],
                'department_desc': form_header['department_desc'],
                'requested_desc': form_header['requested_desc'],
                'requested_by_department': form_header['requested_by_department'],
                'requested_by_user': form_header['requested_by_user'],
                'requested_to_company': form_header['requested_to_company'],
                'requested_to_department': form_header['requested_to_department'],
                'requested_to_user': form_header['requested_to_user'],
                'template_no': form_header['template_no']
            }

            frm_approvers = form_header['frm_approvers']
            frm_stakes = form_header['frm_stakes']
            frm_attachments = form_header['frm_attachments']
            frm_details = form_header['frm_details']

            # sp1 = transaction.savepoint()  # nothing will save to db

            serializer = serializers.ChangeRequestFormHeaderSerializer(
                data=form_header_data)
            
            if serializer.is_valid(raise_exception=True):
                serializer.save()
            
            template_no = serializer.data['template_no']

            tmp_counter = models.ChangeRequestFormHeader.objects.filter(
                template_no=template_no).count()
            # tmp_counter = tmp_counter + 1
            CR_Prefix = serializer.data['requested_to_template_id']

            generate_tmp = number_generator(CR_Prefix, tmp_counter)
            
            frm_id = serializer.data['form_code']
            print(frm_id)

            models.ChangeRequestFormHeader.objects.filter(
                form_code=frm_id).update(
                    requested_to_template_id=generate_tmp)

            # create template approvers
            counter = 0
            for frm_approver in frm_approvers:
                frm_approver['form_code'] = frm_id
                counter = counter + 1
                data_list_approver.append(frm_approver)

            counter = counter + 1
            vendor_data = {
                'level': counter,
                'delegation': 'Vendor/Implementor',
                'user': form_header['requested_to_user'],
                'form_code': frm_id
            }

            data_list_approver.append(vendor_data)

            counter = counter + 1
            requestor_data = {
                'level': counter,
                'delegation': 'Requestor',
                'user': form_header['requested_by_user'],
                'form_code': frm_id
            }

            data_list_approver.append(requestor_data)

            serializerApprover = serializers.ChangeRequestFormApproversSerializer(
                data=data_list_approver, many=True)

            if serializerApprover.is_valid(raise_exception=True):
                serializerApprover.save()
                
            # create template stakes

            for frm_stake in frm_stakes:
                frm_stake['form_code'] = frm_id
                data_list_stake.append(frm_stake)

            serializerStake = serializers.ChangeRequestFormStakeHoldersSerializer(
                data=data_list_stake, many=True)

            if serializerStake.is_valid(raise_exception=True):
                serializerStake.save()
            
            # create template attachments

            for frm_attachment in frm_attachments:
                frm_attachment['form_code'] = frm_id
                data_list_attach.append(frm_attachment)

            serializerAttach = serializers.ChangeRequestFormAttachmentsSerializer(
                data=data_list_attach, many=True)

            if serializerAttach.is_valid(raise_exception=True):
                serializerAttach.save()

            # create template details
            
            for frm_detail in frm_details:
                frm_detail['form_code'] = frm_id
                data_list_detail.append(frm_detail)

            serializerDetail = serializers.ChangeRequestFormDetailsSerializer(
                data=data_list_detail, many=True)
            
            if serializerDetail.is_valid(raise_exception=True):
                serializerDetail.save()
            
            message = {
                'code': 201,
                'status': 'success',
                'message': 'Form Details successfully saved!',
                'results': serializer.data
            }

            return Response(message, status=status.HTTP_201_CREATED)

        except ValidationError as e:
            # transaction.savepoint_rollback(sp1)
            message = {
                'code': 400,
                'status': 'failed',
                'message': str(e),
            }
            return Response(message, status=status.HTTP_400_BAD_REQUEST)

        except Exception as e:
            # transaction.savepoint_rollback(sp1)
            message = {
                'code': 500,
                'status': 'failed',
                'message': 'Request was not able to process' + str(e),
            }
            return Response(message,
                            status=status.HTTP_500_INTERNAL_SERVER_ERROR)