from rest_framework import serializers
from .models import APIService, APIEndpoint, Application
from api.utils import BadRequestException
from rest_framework.exceptions import ValidationError


class GroupDependentSerializer(serializers.ModelSerializer):
    class Meta:
        model = Application
        fields = ('id', 'name', 'code')


class ApplicationSerializer(serializers.ModelSerializer):

    class Meta:
        model = Application
        fields = (
            'id', 'application_no', 'name', "code", 'theme',
            # 'groups', 'modules'
        )
        read_only_fields = (
            'id', 'application_no', 'created_at', 'updated_at', 'deleted_at'
        )

    def is_valid(self, raise_exception=False):

        assert not hasattr(self, 'restore_object'), (
            'Serializer `%s.%s` has old-style version 2 `.restore_object()` '
            'that is no longer compatible with REST framework 3. '
            'Use the new-style `.create()` and `.update()` methods instead.' %
            (self.__class__.__module__, self.__class__.__name__)
        )

        assert hasattr(self, 'initial_data'), (
            'Cannot call `.is_valid()` as no `data=` keyword argument was '
            'passed when instantiating the serializer instance.'
        )

        if not hasattr(self, '_validated_data'):
            try:
                self._validated_data = self.run_validation(self.initial_data)
            except ValidationError as exc:
                self._validated_data = {}
                self._errors = exc.detail
            else:
                self._errors = {}

        # if validation failed
        if self._errors and raise_exception:
            error_message = {}
            message = str(self.errors)

            for k, v in self.errors.items():
                message = str(v)
                start = message.find('string=') + 8
                end = message.find(', code=') - 1
                message = message[start:end]

                error_message[str(k)] = message

            raise BadRequestException(error_message)

        return not bool(self._errors)


class APIServiceSerializer(serializers.ModelSerializer):
    class Meta:
        model = APIService
        fields = (
            'id', 'api_service_no', 'name', 'service_token', 'base_url',
            'service_url', 'application', 'created_at',
            'updated_at', 'deleted_at'
        )
        read_only_fields = (
            'id', 'api_service_no', 'service_token', 'created_at',
            'updated_at', 'deleted_at'
        )

    def is_valid(self, raise_exception=False):

        assert not hasattr(self, 'restore_object'), (
            'Serializer `%s.%s` has old-style version 2 `.restore_object()` '
            'that is no longer compatible with REST framework 3. '
            'Use the new-style `.create()` and `.update()` methods instead.' %
            (self.__class__.__module__, self.__class__.__name__)
        )

        assert hasattr(self, 'initial_data'), (
            'Cannot call `.is_valid()` as no `data=` keyword argument was '
            'passed when instantiating the serializer instance.'
        )

        if not hasattr(self, '_validated_data'):
            try:
                self._validated_data = self.run_validation(self.initial_data)
            except ValidationError as exc:
                self._validated_data = {}
                self._errors = exc.detail
            else:
                self._errors = {}

        # if validation failed
        if self._errors and raise_exception:
            error_message = {}
            message = str(self.errors)

            for k, v in self.errors.items():
                message = str(v)
                start = message.find('string=') + 8
                end = message.find(', code=') - 1
                message = message[start:end]

                error_message[str(k)] = message

            raise BadRequestException(error_message)

        return not bool(self._errors)


class APIEndpointSerializer(serializers.ModelSerializer):

    class Meta:
        model = APIEndpoint
        fields = (
            'id', 'api_endpoint_no', 'service', 'name',
            'description', 'http_method', 'endpoint_url', 'is_need_auth',
            'is_active', 'created_at', 'updated_at', 'deleted_at'
        )
        read_only_fields = (
            'id', 'api_endpoint_no', 'created_at', 'updated_at', 'deleted_at'
        )

    def is_valid(self, raise_exception=False):

        assert not hasattr(self, 'restore_object'), (
            'Serializer `%s.%s` has old-style version 2 `.restore_object()` '
            'that is no longer compatible with REST framework 3. '
            'Use the new-style `.create()` and `.update()` methods instead.' %
            (self.__class__.__module__, self.__class__.__name__)
        )

        assert hasattr(self, 'initial_data'), (
            'Cannot call `.is_valid()` as no `data=` keyword argument was '
            'passed when instantiating the serializer instance.'
        )

        if not hasattr(self, '_validated_data'):
            try:
                self._validated_data = self.run_validation(self.initial_data)
            except ValidationError as exc:
                self._validated_data = {}
                self._errors = exc.detail
            else:
                self._errors = {}

        # if validation failed
        if self._errors and raise_exception:
            error_message = {}
            message = str(self.errors)

            for k, v in self.errors.items():
                message = str(v)
                start = message.find('string=') + 8
                end = message.find(', code=') - 1
                message = message[start:end]

                error_message[str(k)] = message

            raise BadRequestException(error_message)

        return not bool(self._errors)
