from app.entities import models
from rest_framework import serializers
from django.db.models import Q
from django.forms.models import model_to_dict
from drf_writable_nested import WritableNestedModelSerializer
from app.applicationlayer.cms.utils_cr import (get_account_details,
                                               get_dept_details,
                                               get_companies_details)


class ChangeRequestTemplateApproversSerializer(
    serializers.ModelSerializer
):
    def to_representation(self, instance):
        ret = super().to_representation(instance)
        try:
            user_object = {
                "id": instance.user.id
                "name": instance.user.name
                "username": instance.user.username
            }
            ret['company'] = model_to_dict(instance.user.department.company)
            ret['department'] = model_to_dict(instance.user.department)
            ret['user'] = user_object

            return ret
        
        except Exception as e:
            ret['company'] = "none"
            ret['department'] = "none"
            ret['name'] = "none"
            return ret

    class Meta:
        model = models.ChangeRequestTemplateApprovers
        fields = '__all__'
        read_only_fields = ['created', 'code']


class ChangeRequestTemplateStakeHoldersSerializer(
    serializers.ModelSerializer
):
    def to_representation(self, instance):
        ret = super().to_representation(instance)
        try:

            ret['company'] = model_to_dict(instance.user.department.company)
            ret['department'] = model_to_dict(instance.user.department)
            ret['name'] = instance.user.name
            ret['email'] = instance.user.email
            ret['contact_no'] = contact_no

            return ret
        
        except Exception as e:
            ret['company'] = "none"
            ret['department'] = "none"
            ret['name'] = "none"
            ret['email'] = "none"
            ret['contact_no'] = "none"
            return ret

    class Meta:
        model = models.ChangeRequestTemplateStakeHolders
        fields = '__all__'
        read_only_fields = ['created', 'code']
    

class ChangeRequestTemplateAttachmentsSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestTemplateAttachments
        fields = '__all__'
        read_only_fields = ['created', 'code']


class ChangeRequestTemplateDetailsSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestTemplateDetails
        fields = '__all__'
        read_only_fields = ['created', 'code']


class ChangeRequestTemplatesSerializer(
    serializers.ModelSerializer
):
    tmp_approvers = ChangeRequestTemplateApproversSerializer(
        many=True, read_only=True)
    tmp_stakes = ChangeRequestTemplateStakeHoldersSerializer(
        many=True, read_only=True)
    tmp_attachments = ChangeRequestTemplateAttachmentsSerializer(
        many=True, read_only=True)
    tmp_details = ChangeRequestTemplateDetailsSerializer(
        many=True, read_only=True)

    def to_representation(self, instance):
        ret = super().to_representation(instance)
        try:

            ret['company'] = model_to_dict(instance.user.department.company)
            ret['department'] = model_to_dict(instance.user.department)
            ret['point_of_contact'] = model_to_dict(instance.requested_to_user)
            ret['created_by'] = instance.created_by_user.code

            return ret
        except Exception as e:

            ret['company'] = "none"
            ret['department'] = "none"
            ret['point_of_contact'] = "none"
            ret['created_by'] = "none"

            return ret

    class Meta:
        model = models.ChangeRequestTemplateHeader
        # fields = '__all__'
        fields = ('template_no', 'requested_to_template_name',
                  'requested_to_objective', 'requested_to_target_date',
                  'requested_to_priority', 'description', 'created',
                  'requested_to_template_id', 'requested_to_company',
                  'requested_to_department', 'requested_to_user',
                  'created_by_user', 'created_by_department',
                  'tmp_approvers', 'tmp_stakes', 'tmp_attachments',
                  'tmp_details')

        read_only_fields = ['created', 'template_no']
