from rest_framework.response import Response
from rest_framework import status
import json


def error_safe(function):
    def wrap(request, *args, **kwargs):
        try:
                return function(request, *args, **kwargs)
        except Exception as ex:
            data = None
            try:
                data = ex.args[0]
            except Exception as ex2:
                data = str(ex)
            return Response(data={"error": data},
                            status=status.HTTP_500_INTERNAL_SERVER_ERROR)

    wrap.__doc__ = function.__doc__
    wrap.__name__ = function.__name__
    return wrap
