from django.db import models
from django.contrib.auth.models import AbstractUser
from .modelcommon import AuditClass
from .UserManager import UserManager
from django.db.models.signals import post_save, post_delete
from django.dispatch import receiver
from datetime import datetime
from . import enums


# ********************* SETUP DATBLES *********************


class Permission(AuditClass):
    code = models.CharField(unique=True, max_length=255)
    name = models.CharField(unique=True, max_length=255)
    description = models.CharField(max_length=255, blank=True, null=True)

    def __str__(self):
        return f"Permission({self.code})"

    class Meta:
        db_table = 'access_permissions'


class Role(AuditClass):
    code = models.CharField(unique=True, max_length=255)
    name = models.CharField(unique=True, max_length=255)
    description = models.CharField(max_length=255, blank=True, null=True)
    permissions = models.ManyToManyField(Permission)

    def __str__(self):
        return f"Role({self.code})"

    class Meta:
        db_table = 'access_roles'


class User(AbstractUser):
    nric = models.CharField(blank=True, null=True, max_length=255)
    contact_no = models.CharField(blank=True, null=True, max_length=255)
    role = models.ForeignKey(Role, related_name='auth_user',
                             on_delete=models.PROTECT)
    special_permissions = models.ManyToManyField(Permission,
                                                 blank=True,
                                                 null=True)

    objects = UserManager()

    def __str__(self):
        return self.username

    class Meta:
        db_table = 'auth_user'


class UserImage(AuditClass):
    name = models.CharField(blank=True, null=True, max_length=255)
    image = models.ImageField(upload_to='user_images/', null=True,
                              max_length=255)
    is_primary = models.BooleanField(default=True)

    user = models.ForeignKey(User, related_name='user_images',
                             on_delete=models.PROTECT)

    def __str__(self):
        return f"User({self.user.username})-UserImage({self.name})"

    class Meta:
        db_table = 'auth_user_images'

class AuthToken(models.Model):
    ref = models.CharField(max_length=255)
    token = models.TextField()
    passcode = models.CharField(max_length=255)
    timeout = models.IntegerField()
    is_active = models.BooleanField(default=False)
    user = models.ForeignKey(User,
                             related_name='auth_access_token',
                             on_delete=models.PROTECT)

    class Meta:
        db_table = 'auth_access_token'


class EntityLog(AuditClass):
    action = models.CharField(
        choices=[
            (tag.value, tag.value) for tag in enums.LogEnum],
        default=enums.LogEnum.ADD.value,
        max_length=50)
    entity = models.CharField(
        choices=[
            (tag.value, tag.value) for tag in enums.LogEntitiesEnum],
        default=enums.LogEnum.ADD.value,
        max_length=50)
    row_id = models.IntegerField()
    fromValue = models.TextField(blank=True, null=True)
    toValue = models.TextField(blank=True, null=True)

    def __str__(self):
        return self.entity

    class Meta:
        db_table = 'entity_logs'


# ********************* APP TABLES *********************


class Robot(AuditClass):
    name = models.CharField(unique=True, max_length=255)
    description = models.CharField(max_length=255, blank=True, null=True)

    def __str__(self):
        return self.name

    class Meta:
        db_table = 'robot'