from enum import Enum


class ModelSeriesEnum(Enum):
    USER = "USR"
    CLIENT = "CLI"
    CONSUMABLEPRODUCTS = "CSP"
    PROJECT = "PRJ"
    SERIALIZEITEM = "ITM"
    SERIALIZEPRODUCT = "SRP"
    SUPPLIER = "SUP"
    WAREHOUSE = "WHL"
    ACQUISITION = 'AQN'
    REQUISITION = 'RQN'
    PURCHASEREQUEST = 'PR'
    STOCKTAKE = 'STK'
    CHECKOUT = 'CHK'


class ItemConditionEnum(Enum):
    NEW = "New"
    USED = "Used"


class StockTakeEnum(Enum):
    OPEN = "Open"
    CLOSED = "Closed"


class RequisitionEnum(Enum):
    # ACIVE = "Active"
    # DEACTIVATED = "Deactivated"
    # DELETED = "Deleted"
    # ARCHIVED = "Archived"
    PENDING = "Pending"
    APPROVED = "Approved"
    APPROVED_PARTIAL = "Partially Approved"
    REJECTED = "Rejected"
    REJECTED_PARTIAL = "Partially Rejected"
    APPROVED_REJECTED_PARTIAL = "Partially Approved & Rejected"

    CANCELED = "Canceled"
    CLOSED = "Closed"
    FORCE_CLOSED = "Force Closed"


class StockEnum(Enum):
    IN = "In"
    OUT = "Out"


class CheckoutEnum(Enum):
    DISPATCHED = "Dispatched"
    RETURNED = "Returned"

'''
*********
LOG ENUMS
*********
'''

class LogEnum(Enum):
    ADD = "Add"
    UPDATE = "Update"
    DELETE = "Delete"

class LogEntitiesEnum(Enum):
    USER = "User"

    BRAND = "Brand"
    CATEGORY = "Category"
    CURRENCY = "Currency"
    UNIT_MATERIAL = "Unit Material"
    NEWS = "News"

    PROJECT = "Project"
    PROJECT_LOCATION = "Project Location"
    WAREHOUSE = "Warehouse"
    SUPPLIER = "Supplier"
    CLIENT = "Client"

    PRODUCT = "Product"
    ACQUISITION_ITEM = "Acquisition Item"
    STOCK = "Stock"
    STOCK_ITEM = "Stock Item"



    