# import copy
# from django.db import transaction
# from src.entities import models, enums
# from src.businesslayer import logger
# from django.forms.models import model_to_dict
# from django.db.models.functions import Concat, Coalesce, Lower
# from django.db.models import (Q, F, Sum, OuterRef, Subquery, Q, Case, When,
#                               Value, Func, Count,
#                               CharField,
#                               IntegerField,
#                               DecimalField,
#                               BooleanField)


# def generate_next_series_product_srp(id):
#     return f"{enums.ModelSeriesEnum.SERIALIZEPRODUCT.value}-{id}"


# def generate_next_series_product_csp(id):
#     return f"{enums.ModelSeriesEnum.CONSUMABLEPRODUCTS.value}-{id}"


# def change_product_no(id):

#     updateProduct = models.Product.objects.filter(id=id).first()

#     if updateProduct.is_serialized:
#         updateProduct.product_no = f"{enums.ModelSeriesEnum.SERIALIZEPRODUCT.value}-{id}"
#     else:
#         updateProduct.product_no = f"{enums.ModelSeriesEnum.CONSUMABLEPRODUCTS.value}-{id}"

#     updateProduct.save()

#     return


# def get_product_info():
#     queryset = None
#     try:
#         return models.Product\
#                      .objects\
#                      .values(
#                          prod_id=F('id'),
#                          prod_no=F('product_no'),
#                          prod_name=F('name'),
#                          prod_description=F('description'),
#                          prod_is_serialized=F('is_serialized'),
#                          prod_brand=F('brand__name'),
#                          prod_category=F('category__name'),
#                          prod_unit=F('unit_material__name'),
#                          prod_quota=F('minimum_quantity'),
#                          total_available_price=F('minimum_quantity'))
#     except Exception as ex:
#         print(f"##ERROR##: get_product_info:")
#         print(str(ex))
#     return queryset


# def list_inventory_stocks_IS(prod_pk='pk'):
#     queryset = None
#     try:
#         queryset = models.StockItem\
#                            .objects\
#                            .filter(
#                                stock__product_id=OuterRef(prod_pk),
#                                status=enums.StockEnum.IN.value)\
#                            .values('stock__product_id')\
#                            .annotate(val=Count('id')).values('val')
#     except Exception as ex:
#         print(f"##ERROR##: list_inventory_stocks_IS:")
#         print(str(ex))
#     return queryset


# def list_inventory_stocks_PRI(prod_pk='pk'):
#     queryset = None
#     try:
#         SUB_qty_pri_rejected = models.RequisitionRejectItem\
#                                      .objects\
#                                      .filter(
#                                          requisition_product_id=OuterRef(
#                                              prod_pk))\
#                                      .values('requisition_product_id')\
#                                      .annotate(
#                                          val=Coalesce(Sum('quantity'), 0))\
#                                      .values('val')

#         SUB_qty_pri_checkouts = models.CheckoutItem\
#                                       .objects\
#                                       .filter(
#                                           requisition_product_id=OuterRef(
#                                               prod_pk))\
#                                       .values('requisition_product_id')\
#                                       .annotate(val=Coalesce(Count('id'), 0))\
#                                       .values('val')

#         queryset = models.RequisitionProduct\
#                          .objects\
#                          .filter(
#                              product=OuterRef(prod_pk),
#                              status__in=(
#                                  enums.RequisitionEnum.PENDING.value,
#                                  enums.RequisitionEnum.APPROVED.value,
#                                  enums.RequisitionEnum.APPROVED_PARTIAL.value,
#                                  enums.RequisitionEnum.REJECTED_PARTIAL.value,
#                                  enums.RequisitionEnum.APPROVED_REJECTED_PARTIAL.value,
#                              ))\
#                          .values('product_id')\
#                          .annotate(
#                              val=Coalesce(Sum('quantity'), 0) -
#                              (
#                                  Coalesce(Sum(Subquery(
#                                      SUB_qty_pri_rejected,
#                                      output_field=IntegerField()),
#                                  ), 0)
#                                  +
#                                  Coalesce(Sum(Subquery(
#                                      SUB_qty_pri_checkouts,
#                                      output_field=IntegerField())
#                                  ), 0)
#                              )
#                          ).values('val')
#     except Exception as ex:
#         print(f"##ERROR##: list_inventory_stocks_PRI:")
#         print(str(ex))
#     return queryset


# def list_inventory_stocks():
#     queryset = None
#     try:
#         SUB_qty_is = list_inventory_stocks_IS()

#         SUB_qty_pri = list_inventory_stocks_PRI()

#         queryset = models.Product\
#                          .objects\
#                          .values(
#                              prod_id=F('id'),
#                              prod_no=F('product_no'),
#                              prod_code=F('code'),
#                              prod_name=F('name'),
#                              prod_brand=F('brand__name'),
#                              prod_category=F('category__name'),
#                              prod_unit=F('unit_material__name'),
#                              qty_is=Coalesce(Sum(
#                                         Subquery(
#                                             SUB_qty_is,
#                                             output_field=IntegerField()
#                                         )), 0),
#                              qty_pri=Coalesce(Sum(
#                                          Subquery(
#                                              SUB_qty_pri,
#                                              output_field=IntegerField()
#                                          )), 0),
#                              qty_vb=F('qty_is')-F('qty_pri'),
#                              is_critical=Case(
#                                  When(qty_is__lt=F('minimum_quantity'),
#                                       then=Value(True)),
#                                  default=Value(False),
#                                  output_field=BooleanField()),
#                              PREFIX=Case(
#                                  When(is_serialized=True,
#                                       then=Value(enums.ModelSeriesEnum.SERIALIZEITEM)),
#                                  default=Value(enums.ModelSeriesEnum.CONSUMABLEPRODUCTS),
#                                  output_field=CharField()
#                              )
#                          )
#     except Exception as ex:
#         print(f"##ERROR##: list_inventory_stocks:")
#         print(str(ex))
#     return queryset


# def list_in_store_by_location(product_id):
#     queryset = None
#     try:
#         queryset = models.StockItem\
#                          .objects\
#                          .filter(
#                              stock__product_id=product_id,
#                              status=enums.StockEnum.IN.value)\
#                          .values(
#                              current_warehouse=F('warehouse__name'),
#                              unit_material=F('stock__product__unit_material__name'))\
#                          .annotate(
#                              qty_n=Sum(Case(When(item_condition__code=enums.ItemConditionEnum.NEW.value,
#                                                  then=Value(1)),
#                                             default=Value(0),
#                                             output_field=IntegerField())),
#                              qty_u=Sum(Case(When(item_condition__code=enums.ItemConditionEnum.USED.value,
#                                                  then=Value(1)),
#                                             default=Value(0),
#                                             output_field=IntegerField())),
#                              qty_t=F('qty_n') + F('qty_u'))
#     except Exception as ex:
#         print(f"##ERROR##: list_in_store_location:")
#         print(str(ex))
#     return queryset


# def list_in_store_by_location_batch(product_id):
#     queryset = None
#     try:
#         queryset = models.StockItem\
#                          .objects\
#                          .filter(
#                              stock__product_id=product_id,
#                              status=enums.StockEnum.IN.value)\
#                          .values(
#                              acquisition_pk=F('acquisition_item__acquisition_id'),
#                              warehouse_pk=F('warehouse_id'),

#                              batch=F('acquisition_item__acquisition__acquisition_no'),
#                              current_warehouse=F('warehouse__name'),
#                              stock_currency=F('currency__name'),
#                              acquired_date=F('acquisition_item__acquisition__acquired_date'),
#                              po_no=F('acquisition_item__acquisition__po_no'),
#                              inv_no=F('acquisition_item__acquisition__inv_no'),
#                              unit_material=F('stock__product__unit_material__name'),
#                              supplier=F('acquisition_item__acquisition__supplier__name'))\
#                          .annotate(
#                              qty_n=Sum(Case(When(item_condition__code=enums.ItemConditionEnum.NEW.value,
#                                                  then=Value(1)),
#                                             default=Value(0),
#                                             output_field=IntegerField())),
#                              qty_u=Sum(Case(When(item_condition__code=enums.ItemConditionEnum.USED.value,
#                                                  then=Value(1)),
#                                             default=Value(0),
#                                             output_field=IntegerField())),
#                              qty_t=F('qty_n') + F('qty_u'),
#                              total_price=Sum(F('price')))
#     except Exception as ex:
#         print(f"##ERROR##: list_in_store_location_batch:")
#         print(str(ex))

#     print(queryset)
#     return queryset


# def list_in_store_by_location_batch_serialized_items(product_id,
#                                                      acquisition_id,
#                                                      warehouse):
#     queryset = None
#     try:
#         queryset = models.StockItem\
#                          .objects\
#                          .filter(
#                              acquisition_item__acquisition_id=acquisition_id,
#                              warehouse_id=warehouse,
#                              stock__product_id=product_id,
#                              status=enums.StockEnum.IN.value)\
#                          .values(
#                              row_id=F('id'),
#                              stockId=F('stock__id'),
#                              serial_no=F('stock__serial_number'),
#                              condition_i=F('item_condition_id'),
#                              condition_d=F('item_condition__name'),
#                              warehouse_i=F('warehouse_id'),
#                              price_d=F('price'),
#                              currency_d=F('currency__name'))
#     except Exception as ex:
#         print(f"##ERROR##: list_in_store_location_batch_serialized_items:")
#         print(str(ex))
#     return queryset







# def transaction_in_store_serialized_delete(stock_item_id):
#     queryset = None
#     try:
#         dbStockItem = models.StockItem.objects.filter(id=stock_item_id).first()
#         dbStock = dbStockItem.stock
#         dbAcquisitionItem = dbStockItem.acquisition_item

#         logger.log_save(
#             enums.LogEnum.DELETE.value,
#             enums.LogEntitiesEnum.STOCK_ITEM.value,
#             model_to_dict(dbStockItem))

#         logger.log_save(
#             enums.LogEnum.DELETE.value,
#             enums.LogEntitiesEnum.ACQUISITION_ITEM.value,
#             model_to_dict(dbAcquisitionItem))

#         logger.log_save(
#             enums.LogEnum.DELETE.value,
#             enums.LogEntitiesEnum.STOCK.value,
#             model_to_dict(dbStock))

#         dbStockItem.delete()
#         dbAcquisitionItem.delete()
#         dbStock.delete()
        
#     except Exception as ex:
#         print(f"##ERROR##: transaction_in_store_serialized_delete:")
#         print(str(ex))
#         raise Exception(str(ex))
#     return queryset


# def transaction_in_store_serialized_edit(stock_item_id, serial_number, item_condition_id):
#     queryset = None
#     try:
#         stock_item = models.StockItem.objects.filter(id=stock_item_id).first()
#         if not stock_item:
#             raise Exception(f"{stock_item} not found")

#         existingSerial = models.StockItem.objects.filter(stock__serial_number=serial_number).first()
#         if existingSerial:
#             raise Exception(f"{serial_number} already exists")

#         newItemCondition = models.ItemCondition.objects.filter(id=item_condition_id).first()
#         if not newItemCondition:
#             raise Exception(f"Item Condition {item_condition_id} not found")

        
#         fromObjStockItem = copy.copy(stock_item)
#         fromObjStock = copy.copy(stock_item.stock)

#         # transaction
#         stock_item.item_condition = newItemCondition
#         stock_item.stock.serial_number = serial_number

#         stock_item.stock.save()
#         stock_item.save()
#         # end transaction

#         logger.log_save(
#             enums.LogEnum.UPDATE.value,
#             enums.LogEntitiesEnum.STOCK_ITEM.value,
#             model_to_dict(fromObjStockItem),
#             model_to_dict(stock_item))

#         logger.log_save(
#             enums.LogEnum.UPDATE.value,
#             enums.LogEntitiesEnum.STOCK.value,
#             model_to_dict(fromObjStock),
#             model_to_dict(stock_item.stock))

#     except Exception as ex:
#         print(f"##ERROR##: transaction_in_store_serialized_edit:")
#         print(str(ex))
#     return queryset


# def transaction_in_store_serialized_shift_batch(to_acquisition_id, stock_item_ids):
#     queryset = None
#     try:
#         acquisition = models.Acquisition.objects.filter(
#                 id=to_acquisition_id).first()

#         if not acquisition:
#             raise Exception(F"Batch {to_acquisition_id} not found")

            

#         for stock_item_id in stock_item_ids:
#             stock_item = models.StockItem.objects.filter(id=stock_item_id).first()
#             if not stock_item:
#                 raise Exception(F"{stock_item_id} not found")

#             fromObjAcquisitionItem = copy.copy(stock_item.acquisition_item)

#             # transaction
#             stock_item.acquisition_item.acquisition = acquisition

#             stock_item.acquisition_item.save()
#             stock_item.save()
#             # end transaction

#             logger.log_save(
#                 enums.LogEnum.UPDATE.value,
#                 enums.LogEntitiesEnum.ACQUISITION_ITEM.value,
#                 model_to_dict(fromObjAcquisitionItem),
#                 model_to_dict(stock_item.acquisition_item))

#     except Exception as ex:
#         print(f"##ERROR##: transaction_in_store_serialized_shift_batch:")
#         print(str(ex))
#         raise Exception(str(ex))
#     return queryset


# def transaction_in_store_serialized_shift_location(to_warehouse_id, stock_item_ids):
#     queryset = None
#     try:
#         warehouse = models.Warehouse.objects.filter(
#                 id=to_warehouse_id).first()

#         if not warehouse:
#             raise Exception(F"Waehosue {to_warehouse_id} not found")

#         for stock_item_id in stock_item_ids:
#             stock_item = models.StockItem.objects.filter(id=stock_item_id).first()
#             if not stock_item:
#                 raise Exception(F"{stock_item_id} not found")


#             fromObjStockItem = copy.copy(stock_item)

#             # transaction
#             stock_item.warehouse = warehouse

#             stock_item.save()
#             # end transaction

#             logger.log_save(
#                 enums.LogEnum.UPDATE.value,
#                 enums.LogEntitiesEnum.STOCK_ITEM.value,
#                 model_to_dict(fromObjStockItem),
#                 model_to_dict(stock_item))

#     except Exception as ex:
#         print(f"##ERROR##: transaction_in_store_serialized_shift_location:")
#         print(str(ex))
#         raise Exception(str(ex))
#     return queryset








# def transaction_in_store_consumable(product_id,
#                                     action,
#                                     quantity,
#                                     item_condition_id,
#                                     to_warehouse_id,
#                                     to_acq_id,
#                                     warehouse_id,
#                                     acquisition_id):
#     queryset = None
#     try:
#         item_condition = models.ItemCondition\
#                                 .objects\
#                                 .filter(id=item_condition_id)\
#                                 .first()
#         if not item_condition:
#             raise Exception('Invalid Item Condition')

#         stock_items = models.StockItem.objects.filter(
#             item_condition=item_condition.id,
#             stock__product_id=product_id,
#             status=enums.StockEnum.IN.value,
#             warehouse_id=warehouse_id,
#             acquisition_item__acquisition_id=acquisition_id)

#         total = int(quantity)
#         ctr = 1

#         if action == 'deduct':
#             for row in stock_items:
#                 if ctr > total:
#                     return
#                 logger.log_save(
#                     enums.LogEnum.DELETE.value,
#                     enums.LogEntitiesEnum.STOCK_ITEM.value,
#                     model_to_dict(row))
#                 row.delete()
#                 ctr+=1
            
#         elif action == 'location':
#             for row in stock_items:
#                 if ctr > total:
#                     return

#                 fromObj = copy.copy(row)

#                 row.warehouse = models.Warehouse.objects.filter(id=warehouse_id).first()
#                 row.save()

#                 toObj = copy.copy(row)

#                 logger.log_save(
#                     enums.LogEnum.UPDATE.value,
#                     enums.LogEntitiesEnum.STOCK_ITEM.value,
#                     model_to_dict(fromObj),
#                     model_to_dict(toObj))

#                 ctr+=1
            
#         elif action == 'batch':
#             for row in stock_items:
#                 if ctr > total:
#                     return

#                 fromObj = copy.copy(row.acquisition_item)

#                 row.acquisition_item.acquisition = models.Acquisition.objects.filter(id=acquisition_id).first()
#                 row.acquisition_item.save()
#                 row.save()

#                 toObj = copy.copy(row.acquisition_item)

#                 logger.log_save(
#                     enums.LogEnum.UPDATE.value,
#                     enums.LogEntitiesEnum.ACQUISITION_ITEM.value,
#                     model_to_dict(fromObj),
#                     model_to_dict(toObj))

#                 ctr+=1

#     except Exception as ex:
#         print(f"##ERROR##: transaction_in_store_consumable:")
#         print(str(ex))
#         raise Exception(str(ex))
#     return queryset








# def list_batch_history(product_id):
#     queryset = None
#     try:
#         queryset = models.AcquisitionItem\
#                          .objects\
#                          .filter(stock__product_id=product_id)\
#                          .values(
#                              acq_id=F('acquisition_id'),
#                              batch_no=F('acquisition__acquisition_no'),
#                              acquired_date=F('acquisition__acquired_date'),
#                              currency_d=F('currency__name'),
#                              po_no=F('acquisition__po_no'),
#                              inv_no=F('acquisition__inv_no'),
#                              supplier_d=F('acquisition__supplier__name'),
#                              total_price=F('acquisition__batch_price'),
#                           )\
#                           .annotate(qty=Sum('quantity'))
#     except Exception as ex:
#         print(f"##ERROR##: list_batch_history:")
#         print(str(ex))
#     return queryset


# def list_checkouts(product_id):
#     queryset = None
#     try:
#         SUB_error_returns = models.CheckoutErrorReturnItem\
#                                   .objects\
#                                   .filter(checkout_item_id=OuterRef('pk'))\
#                                   .values('checkout_item_id')

#         SUB_returns = models.CheckoutReturnItem\
#                             .objects\
#                             .filter(checkout_item_id=OuterRef('pk'))\
#                             .values('checkout_item_id')

#         queryset = models.CheckoutItem\
#                          .objects\
#                          .filter(
#                              ~Q(id__in=Subquery(SUB_error_returns)) |
#                              ~Q(id__in=Subquery(SUB_returns)),
#                              stock_item__stock__product_id=product_id)\
#                          .values(
#                              deployment_date=F('checkout__checkeout_on'),
#                              location=F('checkout__location_from__name'),
#                              project=F('checkout__location__name'),
#                              requisition_no=F('checkout__requisition__requisition_no'),
#                              issued_by=F('checkout__issued_by__username'),
#                              checkout_by=F('checkout__checkeout_by__username'),
#                              # serial_numbers=F(''),
#                              requestor_remarks=F('checkout__requisition__remarks'),
#                              remarks_collector=F('checkout__remarks'))\
#                          .annotate(
#                              qty_n=Sum(Case(When(stock_item__item_condition__code=enums.ItemConditionEnum.NEW.value,
#                                                  then=Value(1)),
#                                             default=Value(0),
#                                             output_field=IntegerField())),
#                              qty_u=Sum(Case(When(stock_item__item_condition__code=enums.ItemConditionEnum.USED.value,
#                                                  then=Value(1)),
#                                             default=Value(0),
#                                             output_field=IntegerField())),
#                              qty_t=F('qty_n') + F('qty_u'))
#     except Exception as ex:
#         print(f"##ERROR##: list_checkouts:")
#         print(str(ex))
#     return queryset


# # TODO: THIS IS STILL ERROR
# def list_returns(product_id):
#     queryset = None
#     try:
#         queryset = models.CheckoutReturnItem\
#                          .objects\
#                          .filter()\
#                          .values(
#                              chk_rtn_id=F(
#                                  'checkout_return_id'),
#                              requisition_no=F(
#                                  'checkout_item__requisition_product__requisition__requisition_no'),
#                              return_date=F(
#                                  'checkout_return__return_on'),
#                              to_warehouse=F(
#                                  'checkout_return__warehouse__name'),
#                              from_project=F(
#                                  'checkout_item__checkout__location__name'),
#                              return_by_user=F(
#                                  'checkout_return__return_by__username'))\
#                          .annotate(
#                              qty_n=Sum(Case(When(checkout_item__stock_item__item_condition__code=enums.ItemConditionEnum.NEW.value,
#                                                  then=Value(1)),
#                                             default=Value(0),
#                                             output_field=IntegerField())),
#                              qty_u=Sum(Case(When(checkout_item__stock_item__item_condition__code=enums.ItemConditionEnum.USED.value,
#                                                  then=Value(1)),
#                                             default=Value(0),
#                                             output_field=IntegerField())),
#                              qty_t=F('qty_n') + F('qty_u'))
#     except Exception as ex:
#         print(f"##ERROR##: list_returns:")
#         print(str(ex))
#     return queryset


# def search_serial_by_product(product_id, serial_number):
#     queryset = None
#     try:
#         queryset = models.Stock\
#                          .objects.filter(
#                             serial_number=serial_number)\
#                          .values(
#                              stock_serial_number=F('serial_number'),
#                              stock_product_no=F('product__product_no'),
#                              stock_product_name=F('product__name'),
#                              stock_product_description=F('product__description'),
#                              stock_product_brand=F('product__brand__name'),
#                              stock_product_category=F('product__category__name'),
#                              stock_price=F('stock_items_stock__price'),
#                              stock_currency=F('stock_items_stock__currency__name'),
#                              stock_po_no=F('stock_items_stock__acquisition_item__acquisition__po_no'),
#                              stock_invoice_no=F('stock_items_stock__acquisition_item__acquisition__inv_no'),
#                              stock_supplier=F('stock_items_stock__acquisition_item__acquisition__supplier__name')
#                          )
#         if product_id:
#             queryset = queryset.filter(product_id=product_id)
#     except Exception as ex:
#         print(f"##ERROR##: search_serial_by_product:")
#         print(str(ex))
#     return queryset


# def serial_item_logs(product_id, serial_number):
#     queryset = None
#     try:
#         queryset = models.Stock\
#                          .objects.filter(
#                             serial_number=serial_number)

#         if product_id:
#             queryset = queryset.filter(product_id=product_id)

#         stock = queryset.first()

#         # LOG STOCK IN
#         # LOG STOCK REQUEST
#         # LOG STOCK APPROVAL
#         # LOG STOCK CHECKOUT
#         # LOG RETURNS

#         # FORMAT: [MM/DD/YYY] Book into System as {condition} to batch {acqn} : DONE
#         # FORMAT: [MM/DD/YYY] Requested from reference {rqn}
#         # FORMAT: [MM/DD/YYY] Approved/Rejected by {approver}
#         # FORMAT: [MM/DD/YYY] Checkedout from reference {chk},
#         #                     issued by: {issued_by},
#         #                     received by: {received_by}
#         # FORMAT: [MM/DD/YYY] Returned from reference {rtn},
#         #                     returned by: {return_by},
#         #                     received by: {received_by}

#         acquisition = stock.stock_items_stock.first()\
#                            .acquisition_item\
#                            .acquisition

#         item_condition = stock.stock_items_stock.first()\
#                               .acquisition_item\
#                               .item_condition.name

#         returnList = []

#         returnList.append({
#             "date": acquisition.acquired_date,
#             "message": f"Book into System as \"{item_condition}\" to batch {acquisition.acquisition_no}"
#         })

#         queryset = returnList

#     except Exception as ex:
#         print(f"##ERROR##: search_serial_by_product:")
#         print(str(ex))
#     return queryset


# # ********
# # RETURNS
# # ********


# def return_validate(product_id, serial_number):
#     error = False, None
#     try:
#         stockItem = models.StockItem.objects.filter(
#             stock__serial_number=serial_number).first()

#         if not stockItem:
#             return False, 'Serial number does not exists'

#         if stockItem.stock.product.id != int(product_id):
#             return False, 'Serial number does not belong in this product'

#         if stockItem.status != enums.StockEnum.OUT.value:
#             return False, 'This item is still in store'

#         checkoutItem = models.CheckoutItem.objects.filter(
#             stock_item_id=stockItem.id,
#             is_returned=False).first()

#         if not checkoutItem:
#             return false, 'This item has never been checked out'

#         return True, {
#             "stock_item_id": stockItem.id,
#             "checkout_items_id": checkoutItem.id,
#             "serial_number": serial_number,
#             "price": stockItem.price,
#             "currency": stockItem.currency.name,
#             "po_no": stockItem.acquisition_item.acquisition.po_no,
#             "inv_no": stockItem.acquisition_item.acquisition.inv_no,
#             "supplier": stockItem.acquisition_item.acquisition.supplier.name
#         }

#     except Exception as ex:
#         print(f"##ERROR##: return_validate:")
#         print(str(ex))
#     return error


# def return_submit_batch(product_id, serial_numbers):
#     error = None
#     try:
#         pass
#     except Exception as ex:
#         print(f"##ERROR##: return_submit_batch:")
#         print(str(ex))
#     return error
