import copy
from rest_framework.views import APIView
from rest_framework import viewsets, status, serializers
from django.shortcuts import render
from src.applicationlayer import serializers
from rest_framework.response import Response
from src.helper import decorators
from src.entities import models

from django.db import transaction
from src.helper import decorators

from src.applicationlayer import paginators
# from . import table_filters
from django_filters.rest_framework import DjangoFilterBackend
from rest_framework import filters

from datetime import datetime, date
from src.applicationlayer.utilities import QuerySetHelper
from src.entities import enums
from django.forms.models import model_to_dict

from rest_framework.decorators import action
# Create your views here.


class MasterModelViewSet(viewsets.ModelViewSet):
    """ViewSet for the THIS Table"""
    queryset = models.User.objects.all()
    filter_backends = (DjangoFilterBackend,)
    pagination_class = paginators.SimplePageNumberPagination

    def get_queryset(self):
        # return QuerySetHelper.Sort(self)

        return self.model.objects.order_by('id').all()


"""
**************************
* USER / ROLE PERMISSION *
**************************
"""


class UserViewSet(MasterModelViewSet):
    """ViewSet for the User Table"""
    model = models.User
    serializer_class = serializers.UserSerializer
    # filterset_class = table_filters.UserFilter


class RoleViewSet(MasterModelViewSet):
    """ViewSet for the AssetStocks Table"""
    model = models.Role
    serializer_class = serializers.RoleSerializer
    # filterset_class = table_filters.AssetStocksFilter


class PermissionViewSet(MasterModelViewSet):
    """ViewSet for the AssetStocks Table"""
    model = models.Permission
    serializer_class = serializers.PermissionSerializer
    # filterset_class = table_filters.AssetStocksFilter


class UserImageViewSet(MasterModelViewSet):
    """ViewSet for the UserImage Table"""
    model = models.UserImage
    serializer_class = serializers.UserImageSerializer
    # filterset_class = table_filters.UserImageFilter
