from django.urls import path, include, re_path
from rest_framework import routers

from src.applicationlayer import views
from src.applicationlayer.user_management import views as views_user_management

router = routers.DefaultRouter()

router.register(r'User', views.UserViewSet, base_name='User')
router.register(r'Role', views.RoleViewSet, base_name='Role')
router.register(r'Permission', views.PermissionViewSet, base_name='Permission')
router.register(r'UserImage', views.UserImageViewSet, base_name='UserImage')

# COMPILES MODULE BASE ON User, Role, Permission, UserImage
router.register(r'user-management', views_user_management.UsersManagementViewSet, base_name='User Management')

urlpatterns = (
    path('', include(router.urls)),
)
