from rest_framework import serializers
from src.entities import models


class UserSerializer(serializers.ModelSerializer):
    class Meta:
        model = models.User
        fields = '__all__'
        read_only_fields = ['createdby', 'modifiedby', 'created', 'modified']


class RoleSerializer(serializers.ModelSerializer):
    class Meta:
        model = models.Role
        fields = '__all__'
        read_only_fields = ['createdby', 'modifiedby', 'created', 'modified']


class PermissionSerializer(serializers.ModelSerializer):
    class Meta:
        model = models.Permission
        fields = '__all__'
        read_only_fields = ['createdby', 'modifiedby', 'created', 'modified']


class UserImageSerializer(serializers.ModelSerializer):
    class Meta:
        model = models.UserImage
        fields = '__all__'
        read_only_fields = ['createdby', 'modifiedby', 'created', 'modified']
