from rest_framework import serializers
from src.applicationlayer import serializers as app_serializers
from src.entities import models


# Used for Create and Update
class UserManagementSerializer(serializers.ModelSerializer):
    image = serializers.SerializerMethodField()

    class Meta:
        model = models.User
        exclude = ['password']

    def get_image(self, user):
        request = self.context.get('request')

        primayPic = user.user_images.filter(is_primary=True).first()
        if primayPic:
            print(primayPic.image.url)
            return request.build_absolute_uri(primayPic.image.url)
        else:
            return request.build_absolute_uri('/media/no-user.png')


# Used for Retrieve and List
class UserManagementRoleSerializer(serializers.ModelSerializer):
    permissions = serializers.SlugRelatedField(many=True,
                                               read_only=True,
                                               slug_field='code')

    class Meta:
        model = models.Role
        fields = '__all__'
        read_only_fields = ['createdby', 'modifiedby', 'created', 'modified']


# Used for Retrieve and List
class UserManagementRetreiveSerializer(serializers.ModelSerializer):
    image = serializers.SerializerMethodField()
    role = UserManagementRoleSerializer()
    special_permissions = serializers.SlugRelatedField(many=True,
                                                       read_only=True,
                                                       slug_field='code')

    class Meta:
        model = models.User
        exclude = ['password']

    def get_image(self, user):
        request = self.context.get('request')

        primayPic = user.user_images.filter(is_primary=True).first()
        if primayPic:
            print(primayPic.image.url)
            return request.build_absolute_uri(primayPic.image.url)
        else:
            return request.build_absolute_uri('/media/no-user.png')


class ChangePasswordSerializer(serializers.Serializer):
    old_password = serializers.CharField(max_length=100, required=True)
    new_password = serializers.CharField(max_length=100, required=True)
    new_password_confirm = serializers.CharField(max_length=100, required=True)

    class Meta:
        fields = '__all__'


class UserSpecialPermissionSerializer(serializers.Serializer):
    special_permissions = app_serializers.PermissionSerializer(required=True, many=True)

    class Meta:
        fields = '__all__'
