from .base import *
import configparser

DEBUG = True

config = configparser.ConfigParser()
config_file = os.path.join(BASE_DIR, 'env.ini')
config.read(config_file)

DATABASES = {
    'default': {
        'ENGINE': config['LOCAL']['DATABASE_ENGINE'],
        'NAME': config['LOCAL']['DATABASE_NAME'],
        'USER': config['LOCAL']['DATABASE_USER'],
        'PASSWORD': config['LOCAL']['DATABASE_PASSWORD'],
        'HOST': config['LOCAL']['DATABASE_HOST'],
        'PORT': config['LOCAL']['DATABASE_PORT'],
    }
}


# ****************
# PROGRAM SETTINGS
# ****************
OBIMS_DEFAULT_PASSWORD = config['LOCAL']['OBIMS_DEFAULT_PASSWORD']
REQUISITION_APPROVE_TIMEOUT = config['LOCAL']['REQUISITION_APPROVE_TIMEOUT']
FRONT_END_URL = config['LOCAL']['FRONT_END_URL']
AUTH_ACCESSS_TOKEN_TIMEOUT = config['LOCAL']['AUTH_ACCESSS_TOKEN_TIMEOUT']
SESSION_TIMEOUT = config['LOCAL']['SESSION_TIMEOUT']
