from .base import *
import configparser

DEBUG = False

config = configparser.ConfigParser()
config_file = os.path.join(BASE_DIR, 'env.ini')
config.read(config_file)

DATABASES = {
    'default': {
        'ENGINE': config['DEV']['DATABASE_ENGINE'],
        'NAME': config['DEV']['DATABASE_NAME'],
        'USER': config['DEV']['DATABASE_USER'],
        'PASSWORD': config['DEV']['DATABASE_PASSWORD'],
        'HOST': config['DEV']['DATABASE_HOST'],
        'PORT': config['DEV']['DATABASE_PORT'],
    }
}


# ****************
# PROGRAM SETTINGS
# ****************
OBIMS_DEFAULT_PASSWORD = config['DEV']['OBIMS_DEFAULT_PASSWORD']
REQUISITION_APPROVE_TIMEOUT = config['DEV']['REQUISITION_APPROVE_TIMEOUT']
FRONT_END_URL = config['DEV']['FRONT_END_URL']
AUTH_ACCESSS_TOKEN_TIMEOUT = config['DEV']['AUTH_ACCESSS_TOKEN_TIMEOUT']
SESSION_TIMEOUT = config['DEV']['SESSION_TIMEOUT']
