
export const SecurityHelper = (user) => {

    return new class SecurityHelper {
        constructor () {
            this.user = user
        }
    
        _getAllUserPermissions () {
            return this.user.role.permissions.concat(this.user.special_permissions)
        }
    

        can_manage_user () {
            return this.user.is_superuser ? true : this._getAllUserPermissions().includes('can_manage_user')
        }
    
        can_maintain_master_tables () {
            return this.user.is_superuser ? true : this._getAllUserPermissions().includes('can_maintain_master_tables')
        }
    
        can_manage_clients () {
            return this.user.is_superuser ? true : this._getAllUserPermissions().includes('can_manage_clients')
        }
    
        can_manage_projects () {
            return this.user.is_superuser ? true : this._getAllUserPermissions().includes('can_manage_projects')
        }
    
        can_manage_suppliers () {
            return this.user.is_superuser ? true : this._getAllUserPermissions().includes('can_manage_suppliers')
        }
    
        can_manage_warehouse () {
            return this.user.is_superuser ? true : this._getAllUserPermissions().includes('can_manage_warehouse')
        }
    
        can_view_inventory () {
            return this.user.is_superuser ? true : this._getAllUserPermissions().includes('can_view_inventory')
        }
    
        can_manage_stocks () {
            return this.user.is_superuser ? true : this._getAllUserPermissions().includes('can_manage_stocks')
        }
    
        can_view_user_requisition () {
            return this.user.is_superuser ? true : this._getAllUserPermissions().includes('can_view_user_requisition')
        }
    
        can_create_stock_requisition () {
            return this.user.is_superuser ? true : this._getAllUserPermissions().includes('can_create_stock_requisition')
        }
    
        can_manage_stock_requisition () {
            return this.user.is_superuser ? true : this._getAllUserPermissions().includes('can_manage_stock_requisition')
        }
    
        can_manage_purchase_requisition () {
            return this.user.is_superuser ? true : this._getAllUserPermissions().includes('can_manage_purchase_requisition')
        }
    
        can_authorize_requisition () {
            return this.user.is_superuser ? true : this._getAllUserPermissions().includes('can_authorize_requisition')
        }
    
        can_authorize_purchase_request () {
            return this.user.is_superuser ? true : this._getAllUserPermissions().includes('can_authorize_purchase_request')
        }
    
        can_view_stocks_report () {
            return this.user.is_superuser ? true : this._getAllUserPermissions().includes('can_view_stocks_report')
        }
    
        can_view_requisition_report () {
            return this.user.is_superuser ? true : this._getAllUserPermissions().includes('can_view_requisition_report')
        }
    }
}
