from rest_framework import serializers
from app.entities import models
from app.applicationlayer.utils import model_to_dict


class ChangeRequestTemplateApproversSerializer(
    serializers.ModelSerializer
):
    def to_representation(self, instance):
        try:
            ret = super().to_representation(instance)
            user_object = {
                "id": instance.user.id,
                "name": instance.user.name,
                "username": instance.user.username,
                "code": instance.user.code,
                "email": instance.user.email,
                "contact_no": instance.user.contact_no
            }
            ret['company'] = model_to_dict(instance.user.department.company)
            ret['department'] = model_to_dict(instance.user.department)
            ret['user'] = user_object

            if instance.user or instance.delegation.lower() == 'requestor':
                ret['editable_user'] = False
            else:
                ret['editable_user'] = True

            if instance.company or instance.delegation.lower() == 'requestor':
                ret['editable_comp'] = False
            else:
                ret['editable_comp'] = True

            if instance.department  or instance.delegation.lower() == 'requestor':
                ret['editable_dept'] = False
            else:
                ret['editable_dept'] = True

            return ret
        except Exception as e:
            
            if instance.user or instance.delegation.lower() == 'requestor':
                ret['editable_user'] = False
            else:
                ret['user'] = None
                ret['editable_user'] = True

            if instance.company or instance.delegation.lower() == 'requestor':
                ret['company'] = model_to_dict(
                    instance.company)
                ret['editable_comp'] = False
            else:
                ret['company'] = None
                ret['editable_comp'] = True

            if instance.department  or instance.delegation.lower() == 'requestor':
                ret['department'] = model_to_dict(
                    instance.department)
                ret['editable_dept'] = False
            else:
                ret['department'] = None
                ret['editable_dept'] = True

            return ret

    class Meta:
        model = models.ChangeRequestTemplateApprovers
        fields = '__all__'
        read_only_fields = ['created', 'code']