from rest_framework.views import APIView
from rest_framework import viewsets
from rest_framework.response import Response
from app.entities import enums
from app.applicationlayer.utils import main_threading
from app.helper.email_service import sender
from rest_framework.permissions import AllowAny
from app.entities.models import (
    User, Company, Department
)
from app.applicationlayer.utils import CustomPagination
from app.entities import enums
from django.db.models import Count

class RMSDashBoardViewSet(APIView):

    def get(self, request, format=None):
        # try:

            enums_company = enums.UserTypeEnum.COMPANY_USER_ADMIN.value
            enums_department = enums.UserTypeEnum.DEPARTMENT_USER_ADMIN.value
            enums_oua = enums.UserTypeEnum.OVERALL_USER_ADMIN.value

            user_type = request.user.user_type
            user_company = request.user.department.company.code
            user_department = request.user.department.code

            department_count = ''
            company_count = ''
            user_count = ''

            arr_company = []

            recently_company = {}

            recently_users = User.objects.all().values(
                'name',
                'department__company__name',
                'department__name',
                'date_joined'
            ).order_by('-date_joined')

            if user_type == enums_department:

                company_count = 1
                department_count = 1
                user_count = User.objects.filter(
                    department=str(user_department)
                ).exclude(id=1).count()

                recently_company['company_name'] = request.user.department.company.name

                # recently_company['no_department'] = Department.objects.filter(
                #     code=str(user_department)
                # ).exclude(id=1).count()


                recently_company['no_department'] = 1

                recently_company['no_users'] = user_count

                recently_company['date_added'] = request.user.department.company.created

                arr_company.append(recently_company)
                
                recently_users = recently_users.filter(
                    department=str(user_department)
                )

            elif user_type == enums_company:
                company_count = 1
                user_count = User.objects.filter(
                    department__company=str(user_company)
                ).exclude(id=1).count()

                department_count = Department.objects.filter(
                    company=str(user_company)
                ).exclude(id=1).count()

                recently_company['company_name'] = request.user.department.company.name
                recently_company['no_department'] = department_count

                recently_company['no_users'] = User.objects.filter(
                    department__company__code=str(user_company)
                ).exclude(id=1).count()

                recently_company['date_added'] = request.user.department.company.created

                arr_company.append(recently_company)

                recently_users = recently_users.filter(
                    department__company__code=str(user_company)
                )

            elif user_type == enums_oua:
                company_count = Company.objects.count()
                department_count = Department.objects.exclude(id=1).count()
                user_count = User.objects.exclude(id=1).count()
                companies = Company.objects.all().order_by('-created')[0:10]

                for data in companies:
                    recently_company['company_name'] = data.name
                    recently_company['no_department'] = data.companies.exclude(id=1).count()

                    recently_company['no_users'] = User.objects.filter(
                        department__company__code=str(data.code)
                    ).count()

                    recently_company['date_added'] = data.created

                    arr_company.append(recently_company)
                    recently_company = {}

            else:
                company_count = Company.objects.count()
                companies = Company.objects.all()[0:10]
                department_count = Department.objects.count()
                user_count = User.objects.all().count()

                for data in companies:
                    recently_company['company_name'] = data.name
                    recently_company['no_department'] = data.companies.count()

                    recently_company['no_users'] = User.objects.filter(
                        department__company__code=str(data.code)
                    ).count()

                    recently_company['date_added'] = data.created

                    arr_company.append(recently_company)
                    recently_company = {}
                data = {
                    "company_count": company_count,
                    "department_count": department_count,
                    "user_count": user_count,
                    "recent_companies": arr_company,
                    "recent_users": recently_users[:10]
                }
                return Response(data)


            data = {
                "company_count": company_count,
                "department_count": department_count,
                "user_count": user_count,
                "recent_companies": arr_company,
                "recent_users": recently_users.exclude(id=1)[:10]
            }


            return Response(data)

        # except Exception as e:
        #     return Response(
        #         {'message': "query params department_code and company_code are both expected"},
        #         status=status.HTTP_400_BAD_REQUEST
        #     )