from app.entities import models
from rest_framework import serializers
from django.db.models import Q


class ChangeRequestTemplatesSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestTemplateHeader
        fields = '__all__'
        read_only_fields = ['created', 'deleted_at', 'template_no']
        

class ChangeRequestTemplateApproversSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestTemplateApprovers
        fields = '__all__'
        read_only_fields = ['created', 'deleted_at', 'code']


class ChangeRequestTemplateStakeHoldersSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestTemplateStakeHolders
        fields = '__all__'
        read_only_fields = ['created', 'deleted_at', 'code']
    

class ChangeRequestTemplateAttachmentsSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestTemplateAttachments
        fields = '__all__'
        read_only_fields = ['created', 'deleted_at', 'code']


class ChangeRequestTemplateDetailsSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestTemplateDetails
        fields = '__all__'
        read_only_fields = ['created', 'deleted_at', 'code']


class ChangeRequestFormHeaderSerializer(
    serializers.ModelSerializer
):
    # def to_representation(self, instance):
    #     ret = super().to_representation(instance)
    #     try:
    #         # id_number = self.context.get('request').META.get('HTTP_ACCOUNT_NO')
    #         id_number = "Acct-20190813-0000137"
    #         current_level = models.ChangeRequestFormApprovers.objects.filter(
    #             Q(form_code=ret['form_code']) &
    #             Q(deleted_at=None) &
    #             (Q(action='') | Q(action=None))
    #         ).order_by('level')
            
    #         if current_level.first()['user'] == id_number:
    #             if instance.status.lower() == 'rejected':
    #                 approver = 'No'
    #             elif instance.status.lower() == 'cancelled':
    #                 approver = 'No'
    #             elif instance.status.lower() == 'closed':
    #                 approver = 'No'
    #             else:
    #                 approver = 'Yes'
    #         else:
    #             approver = 'No'
    #         ret['action'] = approver
    #         return ret
    #     except Exception as e:
    #         ret['action'] = "No"
    #         return ret

    class Meta:
        model = models.ChangeRequestFormHeader
        fields = '__all__'
        read_only_fields = ['created', 'deleted_at', 'form_code']


class ChangeRequestFormApproversSerializer(
    serializers.ModelSerializer
):
    # def to_representation(self, instance):
    #     ret = super().to_representation(instance)
    #     try:
    #         user = instance.user
            
    #         user_details = get_account_details(user)
    #         name = user_details['name']
    #         group = user_details['groups'][0]['name']
    #         company = user_details['groups'][0]['company__name']

    #         ret['name'] = name
    #         ret['department'] = group
    #         ret['company'] = company
    #         return ret

    #     except Exception as e:
    #         ret['name'] = "none"
    #         ret['department'] = "none"
    #         ret['company'] = "none"
    #         return ret

    class Meta:
        model = models.ChangeRequestFormApprovers
        fields = '__all__'
        read_only_fields = ['created', 'deleted_at', 'code']


class ChangeRequestFormStakeHoldersSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestFormStakeHolders
        fields = '__all__'
        read_only_fields = ['created', 'deleted_at', 'code']


class ChangeRequestFormAttachmentsSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestFormAttachments
        fields = '__all__'
        read_only_fields = ['created', 'deleted_at', 'code']


class ChangeRequestFormDetailsSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestFormDetails
        fields = '__all__'
        read_only_fields = ['created', 'deleted_at', 'code']
