from django.urls import path, include
from rest_framework import routers
from django.conf.urls import url

from app.applicationlayer.management.application.views import ApplicationViewSet
from app.applicationlayer.management.company.views import CompanyViewSet
from app.applicationlayer.management.department.views import DepartmentViewSet
from app.applicationlayer.management.module.views import ModuleViewSet
from app.applicationlayer.management.account.views import UserViewSet
from app.businesslayer.company.views import AdminCompanyViewSet


router = routers.DefaultRouter()

router.register(r'applications', ApplicationViewSet)
router.register(r'companies', CompanyViewSet)
router.register(r'departments', DepartmentViewSet)
router.register(r'modules', ModuleViewSet)
router.register(r'users', UserViewSet)

urlpatterns = (
    path('', include(router.urls)),
)
