-- --------------------------------------------------------
-- Host:                         52.74.129.178
-- Server version:               5.5.60-MariaDB - MariaDB Server
-- Server OS:                    Linux
-- HeidiSQL Version:             9.4.0.5125
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


-- Dumping database structure for rms_db
CREATE DATABASE IF NOT EXISTS `rms_db` /*!40100 DEFAULT CHARACTER SET latin1 */;
USE `rms_db`;

-- Dumping structure for table rms_db.allowed_company
CREATE TABLE IF NOT EXISTS `allowed_company` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `create_change_request` tinyint(1) NOT NULL,
  `create_change_request_template` tinyint(1) NOT NULL,
  `view_all_change_request` tinyint(1) NOT NULL,
  `created_at` datetime(6) NOT NULL,
  `deleted_at` datetime(6) DEFAULT NULL,
  `company_pivot_id` varchar(255) NOT NULL,
  `group_pivots_id` varchar(255) NOT NULL,
  `id_number_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `allowed_company_company_pivot_id_35c7dec7_fk_companies_code` (`company_pivot_id`),
  KEY `allowed_company_group_pivots_id_3b2e331c_fk_departments_code` (`group_pivots_id`),
  KEY `allowed_company_id_number_id_7c5c7fc8_fk_auth_user_code` (`id_number_id`),
  CONSTRAINT `allowed_company_id_number_id_7c5c7fc8_fk_auth_user_code` FOREIGN KEY (`id_number_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `allowed_company_company_pivot_id_35c7dec7_fk_companies_code` FOREIGN KEY (`company_pivot_id`) REFERENCES `companies` (`code`),
  CONSTRAINT `allowed_company_group_pivots_id_3b2e331c_fk_departments_code` FOREIGN KEY (`group_pivots_id`) REFERENCES `departments` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.allowed_company: ~2 rows (approximately)
DELETE FROM `allowed_company`;
/*!40000 ALTER TABLE `allowed_company` DISABLE KEYS */;
INSERT INTO `allowed_company` (`id`, `create_change_request`, `create_change_request_template`, `view_all_change_request`, `created_at`, `deleted_at`, `company_pivot_id`, `group_pivots_id`, `id_number_id`) VALUES
	(39, 1, 1, 1, '2019-09-24 19:09:07.825106', NULL, 'COMPANY-20190924-0000002', 'DEPARTMENT-20190924-0000003', 'USER-20190924-0000041'),
	(40, 1, 1, 1, '2019-09-24 19:10:07.377184', NULL, 'COMPANY-20190924-0000002', 'DEPARTMENT-20190924-0000003', 'USER-20190924-0000043');
/*!40000 ALTER TABLE `allowed_company` ENABLE KEYS */;

-- Dumping structure for table rms_db.applications
CREATE TABLE IF NOT EXISTS `applications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.applications: ~3 rows (approximately)
DELETE FROM `applications`;
/*!40000 ALTER TABLE `applications` DISABLE KEYS */;
INSERT INTO `applications` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `code`, `name`) VALUES
	(1, '2019-09-23 12:43:33.754098', 'superuser', '2019-09-23 12:43:33.754098', 'superuser', 'APP-20190923-0000001', 'Resource Management System'),
	(2, '2019-09-23 12:43:40.512905', 'superuser', '2019-09-23 12:43:40.512905', 'superuser', 'APP-20190923-0000002', 'Change Request Management System'),
	(3, '2019-09-23 12:43:55.957076', 'superuser', '2019-09-23 12:43:55.957076', 'superuser', 'APP-20190923-0000003', 'Asset Management System');
/*!40000 ALTER TABLE `applications` ENABLE KEYS */;

-- Dumping structure for table rms_db.attachments
CREATE TABLE IF NOT EXISTS `attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.attachments: ~0 rows (approximately)
DELETE FROM `attachments`;
/*!40000 ALTER TABLE `attachments` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachments` ENABLE KEYS */;

-- Dumping structure for table rms_db.authtoken_token
CREATE TABLE IF NOT EXISTS `authtoken_token` (
  `key` varchar(40) NOT NULL,
  `created` datetime(6) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`key`),
  UNIQUE KEY `user_id` (`user_id`),
  CONSTRAINT `authtoken_token_user_id_35299eff_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.authtoken_token: ~2 rows (approximately)
DELETE FROM `authtoken_token`;
/*!40000 ALTER TABLE `authtoken_token` DISABLE KEYS */;
INSERT INTO `authtoken_token` (`key`, `created`, `user_id`) VALUES
	('178f38b845886399dbb18452e9235b8f88e90d20', '2019-09-26 16:09:14.644220', 41),
	('ba9a275c67036d872f5cfd6862488fc115569fd3', '2019-09-26 15:57:18.791472', 1);
/*!40000 ALTER TABLE `authtoken_token` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_access_token
CREATE TABLE IF NOT EXISTS `auth_access_token` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(255) NOT NULL,
  `token` longtext NOT NULL,
  `passcode` varchar(255) NOT NULL,
  `timeout` int(11) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `auth_access_token_user_id_c480a680_fk_auth_user_code` (`user_id`),
  CONSTRAINT `auth_access_token_user_id_c480a680_fk_auth_user_code` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.auth_access_token: ~0 rows (approximately)
DELETE FROM `auth_access_token`;
/*!40000 ALTER TABLE `auth_access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_access_token` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_group
CREATE TABLE IF NOT EXISTS `auth_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.auth_group: ~0 rows (approximately)
DELETE FROM `auth_group`;
/*!40000 ALTER TABLE `auth_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_group` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_group_permissions
CREATE TABLE IF NOT EXISTS `auth_group_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_group_permissions_group_id_permission_id_0cd325b0_uniq` (`group_id`,`permission_id`),
  KEY `auth_group_permissio_permission_id_84c5c92e_fk_auth_perm` (`permission_id`),
  CONSTRAINT `auth_group_permissio_permission_id_84c5c92e_fk_auth_perm` FOREIGN KEY (`permission_id`) REFERENCES `auth_permission` (`id`),
  CONSTRAINT `auth_group_permissions_group_id_b120cbf9_fk_auth_group_id` FOREIGN KEY (`group_id`) REFERENCES `auth_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.auth_group_permissions: ~0 rows (approximately)
DELETE FROM `auth_group_permissions`;
/*!40000 ALTER TABLE `auth_group_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_group_permissions` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_permission
CREATE TABLE IF NOT EXISTS `auth_permission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `content_type_id` int(11) NOT NULL,
  `codename` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_permission_content_type_id_codename_01ab375a_uniq` (`content_type_id`,`codename`),
  CONSTRAINT `auth_permission_content_type_id_2f476e4b_fk_django_co` FOREIGN KEY (`content_type_id`) REFERENCES `django_content_type` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=141 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.auth_permission: ~140 rows (approximately)
DELETE FROM `auth_permission`;
/*!40000 ALTER TABLE `auth_permission` DISABLE KEYS */;
INSERT INTO `auth_permission` (`id`, `name`, `content_type_id`, `codename`) VALUES
	(1, 'Can add log entry', 1, 'add_logentry'),
	(2, 'Can change log entry', 1, 'change_logentry'),
	(3, 'Can delete log entry', 1, 'delete_logentry'),
	(4, 'Can view log entry', 1, 'view_logentry'),
	(5, 'Can add permission', 2, 'add_permission'),
	(6, 'Can change permission', 2, 'change_permission'),
	(7, 'Can delete permission', 2, 'delete_permission'),
	(8, 'Can view permission', 2, 'view_permission'),
	(9, 'Can add group', 3, 'add_group'),
	(10, 'Can change group', 3, 'change_group'),
	(11, 'Can delete group', 3, 'delete_group'),
	(12, 'Can view group', 3, 'view_group'),
	(13, 'Can add content type', 4, 'add_contenttype'),
	(14, 'Can change content type', 4, 'change_contenttype'),
	(15, 'Can delete content type', 4, 'delete_contenttype'),
	(16, 'Can view content type', 4, 'view_contenttype'),
	(17, 'Can add session', 5, 'add_session'),
	(18, 'Can change session', 5, 'change_session'),
	(19, 'Can delete session', 5, 'delete_session'),
	(20, 'Can view session', 5, 'view_session'),
	(21, 'Can add Token', 6, 'add_token'),
	(22, 'Can change Token', 6, 'change_token'),
	(23, 'Can delete Token', 6, 'delete_token'),
	(24, 'Can view Token', 6, 'view_token'),
	(25, 'Can add user', 7, 'add_user'),
	(26, 'Can change user', 7, 'change_user'),
	(27, 'Can delete user', 7, 'delete_user'),
	(28, 'Can view user', 7, 'view_user'),
	(29, 'Can add application', 8, 'add_application'),
	(30, 'Can change application', 8, 'change_application'),
	(31, 'Can delete application', 8, 'delete_application'),
	(32, 'Can view application', 8, 'view_application'),
	(33, 'Can add attachment', 9, 'add_attachment'),
	(34, 'Can change attachment', 9, 'change_attachment'),
	(35, 'Can delete attachment', 9, 'delete_attachment'),
	(36, 'Can view attachment', 9, 'view_attachment'),
	(37, 'Can add change request form header', 10, 'add_changerequestformheader'),
	(38, 'Can change change request form header', 10, 'change_changerequestformheader'),
	(39, 'Can delete change request form header', 10, 'delete_changerequestformheader'),
	(40, 'Can view change request form header', 10, 'view_changerequestformheader'),
	(41, 'Can add change request history', 11, 'add_changerequesthistory'),
	(42, 'Can change change request history', 11, 'change_changerequesthistory'),
	(43, 'Can delete change request history', 11, 'delete_changerequesthistory'),
	(44, 'Can view change request history', 11, 'view_changerequesthistory'),
	(45, 'Can add change request template header', 12, 'add_changerequesttemplateheader'),
	(46, 'Can change change request template header', 12, 'change_changerequesttemplateheader'),
	(47, 'Can delete change request template header', 12, 'delete_changerequesttemplateheader'),
	(48, 'Can view change request template header', 12, 'view_changerequesttemplateheader'),
	(49, 'Can add company', 13, 'add_company'),
	(50, 'Can change company', 13, 'change_company'),
	(51, 'Can delete company', 13, 'delete_company'),
	(52, 'Can view company', 13, 'view_company'),
	(53, 'Can add email logs', 14, 'add_emaillogs'),
	(54, 'Can change email logs', 14, 'change_emaillogs'),
	(55, 'Can delete email logs', 14, 'delete_emaillogs'),
	(56, 'Can view email logs', 14, 'view_emaillogs'),
	(57, 'Can add entity log', 15, 'add_entitylog'),
	(58, 'Can change entity log', 15, 'change_entitylog'),
	(59, 'Can delete entity log', 15, 'delete_entitylog'),
	(60, 'Can view entity log', 15, 'view_entitylog'),
	(61, 'Can add password reset', 16, 'add_passwordreset'),
	(62, 'Can change password reset', 16, 'change_passwordreset'),
	(63, 'Can delete password reset', 16, 'delete_passwordreset'),
	(64, 'Can view password reset', 16, 'view_passwordreset'),
	(65, 'Can add permission', 17, 'add_permission'),
	(66, 'Can change permission', 17, 'change_permission'),
	(67, 'Can delete permission', 17, 'delete_permission'),
	(68, 'Can view permission', 17, 'view_permission'),
	(69, 'Can add role', 18, 'add_role'),
	(70, 'Can change role', 18, 'change_role'),
	(71, 'Can delete role', 18, 'delete_role'),
	(72, 'Can view role', 18, 'view_role'),
	(73, 'Can add status', 19, 'add_status'),
	(74, 'Can change status', 19, 'change_status'),
	(75, 'Can delete status', 19, 'delete_status'),
	(76, 'Can view status', 19, 'view_status'),
	(77, 'Can add user image', 20, 'add_userimage'),
	(78, 'Can change user image', 20, 'change_userimage'),
	(79, 'Can delete user image', 20, 'delete_userimage'),
	(80, 'Can view user image', 20, 'view_userimage'),
	(81, 'Can add role permission', 21, 'add_rolepermission'),
	(82, 'Can change role permission', 21, 'change_rolepermission'),
	(83, 'Can delete role permission', 21, 'delete_rolepermission'),
	(84, 'Can view role permission', 21, 'view_rolepermission'),
	(85, 'Can add notification', 22, 'add_notification'),
	(86, 'Can change notification', 22, 'change_notification'),
	(87, 'Can delete notification', 22, 'delete_notification'),
	(88, 'Can view notification', 22, 'view_notification'),
	(89, 'Can add module', 23, 'add_module'),
	(90, 'Can change module', 23, 'change_module'),
	(91, 'Can delete module', 23, 'delete_module'),
	(92, 'Can view module', 23, 'view_module'),
	(93, 'Can add department', 24, 'add_department'),
	(94, 'Can change department', 24, 'change_department'),
	(95, 'Can delete department', 24, 'delete_department'),
	(96, 'Can view department', 24, 'view_department'),
	(97, 'Can add change request template stake holders', 25, 'add_changerequesttemplatestakeholders'),
	(98, 'Can change change request template stake holders', 25, 'change_changerequesttemplatestakeholders'),
	(99, 'Can delete change request template stake holders', 25, 'delete_changerequesttemplatestakeholders'),
	(100, 'Can view change request template stake holders', 25, 'view_changerequesttemplatestakeholders'),
	(101, 'Can add change request template details', 26, 'add_changerequesttemplatedetails'),
	(102, 'Can change change request template details', 26, 'change_changerequesttemplatedetails'),
	(103, 'Can delete change request template details', 26, 'delete_changerequesttemplatedetails'),
	(104, 'Can view change request template details', 26, 'view_changerequesttemplatedetails'),
	(105, 'Can add change request template attachments', 27, 'add_changerequesttemplateattachments'),
	(106, 'Can change change request template attachments', 27, 'change_changerequesttemplateattachments'),
	(107, 'Can delete change request template attachments', 27, 'delete_changerequesttemplateattachments'),
	(108, 'Can view change request template attachments', 27, 'view_changerequesttemplateattachments'),
	(109, 'Can add change request template approvers', 28, 'add_changerequesttemplateapprovers'),
	(110, 'Can change change request template approvers', 28, 'change_changerequesttemplateapprovers'),
	(111, 'Can delete change request template approvers', 28, 'delete_changerequesttemplateapprovers'),
	(112, 'Can view change request template approvers', 28, 'view_changerequesttemplateapprovers'),
	(113, 'Can add change request form stake holders', 29, 'add_changerequestformstakeholders'),
	(114, 'Can change change request form stake holders', 29, 'change_changerequestformstakeholders'),
	(115, 'Can delete change request form stake holders', 29, 'delete_changerequestformstakeholders'),
	(116, 'Can view change request form stake holders', 29, 'view_changerequestformstakeholders'),
	(117, 'Can add change request form details', 30, 'add_changerequestformdetails'),
	(118, 'Can change change request form details', 30, 'change_changerequestformdetails'),
	(119, 'Can delete change request form details', 30, 'delete_changerequestformdetails'),
	(120, 'Can view change request form details', 30, 'view_changerequestformdetails'),
	(121, 'Can add change request form attachments', 31, 'add_changerequestformattachments'),
	(122, 'Can change change request form attachments', 31, 'change_changerequestformattachments'),
	(123, 'Can delete change request form attachments', 31, 'delete_changerequestformattachments'),
	(124, 'Can view change request form attachments', 31, 'view_changerequestformattachments'),
	(125, 'Can add change request form approvers', 32, 'add_changerequestformapprovers'),
	(126, 'Can change change request form approvers', 32, 'change_changerequestformapprovers'),
	(127, 'Can delete change request form approvers', 32, 'delete_changerequestformapprovers'),
	(128, 'Can view change request form approvers', 32, 'view_changerequestformapprovers'),
	(129, 'Can add auth token', 33, 'add_authtoken'),
	(130, 'Can change auth token', 33, 'change_authtoken'),
	(131, 'Can delete auth token', 33, 'delete_authtoken'),
	(132, 'Can view auth token', 33, 'view_authtoken'),
	(133, 'Can add allowed company', 34, 'add_allowedcompany'),
	(134, 'Can change allowed company', 34, 'change_allowedcompany'),
	(135, 'Can delete allowed company', 34, 'delete_allowedcompany'),
	(136, 'Can view allowed company', 34, 'view_allowedcompany'),
	(137, 'Can add master attachment', 35, 'add_masterattachment'),
	(138, 'Can change master attachment', 35, 'change_masterattachment'),
	(139, 'Can delete master attachment', 35, 'delete_masterattachment'),
	(140, 'Can view master attachment', 35, 'view_masterattachment');
/*!40000 ALTER TABLE `auth_permission` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user
CREATE TABLE IF NOT EXISTS `auth_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `last_login` datetime(6) DEFAULT NULL,
  `is_superuser` tinyint(1) NOT NULL,
  `first_name` varchar(30) NOT NULL,
  `last_name` varchar(150) NOT NULL,
  `is_staff` tinyint(1) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `date_joined` datetime(6) NOT NULL,
  `user_type` varchar(100) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `username` varchar(255) NOT NULL,
  `password` varchar(255) DEFAULT NULL,
  `contact_no` varchar(255) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `default_app_id` varchar(255) DEFAULT NULL,
  `department_id` varchar(255) DEFAULT NULL,
  `doa_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `username` (`username`),
  KEY `auth_user_default_app_id_410ec732_fk_applications_code` (`default_app_id`),
  KEY `auth_user_department_id_ff5fa3db_fk_departments_code` (`department_id`),
  KEY `auth_user_doa_id_5076b369_fk_auth_user_code` (`doa_id`),
  CONSTRAINT `auth_user_doa_id_5076b369_fk_auth_user_code` FOREIGN KEY (`doa_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `auth_user_default_app_id_410ec732_fk_applications_code` FOREIGN KEY (`default_app_id`) REFERENCES `applications` (`code`),
  CONSTRAINT `auth_user_department_id_ff5fa3db_fk_departments_code` FOREIGN KEY (`department_id`) REFERENCES `departments` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=44 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.auth_user: ~4 rows (approximately)
DELETE FROM `auth_user`;
/*!40000 ALTER TABLE `auth_user` DISABLE KEYS */;
INSERT INTO `auth_user` (`id`, `last_login`, `is_superuser`, `first_name`, `last_name`, `is_staff`, `is_active`, `date_joined`, `user_type`, `code`, `name`, `username`, `password`, `contact_no`, `email`, `default_app_id`, `department_id`, `doa_id`) VALUES
	(1, '2019-09-23 15:50:43.923500', 1, '', '', 1, 1, '2019-09-23 12:42:37.938304', 'SU', 'USER-20190923-0000001', '', 'superuser', 'pbkdf2_sha256$150000$iRXbWni4Raha$8DJ3wThPtpO9yupcR/cZZQjSQz5DTTLrj2SWClkcqDc=', NULL, 'red@tirsolutions.com', 'APP-20190923-0000001', 'DEPARTMENT-20190923-0000001', NULL),
	(41, NULL, 0, '', '', 0, 1, '2019-09-24 17:15:04.409001', 'USR', 'USER-20190924-0000041', 'Wownman', 'Wownman', 'pbkdf2_sha256$150000$olNZcVXGWmdD$LYt/O1uklgpNjwLd7NU8RYd8ptBXg+P5QhUVvsbnBAM=', '13213', 'red@tirsolutions.com', 'APP-20190923-0000002', 'DEPARTMENT-20190923-0000002', NULL),
	(42, NULL, 0, '', '', 0, 1, '2019-09-24 18:21:20.427951', 'USR', 'USER-20190924-0000042', 'testEdit', 'testEdit', 'pbkdf2_sha256$150000$bu7eaAT9s8Ky$CZ/zBr34mpEXGOGR3NSL6KyoKLNY5tQA8ZalZBdKts4=', '132', 'testEdit@mail.com', 'APP-20190923-0000002', 'DEPARTMENT-20190923-0000001', NULL),
	(43, NULL, 0, '', '', 0, 1, '2019-09-24 19:10:01.481071', 'OUA', 'USER-20190924-0000043', 'Ritas', 'test33', 'pbkdf2_sha256$150000$SDrfFVquBGr8$E0jn5bG5HUN9R91MnmKUEFT/AjAMlMMVL8DfvnZWOIk=', '1312313', 'test@gmail.com', 'APP-20190923-0000001', 'DEPARTMENT-20190923-0000002', NULL);
/*!40000 ALTER TABLE `auth_user` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user_application
CREATE TABLE IF NOT EXISTS `auth_user_application` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `application_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_user_application_user_id_application_id_4d89d44a_uniq` (`user_id`,`application_id`),
  KEY `auth_user_application_application_id_5c17d611_fk_applications_id` (`application_id`),
  CONSTRAINT `auth_user_application_application_id_5c17d611_fk_applications_id` FOREIGN KEY (`application_id`) REFERENCES `applications` (`id`),
  CONSTRAINT `auth_user_application_user_id_7b07e391_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.auth_user_application: ~7 rows (approximately)
DELETE FROM `auth_user_application`;
/*!40000 ALTER TABLE `auth_user_application` DISABLE KEYS */;
INSERT INTO `auth_user_application` (`id`, `user_id`, `application_id`) VALUES
	(1, 1, 1),
	(2, 1, 2),
	(3, 1, 3),
	(79, 41, 2),
	(80, 42, 2),
	(82, 43, 1),
	(81, 43, 2);
/*!40000 ALTER TABLE `auth_user_application` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user_groups
CREATE TABLE IF NOT EXISTS `auth_user_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_user_groups_user_id_group_id_94350c0c_uniq` (`user_id`,`group_id`),
  KEY `auth_user_groups_group_id_97559544_fk_auth_group_id` (`group_id`),
  CONSTRAINT `auth_user_groups_group_id_97559544_fk_auth_group_id` FOREIGN KEY (`group_id`) REFERENCES `auth_group` (`id`),
  CONSTRAINT `auth_user_groups_user_id_6a12ed8b_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.auth_user_groups: ~0 rows (approximately)
DELETE FROM `auth_user_groups`;
/*!40000 ALTER TABLE `auth_user_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_user_groups` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user_images
CREATE TABLE IF NOT EXISTS `auth_user_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `is_primary` tinyint(1) NOT NULL,
  `user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `auth_user_images_user_id_7c29985d_fk_auth_user_code` (`user_id`),
  CONSTRAINT `auth_user_images_user_id_7c29985d_fk_auth_user_code` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.auth_user_images: ~0 rows (approximately)
DELETE FROM `auth_user_images`;
/*!40000 ALTER TABLE `auth_user_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_user_images` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user_user_permissions
CREATE TABLE IF NOT EXISTS `auth_user_user_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_user_user_permissions_user_id_permission_id_14a6b632_uniq` (`user_id`,`permission_id`),
  KEY `auth_user_user_permi_permission_id_1fbb5f2c_fk_auth_perm` (`permission_id`),
  CONSTRAINT `auth_user_user_permi_permission_id_1fbb5f2c_fk_auth_perm` FOREIGN KEY (`permission_id`) REFERENCES `auth_permission` (`id`),
  CONSTRAINT `auth_user_user_permissions_user_id_a95ead1b_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.auth_user_user_permissions: ~0 rows (approximately)
DELETE FROM `auth_user_user_permissions`;
/*!40000 ALTER TABLE `auth_user_user_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_user_user_permissions` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_form_approvers
CREATE TABLE IF NOT EXISTS `change_request_form_approvers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` varchar(50) DEFAULT NULL,
  `delegation` varchar(50) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `action` varchar(50) DEFAULT NULL,
  `date_sent` datetime(6) DEFAULT NULL,
  `form_code_id` varchar(255) NOT NULL,
  `tmp_approver_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `action_date` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_form__form_code_id_5dfe5c56_fk_change_re` (`form_code_id`),
  KEY `change_request_form__tmp_approver_id_fff34e6d_fk_change_re` (`tmp_approver_id`),
  KEY `change_request_form_approvers_user_id_3a71dffe_fk_auth_user_code` (`user_id`),
  CONSTRAINT `change_request_form_approvers_user_id_3a71dffe_fk_auth_user_code` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `change_request_form__form_code_id_5dfe5c56_fk_change_re` FOREIGN KEY (`form_code_id`) REFERENCES `change_request_form_headers` (`form_code`),
  CONSTRAINT `change_request_form__tmp_approver_id_fff34e6d_fk_change_re` FOREIGN KEY (`tmp_approver_id`) REFERENCES `change_request_template_approvers` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_form_approvers: ~0 rows (approximately)
DELETE FROM `change_request_form_approvers`;
/*!40000 ALTER TABLE `change_request_form_approvers` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_form_approvers` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_form_attachments
CREATE TABLE IF NOT EXISTS `change_request_form_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_type` varchar(255) NOT NULL,
  `attachment_name` varchar(255) NOT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `file_upload_id` int(11) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `form_code_id` varchar(255) NOT NULL,
  `tmp_attach_id` varchar(255) DEFAULT NULL,
  `uploaded_by_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_form__form_code_id_6f991ff9_fk_change_re` (`form_code_id`),
  KEY `change_request_form__uploaded_by_id_3187c462_fk_auth_user` (`uploaded_by_id`),
  KEY `change_request_form_attachments_file_upload_id_03af7dd6` (`file_upload_id`),
  KEY `change_request_form__tmp_attach_id_14c2eae7_fk_change_re` (`tmp_attach_id`),
  CONSTRAINT `change_request_form__tmp_attach_id_14c2eae7_fk_change_re` FOREIGN KEY (`tmp_attach_id`) REFERENCES `change_request_template_attachments` (`code`),
  CONSTRAINT `change_request_form__file_upload_id_03af7dd6_fk_master_at` FOREIGN KEY (`file_upload_id`) REFERENCES `master_attachments` (`id`),
  CONSTRAINT `change_request_form__form_code_id_6f991ff9_fk_change_re` FOREIGN KEY (`form_code_id`) REFERENCES `change_request_form_headers` (`form_code`),
  CONSTRAINT `change_request_form__uploaded_by_id_3187c462_fk_auth_user` FOREIGN KEY (`uploaded_by_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_form_attachments: ~0 rows (approximately)
DELETE FROM `change_request_form_attachments`;
/*!40000 ALTER TABLE `change_request_form_attachments` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_form_attachments` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_form_details
CREATE TABLE IF NOT EXISTS `change_request_form_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_idx` longtext NOT NULL,
  `field_ref` longtext NOT NULL,
  `field_val` longtext NOT NULL,
  `field_props` longtext NOT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `form_code_id` varchar(255) NOT NULL,
  `tmp_detail_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_form__form_code_id_b66d4e40_fk_change_re` (`form_code_id`),
  KEY `change_request_form__tmp_detail_id_315fbb6d_fk_change_re` (`tmp_detail_id`),
  CONSTRAINT `change_request_form__tmp_detail_id_315fbb6d_fk_change_re` FOREIGN KEY (`tmp_detail_id`) REFERENCES `change_request_template_details` (`code`),
  CONSTRAINT `change_request_form__form_code_id_b66d4e40_fk_change_re` FOREIGN KEY (`form_code_id`) REFERENCES `change_request_form_headers` (`form_code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_form_details: ~0 rows (approximately)
DELETE FROM `change_request_form_details`;
/*!40000 ALTER TABLE `change_request_form_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_form_details` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_form_headers
CREATE TABLE IF NOT EXISTS `change_request_form_headers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `requested_to_template_name` varchar(255) NOT NULL,
  `requested_to_objective` varchar(255) DEFAULT NULL,
  `requested_to_priority` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created` datetime(6) NOT NULL,
  `form_code` varchar(255) NOT NULL,
  `cancel_date` datetime(6) DEFAULT NULL,
  `status` varchar(50) NOT NULL,
  `company_desc` varchar(255) DEFAULT NULL,
  `department_desc` varchar(255) DEFAULT NULL,
  `requested_desc` varchar(255) DEFAULT NULL,
  `old_form_code` varchar(255) DEFAULT NULL,
  `requested_to_template_id` varchar(255) NOT NULL,
  `requested_to_target_date` datetime(6) DEFAULT NULL,
  `requested_by_department_id` varchar(255) NOT NULL,
  `requested_by_user_id` varchar(255) NOT NULL,
  `requested_to_company_id` varchar(255) NOT NULL,
  `requested_to_department_id` varchar(255) NOT NULL,
  `requested_to_user_id` varchar(255) NOT NULL,
  `template_no_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `form_code` (`form_code`),
  KEY `change_request_form__requested_by_departm_af6aa045_fk_departmen` (`requested_by_department_id`),
  KEY `change_request_form__requested_by_user_id_3287070c_fk_auth_user` (`requested_by_user_id`),
  KEY `change_request_form__requested_to_company_33982877_fk_companies` (`requested_to_company_id`),
  KEY `change_request_form__requested_to_departm_c5d594cd_fk_departmen` (`requested_to_department_id`),
  KEY `change_request_form__requested_to_user_id_11252c8d_fk_auth_user` (`requested_to_user_id`),
  KEY `change_request_form__template_no_id_20abd55c_fk_change_re` (`template_no_id`),
  CONSTRAINT `change_request_form__template_no_id_20abd55c_fk_change_re` FOREIGN KEY (`template_no_id`) REFERENCES `change_request_template_headers` (`template_no`),
  CONSTRAINT `change_request_form__requested_by_departm_af6aa045_fk_departmen` FOREIGN KEY (`requested_by_department_id`) REFERENCES `departments` (`code`),
  CONSTRAINT `change_request_form__requested_by_user_id_3287070c_fk_auth_user` FOREIGN KEY (`requested_by_user_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `change_request_form__requested_to_company_33982877_fk_companies` FOREIGN KEY (`requested_to_company_id`) REFERENCES `companies` (`code`),
  CONSTRAINT `change_request_form__requested_to_departm_c5d594cd_fk_departmen` FOREIGN KEY (`requested_to_department_id`) REFERENCES `departments` (`code`),
  CONSTRAINT `change_request_form__requested_to_user_id_11252c8d_fk_auth_user` FOREIGN KEY (`requested_to_user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_form_headers: ~0 rows (approximately)
DELETE FROM `change_request_form_headers`;
/*!40000 ALTER TABLE `change_request_form_headers` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_form_headers` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_form_stakeholders
CREATE TABLE IF NOT EXISTS `change_request_form_stakeholders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `delegation` varchar(255) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `date_added` datetime(6) DEFAULT NULL,
  `form_code_id` varchar(255) NOT NULL,
  `tmp_stake_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_form__form_code_id_350d3c3d_fk_change_re` (`form_code_id`),
  KEY `change_request_form__tmp_stake_id_fe1f7139_fk_change_re` (`tmp_stake_id`),
  KEY `change_request_form__user_id_378bdf3e_fk_auth_user` (`user_id`),
  CONSTRAINT `change_request_form__user_id_378bdf3e_fk_auth_user` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `change_request_form__form_code_id_350d3c3d_fk_change_re` FOREIGN KEY (`form_code_id`) REFERENCES `change_request_form_headers` (`form_code`),
  CONSTRAINT `change_request_form__tmp_stake_id_fe1f7139_fk_change_re` FOREIGN KEY (`tmp_stake_id`) REFERENCES `change_request_template_stakeholders` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_form_stakeholders: ~0 rows (approximately)
DELETE FROM `change_request_form_stakeholders`;
/*!40000 ALTER TABLE `change_request_form_stakeholders` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_form_stakeholders` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_history
CREATE TABLE IF NOT EXISTS `change_request_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `action` varchar(50) NOT NULL,
  `entity` varchar(50) NOT NULL,
  `form_code` varchar(255) DEFAULT NULL,
  `fromValue` longtext,
  `toValue` longtext,
  `batch_no` varchar(255) DEFAULT NULL,
  `main_action` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_history: ~0 rows (approximately)
DELETE FROM `change_request_history`;
/*!40000 ALTER TABLE `change_request_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_history` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_template_approvers
CREATE TABLE IF NOT EXISTS `change_request_template_approvers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` varchar(50) DEFAULT NULL,
  `delegation` varchar(50) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `template_no_id` varchar(255) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_templ_template_no_id_fba2afd7_fk_change_re` (`template_no_id`),
  KEY `change_request_templ_user_id_958c925a_fk_auth_user` (`user_id`),
  CONSTRAINT `change_request_templ_template_no_id_fba2afd7_fk_change_re` FOREIGN KEY (`template_no_id`) REFERENCES `change_request_template_headers` (`template_no`),
  CONSTRAINT `change_request_templ_user_id_958c925a_fk_auth_user` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_template_approvers: ~1 rows (approximately)
DELETE FROM `change_request_template_approvers`;
/*!40000 ALTER TABLE `change_request_template_approvers` DISABLE KEYS */;
INSERT INTO `change_request_template_approvers` (`id`, `level`, `delegation`, `created`, `code`, `template_no_id`, `user_id`) VALUES
	(1, '1', 'Approver', '2019-09-26 15:22:12.571797', 'TMPAPR-20190926-0000001', 'TMP-20190926-0000001', 'USER-20190924-0000043');
/*!40000 ALTER TABLE `change_request_template_approvers` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_template_attachments
CREATE TABLE IF NOT EXISTS `change_request_template_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_type` varchar(255) NOT NULL,
  `attachment_name` varchar(255) NOT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `file_upload_id` int(11) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `template_no_id` varchar(255) NOT NULL,
  `uploaded_by_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_templ_template_no_id_d0247a80_fk_change_re` (`template_no_id`),
  KEY `change_request_templ_uploaded_by_id_f9c6493a_fk_auth_user` (`uploaded_by_id`),
  KEY `change_request_template_attachments_file_upload_id_8ac162e7` (`file_upload_id`),
  CONSTRAINT `change_request_templ_file_upload_id_8ac162e7_fk_master_at` FOREIGN KEY (`file_upload_id`) REFERENCES `master_attachments` (`id`),
  CONSTRAINT `change_request_templ_template_no_id_d0247a80_fk_change_re` FOREIGN KEY (`template_no_id`) REFERENCES `change_request_template_headers` (`template_no`),
  CONSTRAINT `change_request_templ_uploaded_by_id_f9c6493a_fk_auth_user` FOREIGN KEY (`uploaded_by_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_template_attachments: ~1 rows (approximately)
DELETE FROM `change_request_template_attachments`;
/*!40000 ALTER TABLE `change_request_template_attachments` DISABLE KEYS */;
INSERT INTO `change_request_template_attachments` (`id`, `attachment_type`, `attachment_name`, `file_name`, `description`, `file_upload_id`, `created`, `code`, `template_no_id`, `uploaded_by_id`) VALUES
	(1, 'Hello', 'Attachment 1', 'Sample Attachment 1', 'Sameple Description', NULL, '2019-09-26 15:22:12.579358', 'TMPATCH-20190926-0000001', 'TMP-20190926-0000001', 'USER-20190924-0000041');
/*!40000 ALTER TABLE `change_request_template_attachments` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_template_details
CREATE TABLE IF NOT EXISTS `change_request_template_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_idx` longtext NOT NULL,
  `field_ref` longtext NOT NULL,
  `field_val` longtext NOT NULL,
  `field_props` longtext NOT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `template_no_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_templ_template_no_id_d2ba31c2_fk_change_re` (`template_no_id`),
  CONSTRAINT `change_request_templ_template_no_id_d2ba31c2_fk_change_re` FOREIGN KEY (`template_no_id`) REFERENCES `change_request_template_headers` (`template_no`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_template_details: ~1 rows (approximately)
DELETE FROM `change_request_template_details`;
/*!40000 ALTER TABLE `change_request_template_details` DISABLE KEYS */;
INSERT INTO `change_request_template_details` (`id`, `field_idx`, `field_ref`, `field_val`, `field_props`, `created`, `code`, `template_no_id`) VALUES
	(1, 'Hello', 'heyu', 'Sample', 'Sample Desc', '2019-09-26 15:22:12.585691', 'TMPDETAIL-20190926-0000001', 'TMP-20190926-0000001');
/*!40000 ALTER TABLE `change_request_template_details` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_template_headers
CREATE TABLE IF NOT EXISTS `change_request_template_headers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `requested_to_template_name` varchar(255) NOT NULL,
  `requested_to_objective` varchar(255) DEFAULT NULL,
  `requested_to_priority` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created` datetime(6) NOT NULL,
  `template_no` varchar(255) NOT NULL,
  `requested_to_template_id` varchar(255) NOT NULL,
  `requested_to_target_date` varchar(10) DEFAULT NULL,
  `created_by_department_id` varchar(255) NOT NULL,
  `created_by_user_id` varchar(255) NOT NULL,
  `requested_to_company_id` varchar(255) NOT NULL,
  `requested_to_department_id` varchar(255) NOT NULL,
  `requested_to_user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `template_no` (`template_no`),
  UNIQUE KEY `requested_to_template_id` (`requested_to_template_id`),
  KEY `change_request_templ_created_by_departmen_f5629a3a_fk_departmen` (`created_by_department_id`),
  KEY `change_request_templ_created_by_user_id_ed6f2326_fk_auth_user` (`created_by_user_id`),
  KEY `change_request_templ_requested_to_company_1063b954_fk_companies` (`requested_to_company_id`),
  KEY `change_request_templ_requested_to_departm_e7b33c56_fk_departmen` (`requested_to_department_id`),
  KEY `change_request_templ_requested_to_user_id_cfad98f0_fk_auth_user` (`requested_to_user_id`),
  CONSTRAINT `change_request_templ_created_by_departmen_f5629a3a_fk_departmen` FOREIGN KEY (`created_by_department_id`) REFERENCES `departments` (`code`),
  CONSTRAINT `change_request_templ_created_by_user_id_ed6f2326_fk_auth_user` FOREIGN KEY (`created_by_user_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `change_request_templ_requested_to_company_1063b954_fk_companies` FOREIGN KEY (`requested_to_company_id`) REFERENCES `companies` (`code`),
  CONSTRAINT `change_request_templ_requested_to_departm_e7b33c56_fk_departmen` FOREIGN KEY (`requested_to_department_id`) REFERENCES `departments` (`code`),
  CONSTRAINT `change_request_templ_requested_to_user_id_cfad98f0_fk_auth_user` FOREIGN KEY (`requested_to_user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_template_headers: ~1 rows (approximately)
DELETE FROM `change_request_template_headers`;
/*!40000 ALTER TABLE `change_request_template_headers` DISABLE KEYS */;
INSERT INTO `change_request_template_headers` (`id`, `requested_to_template_name`, `requested_to_objective`, `requested_to_priority`, `description`, `created`, `template_no`, `requested_to_template_id`, `requested_to_target_date`, `created_by_department_id`, `created_by_user_id`, `requested_to_company_id`, `requested_to_department_id`, `requested_to_user_id`) VALUES
	(1, 'TEST', 'sdf', 'High', 'sdf', '2019-09-26 15:22:12.520166', 'TMP-20190926-0000001', 'qwer', '1', 'DEPARTMENT-20190923-0000002', 'USER-20190924-0000041', 'COMPANY-20190924-0000002', 'DEPARTMENT-20190924-0000003', 'USER-20190924-0000043');
/*!40000 ALTER TABLE `change_request_template_headers` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_template_stakeholders
CREATE TABLE IF NOT EXISTS `change_request_template_stakeholders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `delegation` varchar(255) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `template_no_id` varchar(255) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_templ_template_no_id_31bc8d14_fk_change_re` (`template_no_id`),
  KEY `change_request_templ_user_id_63128227_fk_auth_user` (`user_id`),
  CONSTRAINT `change_request_templ_template_no_id_31bc8d14_fk_change_re` FOREIGN KEY (`template_no_id`) REFERENCES `change_request_template_headers` (`template_no`),
  CONSTRAINT `change_request_templ_user_id_63128227_fk_auth_user` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.change_request_template_stakeholders: ~0 rows (approximately)
DELETE FROM `change_request_template_stakeholders`;
/*!40000 ALTER TABLE `change_request_template_stakeholders` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_template_stakeholders` ENABLE KEYS */;

-- Dumping structure for table rms_db.companies
CREATE TABLE IF NOT EXISTS `companies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `contact_details` longtext,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.companies: ~2 rows (approximately)
DELETE FROM `companies`;
/*!40000 ALTER TABLE `companies` DISABLE KEYS */;
INSERT INTO `companies` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `code`, `name`, `contact_details`) VALUES
	(1, '2019-09-23 12:45:31.058709', 'superuser', '2019-09-25 10:22:03.978427', 'superuser', 'COMPANY-20190923-0000001', 'Oneberry Technologies Pte Ltd.', '2152509'),
	(2, '2019-09-23 13:05:24.438314', 'superuser', '2019-09-24 19:10:15.365772', 'superuser', 'COMPANY-20190924-0000002', 'Total Integrated Resources', '2152509');
/*!40000 ALTER TABLE `companies` ENABLE KEYS */;

-- Dumping structure for table rms_db.departments
CREATE TABLE IF NOT EXISTS `departments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `company_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`),
  KEY `departments_company_id_0d17e9ca_fk_companies_code` (`company_id`),
  CONSTRAINT `departments_company_id_0d17e9ca_fk_companies_code` FOREIGN KEY (`company_id`) REFERENCES `companies` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.departments: ~4 rows (approximately)
DELETE FROM `departments`;
/*!40000 ALTER TABLE `departments` DISABLE KEYS */;
INSERT INTO `departments` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `code`, `name`, `company_id`) VALUES
	(1, '2019-09-23 12:45:52.531178', 'superuser', '2019-09-23 12:45:52.531178', 'superuser', 'DEPARTMENT-20190923-0000001', 'ADMIN', 'COMPANY-20190923-0000001'),
	(2, '2019-09-23 13:05:01.811980', 'superuser', '2019-09-23 13:05:01.811980', 'superuser', 'DEPARTMENT-20190923-0000002', 'Business Develsopment', 'COMPANY-20190923-0000001'),
	(3, '2019-09-24 19:08:55.157409', 'superuser', '2019-09-24 19:11:44.432156', 'superuser', 'DEPARTMENT-20190924-0000003', 'Quality Assurance', 'COMPANY-20190924-0000002'),
	(5, '2019-09-24 19:28:57.007445', 'superuser', '2019-09-24 19:28:57.007485', 'superuser', 'DEPARTMENT-20190924-0000005', 'test', 'COMPANY-20190923-0000001');
/*!40000 ALTER TABLE `departments` ENABLE KEYS */;

-- Dumping structure for table rms_db.django_admin_log
CREATE TABLE IF NOT EXISTS `django_admin_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action_time` datetime(6) NOT NULL,
  `object_id` longtext,
  `object_repr` varchar(200) NOT NULL,
  `action_flag` smallint(5) unsigned NOT NULL,
  `change_message` longtext NOT NULL,
  `content_type_id` int(11) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `django_admin_log_content_type_id_c4bce8eb_fk_django_co` (`content_type_id`),
  KEY `django_admin_log_user_id_c564eba6_fk_auth_user_id` (`user_id`),
  CONSTRAINT `django_admin_log_content_type_id_c4bce8eb_fk_django_co` FOREIGN KEY (`content_type_id`) REFERENCES `django_content_type` (`id`),
  CONSTRAINT `django_admin_log_user_id_c564eba6_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.django_admin_log: ~0 rows (approximately)
DELETE FROM `django_admin_log`;
/*!40000 ALTER TABLE `django_admin_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `django_admin_log` ENABLE KEYS */;

-- Dumping structure for table rms_db.django_content_type
CREATE TABLE IF NOT EXISTS `django_content_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app_label` varchar(100) NOT NULL,
  `model` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `django_content_type_app_label_model_76bd3d3b_uniq` (`app_label`,`model`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.django_content_type: ~35 rows (approximately)
DELETE FROM `django_content_type`;
/*!40000 ALTER TABLE `django_content_type` DISABLE KEYS */;
INSERT INTO `django_content_type` (`id`, `app_label`, `model`) VALUES
	(1, 'admin', 'logentry'),
	(3, 'auth', 'group'),
	(2, 'auth', 'permission'),
	(6, 'authtoken', 'token'),
	(4, 'contenttypes', 'contenttype'),
	(34, 'entities', 'allowedcompany'),
	(8, 'entities', 'application'),
	(9, 'entities', 'attachment'),
	(33, 'entities', 'authtoken'),
	(32, 'entities', 'changerequestformapprovers'),
	(31, 'entities', 'changerequestformattachments'),
	(30, 'entities', 'changerequestformdetails'),
	(10, 'entities', 'changerequestformheader'),
	(29, 'entities', 'changerequestformstakeholders'),
	(11, 'entities', 'changerequesthistory'),
	(28, 'entities', 'changerequesttemplateapprovers'),
	(27, 'entities', 'changerequesttemplateattachments'),
	(26, 'entities', 'changerequesttemplatedetails'),
	(12, 'entities', 'changerequesttemplateheader'),
	(25, 'entities', 'changerequesttemplatestakeholders'),
	(13, 'entities', 'company'),
	(24, 'entities', 'department'),
	(14, 'entities', 'emaillogs'),
	(15, 'entities', 'entitylog'),
	(35, 'entities', 'masterattachment'),
	(23, 'entities', 'module'),
	(22, 'entities', 'notification'),
	(16, 'entities', 'passwordreset'),
	(17, 'entities', 'permission'),
	(18, 'entities', 'role'),
	(21, 'entities', 'rolepermission'),
	(19, 'entities', 'status'),
	(7, 'entities', 'user'),
	(20, 'entities', 'userimage'),
	(5, 'sessions', 'session');
/*!40000 ALTER TABLE `django_content_type` ENABLE KEYS */;

-- Dumping structure for table rms_db.django_migrations
CREATE TABLE IF NOT EXISTS `django_migrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `applied` datetime(6) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.django_migrations: ~27 rows (approximately)
DELETE FROM `django_migrations`;
/*!40000 ALTER TABLE `django_migrations` DISABLE KEYS */;
INSERT INTO `django_migrations` (`id`, `app`, `name`, `applied`) VALUES
	(1, 'contenttypes', '0001_initial', '2019-09-23 12:11:35.906573'),
	(2, 'contenttypes', '0002_remove_content_type_name', '2019-09-23 12:11:36.490409'),
	(3, 'auth', '0001_initial', '2019-09-23 12:11:37.058071'),
	(4, 'auth', '0002_alter_permission_name_max_length', '2019-09-23 12:11:39.862929'),
	(5, 'auth', '0003_alter_user_email_max_length', '2019-09-23 12:11:39.921932'),
	(6, 'auth', '0004_alter_user_username_opts', '2019-09-23 12:11:39.971932'),
	(7, 'auth', '0005_alter_user_last_login_null', '2019-09-23 12:11:40.007947'),
	(8, 'auth', '0006_require_contenttypes_0002', '2019-09-23 12:11:40.049915'),
	(9, 'auth', '0007_alter_validators_add_error_messages', '2019-09-23 12:11:40.114587'),
	(10, 'auth', '0008_alter_user_username_max_length', '2019-09-23 12:11:40.137629'),
	(11, 'auth', '0009_alter_user_last_name_max_length', '2019-09-23 12:11:40.191583'),
	(12, 'auth', '0010_alter_group_name_max_length', '2019-09-23 12:11:40.776954'),
	(13, 'auth', '0011_update_proxy_permissions', '2019-09-23 12:11:40.806005'),
	(14, 'entities', '0001_initial', '2019-09-23 12:11:47.314099'),
	(15, 'admin', '0001_initial', '2019-09-23 12:12:20.565456'),
	(16, 'admin', '0002_logentry_remove_auto_add', '2019-09-23 12:12:22.270994'),
	(17, 'admin', '0003_logentry_add_action_flag_choices', '2019-09-23 12:12:22.313993'),
	(18, 'authtoken', '0001_initial', '2019-09-23 12:12:22.724754'),
	(19, 'authtoken', '0002_auto_20160226_1747', '2019-09-23 12:12:24.556122'),
	(20, 'entities', '0002_auto_20190917_1716', '2019-09-23 12:12:27.836819'),
	(21, 'entities', '0003_allowedcompany', '2019-09-23 12:12:28.055013'),
	(22, 'entities', '0004_auto_20190918_1104', '2019-09-23 12:12:32.014816'),
	(23, 'entities', '0005_auto_20190919_1625', '2019-09-23 12:12:32.061785'),
	(24, 'entities', '0006_auto_20190920_1623', '2019-09-23 12:12:32.202029'),
	(25, 'sessions', '0001_initial', '2019-09-23 12:12:32.568139'),
	(26, 'entities', '0007_auto_20190924_1206', '2019-09-24 18:38:23.631140'),
	(27, 'entities', '0008_auto_20190926_1040', '2019-09-26 15:09:49.421265');
/*!40000 ALTER TABLE `django_migrations` ENABLE KEYS */;

-- Dumping structure for table rms_db.django_session
CREATE TABLE IF NOT EXISTS `django_session` (
  `session_key` varchar(40) NOT NULL,
  `session_data` longtext NOT NULL,
  `expire_date` datetime(6) NOT NULL,
  PRIMARY KEY (`session_key`),
  KEY `django_session_expire_date_a5c62663` (`expire_date`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.django_session: ~1 rows (approximately)
DELETE FROM `django_session`;
/*!40000 ALTER TABLE `django_session` DISABLE KEYS */;
INSERT INTO `django_session` (`session_key`, `session_data`, `expire_date`) VALUES
	('mc4vdpxrj9jb7rbqrb1chb50mgbqclc9', 'MzQxODFjZjQ3YWYwOTFkYjE0MjBkOTgwNTQ0YjE0MTE4MjU1ZWUzYzp7Il9hdXRoX3VzZXJfaWQiOiIxIiwiX2F1dGhfdXNlcl9iYWNrZW5kIjoiZGphbmdvLmNvbnRyaWIuYXV0aC5iYWNrZW5kcy5Nb2RlbEJhY2tlbmQiLCJfYXV0aF91c2VyX2hhc2giOiI5YzQyMzU3N2YyZTM5ODkyMTQ5Y2I4ZjdmY2NjZDA2ZjQwNDgzMGQxIn0=', '2019-10-07 15:50:43.928893');
/*!40000 ALTER TABLE `django_session` ENABLE KEYS */;

-- Dumping structure for table rms_db.email_logs
CREATE TABLE IF NOT EXISTS `email_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `template` varchar(255) NOT NULL,
  `recipients` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `is_sent` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.email_logs: ~42 rows (approximately)
DELETE FROM `email_logs`;
/*!40000 ALTER TABLE `email_logs` DISABLE KEYS */;
INSERT INTO `email_logs` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `template`, `recipients`, `content`, `is_sent`) VALUES
	(1, '2019-09-23 15:05:04.033912', 'red@tirsolutions.com', '2019-09-23 15:05:04.033972', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'test@mail.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear test,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>test<br><br>\n<b>Password</b><br>kMmCfLzPqH<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(2, '2019-09-23 15:11:18.289586', 'red@tirsolutions.com', '2019-09-23 15:11:18.289637', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'test@mail.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear test,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>test<br><br>\n<b>Password</b><br>JCYDkZJyEG<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(3, '2019-09-23 15:12:36.090854', 'red@tirsolutions.com', '2019-09-23 15:12:36.090925', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'test@mail.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear test,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>test<br><br>\n<b>Password</b><br>Ereu8p2j5B<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(4, '2019-09-23 15:13:23.932304', 'red@tirsolutions.com', '2019-09-23 15:13:23.932363', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'test@test.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear test,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>test<br><br>\n<b>Password</b><br>yKT6DnQEj8<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(5, '2019-09-23 15:14:45.654449', 'red@tirsolutions.com', '2019-09-23 15:14:45.654507', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'tesrt@test.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear test,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>test<br><br>\n<b>Password</b><br>FwvseNbjVW<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(6, '2019-09-23 15:24:02.628865', 'red@tirsolutions.com', '2019-09-23 15:24:02.628939', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'asdf@asdf.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear sadf,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>asdf<br><br>\n<b>Password</b><br>2VG2h6xWqs<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(7, '2019-09-23 15:51:49.987044', 'red@tirsolutions.com', '2019-09-23 15:51:49.987101', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'test22@mailc.om', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear test,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>Test<br><br>\n<b>Password</b><br>xNC4n7QpbR<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(8, '2019-09-23 15:55:16.013625', 'red@tirsolutions.com', '2019-09-23 15:55:16.013681', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'test@mail.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear test,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>test<br><br>\n<b>Password</b><br>wxmTN876hE<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(9, '2019-09-23 16:06:34.050967', 'red@tirsolutions.com', '2019-09-23 16:06:34.051025', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'qwe@qwe.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear qwe,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>qwe<br><br>\n<b>Password</b><br>qwAMrgpfTJ<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(10, '2019-09-23 16:24:23.003558', 'red@tirsolutions.com', '2019-09-23 16:24:23.003620', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'qwe1@qwe.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear qwe1,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>qwe1<br><br>\n<b>Password</b><br>8S5N5QPWA9<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(11, '2019-09-23 16:30:47.765546', 'red@tirsolutions.com', '2019-09-23 16:30:47.765603', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'teestt@sdf.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear est,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>tesst<br><br>\n<b>Password</b><br>FK6TvCLSSC<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(12, '2019-09-23 16:58:29.153314', 'red@tirsolutions.com', '2019-09-23 16:58:29.153369', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'testq@ASF.COM', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear tesetSDFW,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>testRWE<br><br>\n<b>Password</b><br>z6JAXvDZZN<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(13, '2019-09-23 16:59:12.564196', 'red@tirsolutions.com', '2019-09-23 16:59:12.564253', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'SDF@SDF.COM', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear SDF,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>SDF<br><br>\n<b>Password</b><br>trUuL6A6fU<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(14, '2019-09-23 16:59:59.241850', 'red@tirsolutions.com', '2019-09-23 16:59:59.241941', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'SDF@SDF.COMSDF', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear SDFSDFS,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>SDFDF<br><br>\n<b>Password</b><br>ULrFz6RC7C<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(15, '2019-09-23 17:06:51.268853', 'red@tirsolutions.com', '2019-09-23 17:06:51.268934', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'SDF@SDF.COMSDFS', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear SDFSDFSasA,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>SDFDFAS<br><br>\n<b>Password</b><br>BhFGE4eL6u<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(16, '2019-09-23 17:08:12.654829', 'red@tirsolutions.com', '2019-09-23 17:08:12.654889', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'SDFA@SDF.VOM', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear SDF,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>SDFA<br><br>\n<b>Password</b><br>duMysMUCaB<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(17, '2019-09-23 17:08:46.741987', 'red@tirsolutions.com', '2019-09-23 17:08:46.742045', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'SDFA@SDF.VOM2', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear SDF2,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>SDFA2<br><br>\n<b>Password</b><br>mhsqRKe689<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(18, '2019-09-23 17:14:56.627748', 'red@tirsolutions.com', '2019-09-23 17:14:56.627813', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'qqqq@asdf.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear qqqq,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>qqqq<br><br>\n<b>Password</b><br>UHyaKLys75<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(19, '2019-09-23 17:18:31.068460', 'red@tirsolutions.com', '2019-09-23 17:18:31.068516', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'test@sdf.cs', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear testtt,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>test<br><br>\n<b>Password</b><br>vQ4xdq793s<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(20, '2019-09-23 17:21:50.263029', 'red@tirsolutions.com', '2019-09-23 17:21:50.263086', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'test@sdf.cs', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear testtt11,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>test1<br><br>\n<b>Password</b><br>Py2E7xp2rV<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(21, '2019-09-23 17:24:18.357748', 'red@tirsolutions.com', '2019-09-23 17:24:18.357806', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'qweqweqw@sdf.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear weqwe,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>qweqweq<br><br>\n<b>Password</b><br>gLXnLQ35pp<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(22, '2019-09-23 17:26:10.849027', 'red@tirsolutions.com', '2019-09-23 17:26:10.849089', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'asdf@sadf.om', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear sdf,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>sdfgfd<br><br>\n<b>Password</b><br>PuC3JWJ6Y9<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(23, '2019-09-23 17:31:42.700711', 'red@tirsolutions.com', '2019-09-23 17:31:42.700765', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'test@asdf.cs', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear teest,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>test<br><br>\n<b>Password</b><br>eq6VmuLdWu<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(24, '2019-09-24 10:31:44.860004', 'red@tirsolutions.com', '2019-09-24 10:31:44.860060', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'new@new.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear new,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>new<br><br>\n<b>Password</b><br>XR3YpfdVJe<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(25, '2019-09-24 10:36:26.530524', 'red@tirsolutions.com', '2019-09-24 10:36:26.530579', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'asd@asd.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear asd,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>asd<br><br>\n<b>Password</b><br>GCaq92MTve<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(26, '2019-09-24 11:39:31.134004', 'red@tirsolutions.com', '2019-09-24 11:39:31.134063', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'jay@mail.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear jay,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>jay<br><br>\n<b>Password</b><br>VdjuXBMJVK<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(27, '2019-09-24 14:23:04.155480', 'red@tirsolutions.com', '2019-09-24 14:23:04.155540', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'teset@mail.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear testews,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>testt<br><br>\n<b>Password</b><br>vqCjwuxDjW<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(28, '2019-09-24 15:09:42.594243', 'red@tirsolutions.com', '2019-09-24 15:09:42.594300', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'dfsdf@asdf.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear sdfsdfsdfs,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>sdsffdfs<br><br>\n<b>Password</b><br>9bQ3DY38g9<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(29, '2019-09-24 15:18:17.377968', 'red@tirsolutions.com', '2019-09-24 15:18:17.378041', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'testME@mail.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear testME,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>testME<br><br>\n<b>Password</b><br>3q74Pqz9hQ<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(30, '2019-09-24 15:21:18.311884', 'red@tirsolutions.com', '2019-09-24 15:21:18.311960', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'test@mail.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear testMe,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>testME<br><br>\n<b>Password</b><br>yGXQyHp6sB<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(31, '2019-09-24 15:27:07.166655', 'red@tirsolutions.com', '2019-09-24 15:27:07.166710', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'jeff@mai.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear jeff,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>jeff<br><br>\n<b>Password</b><br>Fq9zcBGkCE<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(32, '2019-09-24 15:30:45.730555', 'red@tirsolutions.com', '2019-09-24 15:30:45.730612', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'jeff@mail.coom', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear jeff,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>jeff<br><br>\n<b>Password</b><br>rwZtJNn6sg<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(33, '2019-09-24 15:32:15.762118', 'red@tirsolutions.com', '2019-09-24 15:32:15.762179', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'johnredsmedrano@gmail.comsd', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear coxlee,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>coxlee<br><br>\n<b>Password</b><br>5kvysX82DA<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(34, '2019-09-24 15:46:43.219435', 'red@tirsolutions.com', '2019-09-24 15:46:43.219488', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'trest@mail.cm', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear testst,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>test<br><br>\n<b>Password</b><br>9C6H2eMJwh<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(35, '2019-09-24 15:55:41.339805', 'red@tirsolutions.com', '2019-09-24 15:55:41.339869', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'wasd@d.casd', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear 2,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>w<br><br>\n<b>Password</b><br>UK29HSgqmZ<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(36, '2019-09-24 16:00:38.712708', 'red@tirsolutions.com', '2019-09-24 16:00:38.712764', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'xczx@cv.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear zxc,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>zxcz<br><br>\n<b>Password</b><br>LqyjmX3xfF<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(37, '2019-09-24 16:03:41.846559', 'red@tirsolutions.com', '2019-09-24 16:03:41.846614', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'test@test.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear test,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>test<br><br>\n<b>Password</b><br>BBaZCtWSRx<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(38, '2019-09-24 16:08:45.473045', 'red@tirsolutions.com', '2019-09-24 16:08:45.473110', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'test@he.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear testsdfs,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>testdf<br><br>\n<b>Password</b><br>xM6QnBTGp5<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(39, '2019-09-24 16:24:18.939635', 'red@tirsolutions.com', '2019-09-24 16:24:18.939692', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'hary@yahoo.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear hary,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>hary<br><br>\n<b>Password</b><br>b7JHfHKVzU<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(40, '2019-09-24 17:15:07.015279', 'red@tirsolutions.com', '2019-09-24 17:15:07.015334', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'red@tirsolutions.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear Wownman,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>Wownman<br><br>\n<b>Password</b><br>QAupHtYWPa<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(41, '2019-09-24 18:21:23.005068', 'red@tirsolutions.com', '2019-09-24 18:21:23.005127', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'testEdit@mail.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear testEdit,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>testEdit<br><br>\n<b>Password</b><br>YmbxHqkBaL<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(42, '2019-09-24 19:10:05.206388', 'red@tirsolutions.com', '2019-09-24 19:10:05.206444', 'red@tirsolutions.com', 'RMS-NEWUSER.html', 'red@tirsolutions.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear test2,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>test2<br><br>\n<b>Password</b><br>QxnR5Xtwc2<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1);
/*!40000 ALTER TABLE `email_logs` ENABLE KEYS */;

-- Dumping structure for table rms_db.entity_logs
CREATE TABLE IF NOT EXISTS `entity_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `action` varchar(50) NOT NULL,
  `entity` varchar(50) NOT NULL,
  `row_id` int(11) NOT NULL,
  `fromValue` longtext,
  `toValue` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=211 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.entity_logs: ~210 rows (approximately)
DELETE FROM `entity_logs`;
/*!40000 ALTER TABLE `entity_logs` DISABLE KEYS */;
INSERT INTO `entity_logs` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `action`, `entity`, `row_id`, `fromValue`, `toValue`) VALUES
	(1, '2019-09-23 12:48:05.931814', 'superuser', '2019-09-23 12:48:05.931814', 'superuser', 'DELETED', 'COMPANY', 1, '{\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry\', \'contact_details\': \'2152509\'}', '{\'id\': 1, \'created\': \'2019-09-23T12:45:31.058709\', \'createdby\': \'superuser\', \'modified\': \'2019-09-23T12:48:05.929814\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'TIR2\', \'contact_details\': \'2152509\'}'),
	(2, '2019-09-23 12:48:11.310096', 'superuser', '2019-09-23 12:48:11.310096', 'superuser', 'DELETED', 'COMPANY', 1, '{\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'TIR2\', \'contact_details\': \'2152509\'}', '{\'id\': 1, \'created\': \'2019-09-23T12:45:31.058709\', \'createdby\': \'superuser\', \'modified\': \'2019-09-23T12:48:11.274128\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry\', \'contact_details\': \'2152509\'}'),
	(3, '2019-09-23 12:49:56.778639', 'superuser', '2019-09-23 12:49:56.778639', 'superuser', 'DELETED', 'COMPANY', 1, '{\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry\', \'contact_details\': \'2152509\'}', '{\'id\': 1, \'created\': \'2019-09-23T12:45:31.058709\', \'createdby\': \'superuser\', \'modified\': \'2019-09-23T12:49:56.777634\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry\', \'contact_details\': \'2152509\'}'),
	(4, '2019-09-23 12:50:02.263275', 'superuser', '2019-09-23 12:50:02.263275', 'superuser', 'DELETED', 'COMPANY', 1, '{\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry\', \'contact_details\': \'2152509\'}', '{\'id\': 1, \'created\': \'2019-09-23T12:45:31.058709\', \'createdby\': \'superuser\', \'modified\': \'2019-09-23T12:50:02.227274\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry2\', \'contact_details\': \'2152509\'}'),
	(5, '2019-09-23 12:50:55.877339', 'superuser', '2019-09-23 12:50:55.877339', 'superuser', 'DELETED', 'COMPANY', 1, '{\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry2\', \'contact_details\': \'2152509\'}', '{\'id\': 1, \'created\': \'2019-09-23T12:45:31.058709\', \'createdby\': \'superuser\', \'modified\': \'2019-09-23T12:50:55.875341\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry\', \'contact_details\': \'2152509\'}'),
	(6, '2019-09-23 13:05:43.563853', 'superuser', '2019-09-23 13:05:43.563853', 'superuser', 'DELETED', 'COMPANY', 1, '{\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry\', \'contact_details\': \'2152509\'}', '{\'id\': 1, \'created\': \'2019-09-23T12:45:31.058709\', \'createdby\': \'superuser\', \'modified\': \'2019-09-23T13:05:43.518888\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies\', \'contact_details\': \'2152509\'}'),
	(7, '2019-09-23 13:09:22.477286', 'superuser', '2019-09-23 13:09:22.477286', 'superuser', 'DELETED', 'COMPANY', 1, '{\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies\', \'contact_details\': \'2152509\'}', '{\'id\': 1, \'created\': \'2019-09-23T12:45:31.058709\', \'createdby\': \'superuser\', \'modified\': \'2019-09-23T13:09:22.475282\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd\', \'contact_details\': \'2152509\'}'),
	(8, '2019-09-23 13:09:24.850090', 'superuser', '2019-09-23 13:09:24.850090', 'superuser', 'DELETED', 'COMPANY', 1, '{\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd\', \'contact_details\': \'2152509\'}', '{\'id\': 1, \'created\': \'2019-09-23T12:45:31.058709\', \'createdby\': \'superuser\', \'modified\': \'2019-09-23T13:09:24.847086\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd\', \'contact_details\': \'2152509\'}'),
	(9, '2019-09-23 13:15:45.071569', 'superuser', '2019-09-23 13:15:45.071605', 'superuser', 'DELETED', 'COMPANY', 1, '{\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd\', \'contact_details\': \'2152509\'}', '{\'id\': 1, \'created\': \'2019-09-23T12:45:31.058709\', \'createdby\': \'superuser\', \'modified\': \'2019-09-23T13:15:45.068355\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}'),
	(10, '2019-09-23 15:10:51.623935', 'superuser', '2019-09-23 15:10:51.623987', 'superuser', 'DELETED', 'USER', 2, '{\'id\': 2, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 15, 5, 1, 454792), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'code\': \'USER-20190923-0000002\', \'name\': \'test\', \'username\': \'test\', \'password\': \'pbkdf2_sha256$150000$z057AgrJd6Dz$SgQVEjk1GrFaT4sCZXFtmcoN3q0v7/ONUQm+y2hyobk=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'test@mail.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Change Request Management System>]}', ''),
	(11, '2019-09-23 15:12:06.586604', 'superuser', '2019-09-23 15:12:06.586654', 'superuser', 'DELETED', 'USER', 3, '{\'id\': 3, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 15, 11, 15, 641547), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'code\': \'USER-20190923-0000003\', \'name\': \'test\', \'username\': \'test\', \'password\': \'pbkdf2_sha256$150000$2SMJgpQ4YiB6$hpSJMse3ngMOPOaaFZ+e8f+gkVxAPcLBLkzeoQd0UPI=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'test@mail.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Change Request Management System>]}', ''),
	(12, '2019-09-23 15:12:54.914735', 'superuser', '2019-09-23 15:12:54.914785', 'superuser', 'DELETED', 'USER', 4, '{\'id\': 4, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 15, 12, 33, 578673), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'code\': \'USER-20190923-0000004\', \'name\': \'test\', \'username\': \'test\', \'password\': \'pbkdf2_sha256$150000$4Ck5OflLBUuy$mppNvyH7jOZ6h05yRKT2TqiHmzqr5VgsTu2Svj90BQk=\', \'doa\': None, \'contact_no\': \'132\', \'email\': \'test@mail.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Change Request Management System>]}', ''),
	(13, '2019-09-23 15:14:08.458030', 'superuser', '2019-09-23 15:14:08.458079', 'superuser', 'DELETED', 'USER', 5, '{\'id\': 5, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 15, 13, 21, 401634), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000005\', \'name\': \'test\', \'username\': \'test\', \'password\': \'pbkdf2_sha256$150000$oZIwTtIDXNa0$6p5/TFknXP23DECJMGj6HvE/X2+oLncL3MdwuE6H1q4=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'test@test.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(14, '2019-09-23 15:21:13.695716', 'superuser', '2019-09-23 15:21:13.695764', 'superuser', 'DELETED', 'USER', 6, '{\'id\': 6, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 15, 14, 43, 77542), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000006\', \'name\': \'test\', \'username\': \'test\', \'password\': \'pbkdf2_sha256$150000$EW2EIPV0Fuo5$EADUUoNj2X7Tn7TCbx6oHqrJTVuIEB6gz7xfOhXun/o=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'tesrt@test.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(15, '2019-09-23 15:54:36.556122', 'superuser', '2019-09-23 15:54:36.556171', 'superuser', 'DELETED', 'USER', 8, '{\'id\': 8, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 15, 51, 47, 458185), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000008\', \'name\': \'test\', \'username\': \'Test\', \'password\': \'pbkdf2_sha256$150000$GepNh7zbymGQ$h+/dpjxOxOfvQUOAvivFh7U/vbpZlAk1qG+EFtylDf0=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'test22@mailc.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(16, '2019-09-23 15:54:40.072773', 'superuser', '2019-09-23 15:54:40.072822', 'superuser', 'DELETED', 'USER', 7, '{\'id\': 7, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 15, 24, 0, 159173), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000007\', \'name\': \'sadf\', \'username\': \'asdf\', \'password\': \'pbkdf2_sha256$150000$lt8dSuAs79lJ$hmMk+LyoFQzdBFtv4e36KEdN/a+UChOU/cTgqs5g9Ws=\', \'doa\': None, \'contact_no\': \'132\', \'email\': \'asdf@asdf.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(17, '2019-09-23 16:52:39.629550', 'superuser', '2019-09-23 16:52:39.629599', 'superuser', 'Update', 'USER', 9, '{\'id\': 9, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 15, 55, 13, 512369), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000009\', \'name\': \'test\', \'username\': \'test\', \'password\': \'pbkdf2_sha256$150000$2TF6IEeZC2FJ$sYfzKL2W+9b25R0Is2zxJWgxkT3paN1uAf3xE4ZSz1g=\', \'doa\': None, \'contact_no\': \'132\', \'email\': \'test@mail.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 9, \'code\': \'USER-20190923-0000009\', \'name\': \'test\', \'username\': \'test\', \'contact_no\': \'132\', \'email\': \'test@mail.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(18, '2019-09-23 17:07:35.327277', 'superuser', '2019-09-23 17:07:35.327328', 'superuser', 'DELETED', 'USER', 9, '{\'id\': 9, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 15, 55, 13, 512369), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000009\', \'name\': \'test\', \'username\': \'test\', \'password\': \'pbkdf2_sha256$150000$2TF6IEeZC2FJ$sYfzKL2W+9b25R0Is2zxJWgxkT3paN1uAf3xE4ZSz1g=\', \'doa\': None, \'contact_no\': \'132\', \'email\': \'test@mail.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(19, '2019-09-23 17:07:38.823190', 'superuser', '2019-09-23 17:07:38.823242', 'superuser', 'DELETED', 'USER', 10, '{\'id\': 10, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 16, 6, 31, 459234), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000010\', \'name\': \'qwe\', \'username\': \'qwe\', \'password\': \'pbkdf2_sha256$150000$SaaV0bSTBQmX$uimdUKd1jdSm2D1rjUlG3fbX1onTh6/T+RPeB3y73WI=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'qwe@qwe.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(20, '2019-09-23 17:07:41.884566', 'superuser', '2019-09-23 17:07:41.884619', 'superuser', 'DELETED', 'USER', 11, '{\'id\': 11, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 16, 24, 20, 474799), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000011\', \'name\': \'qwe1\', \'username\': \'qwe1\', \'password\': \'pbkdf2_sha256$150000$VtlIMyOqFxeq$VeTYPJrOLEcamLOjQA/47SMhu1w6tjJWobNTsXAfOsY=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'qwe1@qwe.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(21, '2019-09-23 17:07:45.161621', 'superuser', '2019-09-23 17:07:45.161673', 'superuser', 'DELETED', 'USER', 12, '{\'id\': 12, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 16, 30, 45, 215579), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000012\', \'name\': \'est\', \'username\': \'tesst\', \'password\': \'pbkdf2_sha256$150000$olAIUw4gWrR2$pQiuh5ldMZ1wjKsTsWml2E88V0ai5iIy2KItC/4sdb4=\', \'doa\': None, \'contact_no\': \'132\', \'email\': \'teestt@sdf.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(22, '2019-09-23 17:07:47.642224', 'superuser', '2019-09-23 17:07:47.642273', 'superuser', 'DELETED', 'USER', 13, '{\'id\': 13, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 16, 58, 26, 563432), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000013\', \'name\': \'tesetSDFW\', \'username\': \'testRWE\', \'password\': \'pbkdf2_sha256$150000$uRlaI3lgJSP2$gCa0S8bR3wmdKqqGNpnCz46NFFars/LlMZRelaBwlcQ=\', \'doa\': None, \'contact_no\': \'234\', \'email\': \'testq@ASF.COM\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(23, '2019-09-23 17:30:56.755467', 'superuser', '2019-09-23 17:30:56.755520', 'superuser', 'DELETED', 'USER', 14, '{\'id\': 14, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 16, 59, 10, 66804), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000014\', \'name\': \'SDF\', \'username\': \'SDF\', \'password\': \'pbkdf2_sha256$150000$XIb3tkiDa199$JsgI3b8YvgbhaMFfOfsG7pl1OJVyUXzkqPUifWRM1jE=\', \'doa\': None, \'contact_no\': \'234\', \'email\': \'SDF@SDF.COM\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(24, '2019-09-23 17:30:59.631977', 'superuser', '2019-09-23 17:30:59.632027', 'superuser', 'DELETED', 'USER', 15, '{\'id\': 15, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 16, 59, 56, 618864), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000015\', \'name\': \'SDFSDFS\', \'username\': \'SDFDF\', \'password\': \'pbkdf2_sha256$150000$lco8motR1ESF$rLa0L9h+8D7nGl2doK1UteJ5XjxnfuWxiZQqlEnBLT8=\', \'doa\': None, \'contact_no\': \'234\', \'email\': \'SDF@SDF.COMSDF\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(25, '2019-09-23 17:31:02.520507', 'superuser', '2019-09-23 17:31:02.520559', 'superuser', 'DELETED', 'USER', 16, '{\'id\': 16, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 6, 48, 639054), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000016\', \'name\': \'SDFSDFSasA\', \'username\': \'SDFDFAS\', \'password\': \'pbkdf2_sha256$150000$QwN3VSbj5NKA$ml7VXlQLHfwZ7sDYblIRFkCn9BME199XRkEqHcfO7d8=\', \'doa\': None, \'contact_no\': \'234\', \'email\': \'SDF@SDF.COMSDFS\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(26, '2019-09-23 17:31:05.311429', 'superuser', '2019-09-23 17:31:05.311530', 'superuser', 'DELETED', 'USER', 17, '{\'id\': 17, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 8, 10, 115940), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000017\', \'name\': \'SDF\', \'username\': \'SDFA\', \'password\': \'pbkdf2_sha256$150000$3regTsFl8WEK$OKoDNExROHp2GLEZzjAAwdsb7CyrBXeZ1mBgnmtA0k0=\', \'doa\': None, \'contact_no\': \'234\', \'email\': \'SDFA@SDF.VOM\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(27, '2019-09-23 17:31:08.235750', 'superuser', '2019-09-23 17:31:08.235799', 'superuser', 'DELETED', 'USER', 18, '{\'id\': 18, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 8, 44, 157526), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000018\', \'name\': \'SDF2\', \'username\': \'SDFA2\', \'password\': \'pbkdf2_sha256$150000$9ljByMzGFcQv$mIgQj5jcxDfGe3/iORskRm3sTKeaTU/sEOesZPS85qk=\', \'doa\': None, \'contact_no\': \'234\', \'email\': \'SDFA@SDF.VOM2\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(28, '2019-09-23 17:31:11.111890', 'superuser', '2019-09-23 17:31:11.111965', 'superuser', 'DELETED', 'USER', 19, '{\'id\': 19, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 14, 54, 109204), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000019\', \'name\': \'qqqq\', \'username\': \'qqqq\', \'password\': \'pbkdf2_sha256$150000$u3ZlFj0hVvdV$jbKpDEkkZ9V+Y3DkXcseSItrlotLZngf7GXr8C8H1i0=\', \'doa\': None, \'contact_no\': \'132\', \'email\': \'qqqq@asdf.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(29, '2019-09-23 17:31:14.709033', 'superuser', '2019-09-23 17:31:14.709087', 'superuser', 'DELETED', 'USER', 20, '{\'id\': 20, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 18, 28, 496156), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000020\', \'name\': \'testtt\', \'username\': \'test\', \'password\': \'pbkdf2_sha256$150000$6l6DBTrqzA2W$2rv9ZvStVfu30EaxVnhcxqcsSbos3iMOG8nBkuoFA+c=\', \'doa\': None, \'contact_no\': \'234\', \'email\': \'test@sdf.cs\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(30, '2019-09-23 17:31:17.783426', 'superuser', '2019-09-23 17:31:17.783478', 'superuser', 'DELETED', 'USER', 21, '{\'id\': 21, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 21, 47, 702392), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000021\', \'name\': \'testtt11\', \'username\': \'test1\', \'password\': \'pbkdf2_sha256$150000$GpbUxiQ0dbi5$mNHQbs8CJGMm3irtMfINjfeJtIVl7/fdkmjOop4yvZM=\', \'doa\': None, \'contact_no\': \'234\', \'email\': \'test@sdf.cs\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(31, '2019-09-23 17:31:20.505945', 'superuser', '2019-09-23 17:31:20.506003', 'superuser', 'DELETED', 'USER', 22, '{\'id\': 22, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 24, 15, 864638), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000022\', \'name\': \'weqwe\', \'username\': \'qweqweq\', \'password\': \'pbkdf2_sha256$150000$o4NMHtwMI7xT$P8Al/fI9+nxk50Vjx315IVcV+C5NUPfvawi+I3jpdkY=\', \'doa\': None, \'contact_no\': \'132\', \'email\': \'qweqweqw@sdf.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(32, '2019-09-23 17:34:33.525826', 'superuser', '2019-09-23 17:34:33.525874', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(33, '2019-09-23 17:35:22.545547', 'superuser', '2019-09-23 17:35:22.545597', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(34, '2019-09-23 17:35:44.860384', 'superuser', '2019-09-23 17:35:44.860432', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(35, '2019-09-23 17:35:57.085463', 'superuser', '2019-09-23 17:35:57.085505', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(36, '2019-09-23 17:36:16.202173', 'superuser', '2019-09-23 17:36:16.202224', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(37, '2019-09-23 17:36:46.645261', 'superuser', '2019-09-23 17:36:46.645300', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(38, '2019-09-23 17:37:28.474595', 'superuser', '2019-09-23 17:37:28.474642', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(39, '2019-09-23 17:37:56.914360', 'superuser', '2019-09-23 17:37:56.914409', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(40, '2019-09-23 17:38:31.420762', 'superuser', '2019-09-23 17:38:31.420813', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(41, '2019-09-23 17:38:39.076525', 'superuser', '2019-09-23 17:38:39.076564', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(42, '2019-09-23 17:38:50.542551', 'superuser', '2019-09-23 17:38:50.542593', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(43, '2019-09-23 17:41:12.644154', 'superuser', '2019-09-23 17:41:12.644203', 'superuser', 'Update', 'USER', 24, '{\'id\': 24, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 31, 40, 123239), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000024\', \'name\': \'teest\', \'username\': \'test\', \'password\': \'pbkdf2_sha256$150000$2SfIWmpxkPF7$LThiY4H3K7ge8vhEv53xvy+oy19hu9EHNQ1Y2vgawvk=\', \'doa\': None, \'contact_no\': \'234\', \'email\': \'test@asdf.cs\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 24, \'code\': \'USER-20190923-0000024\', \'name\': \'teest\', \'username\': \'test\', \'contact_no\': \'234\', \'email\': \'test@asdf.cs\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(44, '2019-09-23 17:45:05.823455', 'superuser', '2019-09-23 17:45:05.823505', 'superuser', 'Update', 'USER', 24, '{\'id\': 24, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 31, 40, 123239), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000024\', \'name\': \'teest\', \'username\': \'test\', \'password\': \'pbkdf2_sha256$150000$2SfIWmpxkPF7$LThiY4H3K7ge8vhEv53xvy+oy19hu9EHNQ1Y2vgawvk=\', \'doa\': None, \'contact_no\': \'234\', \'email\': \'test@asdf.cs\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 24, \'code\': \'USER-20190923-0000024\', \'name\': \'teest\', \'username\': \'test\', \'contact_no\': \'234\', \'email\': \'test@asdf.cs\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(45, '2019-09-23 17:49:32.664370', 'superuser', '2019-09-23 17:49:32.664430', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(46, '2019-09-23 17:50:48.725566', 'superuser', '2019-09-23 17:50:48.725615', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(47, '2019-09-23 17:54:35.185954', 'superuser', '2019-09-23 17:54:35.185999', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(48, '2019-09-23 17:55:21.169593', 'superuser', '2019-09-23 17:55:21.169643', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(49, '2019-09-23 17:57:38.826595', 'superuser', '2019-09-23 17:57:38.826643', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(50, '2019-09-23 17:58:41.030031', 'superuser', '2019-09-23 17:58:41.030081', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(51, '2019-09-23 18:03:06.129708', 'superuser', '2019-09-23 18:03:06.129755', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(52, '2019-09-23 18:03:26.272527', 'superuser', '2019-09-23 18:03:26.272570', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(53, '2019-09-23 18:08:21.687255', 'superuser', '2019-09-23 18:08:21.687303', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(54, '2019-09-23 18:11:26.433924', 'superuser', '2019-09-23 18:11:26.433971', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(55, '2019-09-23 18:18:48.112489', 'superuser', '2019-09-23 18:18:48.112533', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(56, '2019-09-23 18:19:37.946597', 'superuser', '2019-09-23 18:19:37.946646', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(57, '2019-09-23 18:22:13.834417', 'superuser', '2019-09-23 18:22:13.834466', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(58, '2019-09-23 18:25:40.690825', 'superuser', '2019-09-23 18:25:40.690875', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(59, '2019-09-23 18:26:14.127022', 'superuser', '2019-09-23 18:26:14.127076', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(60, '2019-09-23 18:27:16.625582', 'superuser', '2019-09-23 18:27:16.625636', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(61, '2019-09-23 18:31:15.190250', 'superuser', '2019-09-23 18:31:15.190298', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(62, '2019-09-23 18:32:49.738653', 'superuser', '2019-09-23 18:32:49.738698', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(63, '2019-09-23 18:37:14.925448', 'superuser', '2019-09-23 18:37:14.925500', 'superuser', 'Update', 'USER', 24, '{\'id\': 24, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 31, 40, 123239), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000024\', \'name\': \'teest\', \'username\': \'test\', \'password\': \'pbkdf2_sha256$150000$2SfIWmpxkPF7$LThiY4H3K7ge8vhEv53xvy+oy19hu9EHNQ1Y2vgawvk=\', \'doa\': None, \'contact_no\': \'234\', \'email\': \'test@asdf.cs\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 24, \'code\': \'USER-20190923-0000024\', \'name\': \'teest\', \'username\': \'test\', \'contact_no\': \'234\', \'email\': \'test@asdf.cs\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(64, '2019-09-23 18:38:26.701757', 'superuser', '2019-09-23 18:38:26.701806', 'superuser', 'Update', 'USER', 24, '{\'id\': 24, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 31, 40, 123239), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000024\', \'name\': \'teest\', \'username\': \'test\', \'password\': \'pbkdf2_sha256$150000$2SfIWmpxkPF7$LThiY4H3K7ge8vhEv53xvy+oy19hu9EHNQ1Y2vgawvk=\', \'doa\': None, \'contact_no\': \'234\', \'email\': \'test@asdf.cs\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 24, \'code\': \'USER-20190923-0000024\', \'name\': \'teest\', \'username\': \'test\', \'contact_no\': \'234\', \'email\': \'test@asdf.cs\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(65, '2019-09-23 18:39:35.323581', 'superuser', '2019-09-23 18:39:35.323628', 'superuser', 'Update', 'USER', 24, '{\'id\': 24, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 31, 40, 123239), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000024\', \'name\': \'teest\', \'username\': \'test\', \'password\': \'pbkdf2_sha256$150000$2SfIWmpxkPF7$LThiY4H3K7ge8vhEv53xvy+oy19hu9EHNQ1Y2vgawvk=\', \'doa\': None, \'contact_no\': \'234\', \'email\': \'test@asdf.cs\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 24, \'code\': \'USER-20190923-0000024\', \'name\': \'teest\', \'username\': \'test\', \'contact_no\': \'234\', \'email\': \'test@asdf.cs\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(66, '2019-09-23 18:40:37.021987', 'superuser', '2019-09-23 18:40:37.022040', 'superuser', 'Update', 'USER', 24, '{\'id\': 24, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 31, 40, 123239), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000024\', \'name\': \'teest\', \'username\': \'test\', \'password\': \'pbkdf2_sha256$150000$2SfIWmpxkPF7$LThiY4H3K7ge8vhEv53xvy+oy19hu9EHNQ1Y2vgawvk=\', \'doa\': None, \'contact_no\': \'234\', \'email\': \'test@asdf.cs\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 24, \'code\': \'USER-20190923-0000024\', \'name\': \'teest\', \'username\': \'test\', \'contact_no\': \'234\', \'email\': \'test@asdf.cs\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(67, '2019-09-23 18:43:49.257130', 'superuser', '2019-09-23 18:43:49.257175', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(68, '2019-09-23 18:44:17.451932', 'superuser', '2019-09-23 18:44:17.451984', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(69, '2019-09-23 18:47:25.406345', 'superuser', '2019-09-23 18:47:25.406394', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(70, '2019-09-24 10:09:25.768142', 'superuser', '2019-09-24 10:09:25.768186', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(71, '2019-09-24 10:11:18.387429', 'superuser', '2019-09-24 10:11:18.387475', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(72, '2019-09-24 10:17:15.185643', 'superuser', '2019-09-24 10:17:15.185680', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(73, '2019-09-24 10:17:41.973420', 'superuser', '2019-09-24 10:17:41.973457', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(74, '2019-09-24 10:19:23.009364', 'superuser', '2019-09-24 10:19:23.009413', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(75, '2019-09-24 10:21:02.533773', 'superuser', '2019-09-24 10:21:02.533819', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(76, '2019-09-24 10:25:35.815165', 'superuser', '2019-09-24 10:25:35.815210', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(77, '2019-09-24 10:30:12.282137', 'superuser', '2019-09-24 10:30:12.282188', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(78, '2019-09-24 10:37:57.249680', 'superuser', '2019-09-24 10:37:57.249723', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(79, '2019-09-24 10:39:45.938277', 'superuser', '2019-09-24 10:39:45.938323', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(80, '2019-09-24 10:41:44.393587', 'superuser', '2019-09-24 10:41:44.393626', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(81, '2019-09-24 10:45:18.607380', 'superuser', '2019-09-24 10:45:18.607431', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(82, '2019-09-24 10:46:11.695159', 'superuser', '2019-09-24 10:46:11.695204', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(83, '2019-09-24 10:46:32.525642', 'superuser', '2019-09-24 10:46:32.525697', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(84, '2019-09-24 10:48:03.517015', 'superuser', '2019-09-24 10:48:03.517059', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(85, '2019-09-24 10:53:44.555248', 'superuser', '2019-09-24 10:53:44.555298', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(86, '2019-09-24 10:55:28.469574', 'superuser', '2019-09-24 10:55:28.469623', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(87, '2019-09-24 10:56:16.071271', 'superuser', '2019-09-24 10:56:16.071316', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(88, '2019-09-24 10:56:53.061137', 'superuser', '2019-09-24 10:56:53.061182', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(89, '2019-09-24 10:59:04.041111', 'superuser', '2019-09-24 10:59:04.041156', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(90, '2019-09-24 11:02:04.358939', 'superuser', '2019-09-24 11:02:04.358990', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(91, '2019-09-24 11:05:49.554551', 'superuser', '2019-09-24 11:05:49.554596', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(92, '2019-09-24 11:08:48.654465', 'superuser', '2019-09-24 11:08:48.654507', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(93, '2019-09-24 11:17:36.402416', 'superuser', '2019-09-24 11:17:36.402465', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(94, '2019-09-24 11:19:07.453207', 'superuser', '2019-09-24 11:19:07.453253', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(95, '2019-09-24 11:19:43.439139', 'superuser', '2019-09-24 11:19:43.439177', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(96, '2019-09-24 11:21:09.486461', 'superuser', '2019-09-24 11:21:09.486505', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(97, '2019-09-24 11:25:57.296606', 'superuser', '2019-09-24 11:25:57.296653', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(98, '2019-09-24 11:26:44.936769', 'superuser', '2019-09-24 11:26:44.936810', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(99, '2019-09-24 11:27:08.489467', 'superuser', '2019-09-24 11:27:08.489509', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(100, '2019-09-24 11:31:30.846600', 'superuser', '2019-09-24 11:31:30.846643', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(101, '2019-09-24 11:32:38.952194', 'superuser', '2019-09-24 11:32:38.952236', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(102, '2019-09-24 11:37:10.506516', 'superuser', '2019-09-24 11:37:10.506568', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(103, '2019-09-24 11:37:36.298192', 'superuser', '2019-09-24 11:37:36.298237', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(104, '2019-09-24 11:39:48.955276', 'superuser', '2019-09-24 11:39:48.955318', 'superuser', 'Update', 'USER', 27, '{\'id\': 27, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 11, 39, 28, 541055), \'department\': \'DEPARTMENT-20190923-0000002\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000027\', \'name\': \'jay\', \'username\': \'jay\', \'password\': \'pbkdf2_sha256$150000$ZlZ4Q6MP4Ecz$4a4adlNDJ9ZKT2BtretYOCzVtjUGoMx9xZTTG7L/pPI=\', \'doa\': None, \'contact_no\': \'132\', \'email\': \'jay@mail.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 27, \'code\': \'USER-20190924-0000027\', \'name\': \'jay\', \'username\': \'jay\', \'contact_no\': \'132\', \'email\': \'jay@mail.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 2, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000002\', \'name\': \'Business Develsopment\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(105, '2019-09-24 11:58:33.815939', 'superuser', '2019-09-24 11:58:33.815990', 'superuser', 'Update', 'USER', 27, '{\'id\': 27, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 11, 39, 28, 541055), \'department\': \'DEPARTMENT-20190923-0000002\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000027\', \'name\': \'jay\', \'username\': \'jay\', \'password\': \'pbkdf2_sha256$150000$ZlZ4Q6MP4Ecz$4a4adlNDJ9ZKT2BtretYOCzVtjUGoMx9xZTTG7L/pPI=\', \'doa\': None, \'contact_no\': \'132\', \'email\': \'jay@mail.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 27, \'code\': \'USER-20190924-0000027\', \'name\': \'jay\', \'username\': \'jay\', \'contact_no\': \'132\', \'email\': \'jay@mail.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 2, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000002\', \'name\': \'Business Develsopment\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(106, '2019-09-24 13:06:41.191229', 'superuser', '2019-09-24 13:06:41.191277', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(107, '2019-09-24 13:10:25.793881', 'superuser', '2019-09-24 13:10:25.793956', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(108, '2019-09-24 13:24:52.475587', 'superuser', '2019-09-24 13:24:52.475631', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(109, '2019-09-24 13:27:36.402468', 'superuser', '2019-09-24 13:27:36.402518', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(110, '2019-09-24 13:32:06.393486', 'superuser', '2019-09-24 13:32:06.393533', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(111, '2019-09-24 13:32:43.594664', 'superuser', '2019-09-24 13:32:43.594712', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(112, '2019-09-24 13:33:50.461978', 'superuser', '2019-09-24 13:33:50.462027', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(113, '2019-09-24 13:34:52.703159', 'superuser', '2019-09-24 13:34:52.703202', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(114, '2019-09-24 13:35:37.243166', 'superuser', '2019-09-24 13:35:37.243216', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(115, '2019-09-24 13:35:42.108334', 'superuser', '2019-09-24 13:35:42.108380', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(116, '2019-09-24 13:36:05.478344', 'superuser', '2019-09-24 13:36:05.478390', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(117, '2019-09-24 13:39:07.219467', 'superuser', '2019-09-24 13:39:07.219517', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(118, '2019-09-24 13:40:55.016829', 'superuser', '2019-09-24 13:40:55.016877', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(119, '2019-09-24 13:43:53.866277', 'superuser', '2019-09-24 13:43:53.866324', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(120, '2019-09-24 13:53:18.734304', 'superuser', '2019-09-24 13:53:18.734350', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(121, '2019-09-24 14:01:46.101960', 'superuser', '2019-09-24 14:01:46.102015', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(122, '2019-09-24 14:07:55.892314', 'superuser', '2019-09-24 14:07:55.892360', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(123, '2019-09-24 14:08:27.514978', 'superuser', '2019-09-24 14:08:27.515027', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(124, '2019-09-24 14:09:18.937818', 'superuser', '2019-09-24 14:09:18.937868', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(125, '2019-09-24 14:11:44.684136', 'superuser', '2019-09-24 14:11:44.684184', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(126, '2019-09-24 14:16:03.611198', 'superuser', '2019-09-24 14:16:03.611249', 'superuser', 'Update', 'USER', 27, '{\'id\': 27, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 11, 39, 28, 541055), \'department\': \'DEPARTMENT-20190923-0000002\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000027\', \'name\': \'jay\', \'username\': \'jay\', \'password\': \'pbkdf2_sha256$150000$ZlZ4Q6MP4Ecz$4a4adlNDJ9ZKT2BtretYOCzVtjUGoMx9xZTTG7L/pPI=\', \'doa\': None, \'contact_no\': \'132\', \'email\': \'jay@mail.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 27, \'code\': \'USER-20190924-0000027\', \'name\': \'jay\', \'username\': \'jay\', \'contact_no\': \'132\', \'email\': \'jay@mail.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 2, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000002\', \'name\': \'Business Develsopment\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(127, '2019-09-24 14:23:38.103466', 'superuser', '2019-09-24 14:23:38.103517', 'superuser', 'Update', 'USER', 28, '{\'id\': 28, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 14, 23, 1, 470734), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000028\', \'name\': \'testews\', \'username\': \'testt\', \'password\': \'pbkdf2_sha256$150000$rSumw4s6cLYr$tKLrNbX6+rB+OC7etI7O6uWOi4kwT0Dn4PPDSoieJ2A=\', \'doa\': None, \'contact_no\': \'1234\', \'email\': \'teset@mail.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 28, \'code\': \'USER-20190924-0000028\', \'name\': \'testews\', \'username\': \'testt\', \'contact_no\': \'1234\', \'email\': \'teset@mail.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(128, '2019-09-24 14:24:55.567199', 'superuser', '2019-09-24 14:24:55.567254', 'superuser', 'Update', 'USER', 28, '{\'id\': 28, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 14, 23, 1, 470734), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000028\', \'name\': \'testews\', \'username\': \'testt\', \'password\': \'pbkdf2_sha256$150000$rSumw4s6cLYr$tKLrNbX6+rB+OC7etI7O6uWOi4kwT0Dn4PPDSoieJ2A=\', \'doa\': None, \'contact_no\': \'1234\', \'email\': \'teset@mail.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 28, \'code\': \'USER-20190924-0000028\', \'name\': \'testews\', \'username\': \'testt\', \'contact_no\': \'1234\', \'email\': \'teset@mail.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(129, '2019-09-24 14:25:22.663775', 'superuser', '2019-09-24 14:25:22.663822', 'superuser', 'Update', 'USER', 28, '{\'id\': 28, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 14, 23, 1, 470734), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000028\', \'name\': \'testews\', \'username\': \'testt\', \'password\': \'pbkdf2_sha256$150000$rSumw4s6cLYr$tKLrNbX6+rB+OC7etI7O6uWOi4kwT0Dn4PPDSoieJ2A=\', \'doa\': None, \'contact_no\': \'1234\', \'email\': \'teset@mail.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 28, \'code\': \'USER-20190924-0000028\', \'name\': \'testews\', \'username\': \'testt\', \'contact_no\': \'1234\', \'email\': \'teset@mail.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(130, '2019-09-24 14:26:09.473405', 'superuser', '2019-09-24 14:26:09.473453', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(131, '2019-09-24 14:28:12.285797', 'superuser', '2019-09-24 14:28:12.285847', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(132, '2019-09-24 14:31:14.939045', 'superuser', '2019-09-24 14:31:14.939092', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(133, '2019-09-24 14:39:01.323299', 'superuser', '2019-09-24 14:39:01.323348', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(134, '2019-09-24 14:39:44.418576', 'superuser', '2019-09-24 14:39:44.418621', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(135, '2019-09-24 14:41:24.683987', 'superuser', '2019-09-24 14:41:24.684030', 'superuser', 'Update', 'USER', 28, '{\'id\': 28, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 14, 23, 1, 470734), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000028\', \'name\': \'testews\', \'username\': \'testt\', \'password\': \'pbkdf2_sha256$150000$rSumw4s6cLYr$tKLrNbX6+rB+OC7etI7O6uWOi4kwT0Dn4PPDSoieJ2A=\', \'doa\': None, \'contact_no\': \'1234\', \'email\': \'teset@mail.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 28, \'code\': \'USER-20190924-0000028\', \'name\': \'testews\', \'username\': \'testt\', \'contact_no\': \'1234\', \'email\': \'teset@mail.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(136, '2019-09-24 14:42:35.769606', 'superuser', '2019-09-24 14:42:35.769653', 'superuser', 'Update', 'USER', 28, '{\'id\': 28, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 14, 23, 1, 470734), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000028\', \'name\': \'testews\', \'username\': \'testt\', \'password\': \'pbkdf2_sha256$150000$rSumw4s6cLYr$tKLrNbX6+rB+OC7etI7O6uWOi4kwT0Dn4PPDSoieJ2A=\', \'doa\': None, \'contact_no\': \'1234\', \'email\': \'teset@mail.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 28, \'code\': \'USER-20190924-0000028\', \'name\': \'testews\', \'username\': \'testt\', \'contact_no\': \'1234\', \'email\': \'teset@mail.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(137, '2019-09-24 14:47:54.669435', 'superuser', '2019-09-24 14:47:54.669482', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(138, '2019-09-24 14:49:44.648295', 'superuser', '2019-09-24 14:49:44.648338', 'superuser', 'Update', 'USER', 28, '{\'id\': 28, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 14, 23, 1, 470734), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000028\', \'name\': \'testews\', \'username\': \'testt\', \'password\': \'pbkdf2_sha256$150000$rSumw4s6cLYr$tKLrNbX6+rB+OC7etI7O6uWOi4kwT0Dn4PPDSoieJ2A=\', \'doa\': None, \'contact_no\': \'1234\', \'email\': \'teset@mail.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 28, \'code\': \'USER-20190924-0000028\', \'name\': \'testews\', \'username\': \'testt\', \'contact_no\': \'1234\', \'email\': \'teset@mail.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(139, '2019-09-24 14:50:45.173344', 'superuser', '2019-09-24 14:50:45.173392', 'superuser', 'Update', 'USER', 28, '{\'id\': 28, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 14, 23, 1, 470734), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000028\', \'name\': \'testews\', \'username\': \'testt\', \'password\': \'pbkdf2_sha256$150000$rSumw4s6cLYr$tKLrNbX6+rB+OC7etI7O6uWOi4kwT0Dn4PPDSoieJ2A=\', \'doa\': None, \'contact_no\': \'1234\', \'email\': \'teset@mail.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 28, \'code\': \'USER-20190924-0000028\', \'name\': \'testews\', \'username\': \'testt\', \'contact_no\': \'1234\', \'email\': \'teset@mail.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(140, '2019-09-24 14:52:18.152686', 'superuser', '2019-09-24 14:52:18.152736', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(141, '2019-09-24 14:53:16.813469', 'superuser', '2019-09-24 14:53:16.813511', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(142, '2019-09-24 14:57:43.111591', 'superuser', '2019-09-24 14:57:43.111639', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(143, '2019-09-24 15:06:18.520720', 'superuser', '2019-09-24 15:06:18.520768', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(144, '2019-09-24 15:06:42.498929', 'superuser', '2019-09-24 15:06:42.498976', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(145, '2019-09-24 15:08:35.927840', 'superuser', '2019-09-24 15:08:35.927890', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(146, '2019-09-24 15:13:54.194127', 'superuser', '2019-09-24 15:13:54.194177', 'superuser', 'DELETED', 'USER', 24, '{\'id\': 24, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 31, 40, 123239), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190923-0000024\', \'name\': \'teest\', \'username\': \'test\', \'password\': \'pbkdf2_sha256$150000$2SfIWmpxkPF7$LThiY4H3K7ge8vhEv53xvy+oy19hu9EHNQ1Y2vgawvk=\', \'doa\': None, \'contact_no\': \'234\', \'email\': \'test@asdf.cs\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(147, '2019-09-24 15:13:58.972047', 'superuser', '2019-09-24 15:13:58.972100', 'superuser', 'DELETED', 'USER', 25, '{\'id\': 25, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 10, 31, 42, 345284), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000025\', \'name\': \'new\', \'username\': \'new\', \'password\': \'pbkdf2_sha256$150000$NvEkLJInQ1UJ$3ZBBY5DNu571d9zSCObSfhT5wZUfM/NPM3+XIw88t8I=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'new@new.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(148, '2019-09-24 15:14:02.043677', 'superuser', '2019-09-24 15:14:02.043737', 'superuser', 'DELETED', 'USER', 26, '{\'id\': 26, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 10, 36, 23, 928603), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000026\', \'name\': \'asd\', \'username\': \'asd\', \'password\': \'pbkdf2_sha256$150000$NVU49C8DJE3Y$wdJrm1wPnZwCNQdlQS9zeXq6/zGnEBEVlkLBSjRzfl8=\', \'doa\': None, \'contact_no\': \'132\', \'email\': \'asd@asd.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(149, '2019-09-24 15:20:43.293189', 'superuser', '2019-09-24 15:20:43.293242', 'superuser', 'DELETED', 'USER', 30, '{\'id\': 30, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 15, 18, 14, 809301), \'department\': \'DEPARTMENT-20190923-0000002\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000030\', \'name\': \'testME\', \'username\': \'testME\', \'password\': \'pbkdf2_sha256$150000$qqLQNi6JUPi9$Lw2u9eUOyyNX8ERNCHpU0YwgKdNVF9+Psbmi7mn4qKw=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'testME@mail.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(150, '2019-09-24 15:30:15.866467', 'superuser', '2019-09-24 15:30:15.866519', 'superuser', 'DELETED', 'USER', 32, '{\'id\': 32, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 15, 27, 4, 622712), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000032\', \'name\': \'jeff\', \'username\': \'jeff\', \'password\': \'pbkdf2_sha256$150000$FESHihCbnp7E$w+PZt5Bgq0VayWTnsDidu6n2g5i7IPa+AVREfqq0BvY=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'jeff@mai.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(151, '2019-09-24 15:59:57.669422', 'superuser', '2019-09-24 15:59:57.669472', 'superuser', 'DELETED', 'USER', 36, '{\'id\': 36, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 15, 55, 38, 782847), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000036\', \'name\': \'2\', \'username\': \'w\', \'password\': \'pbkdf2_sha256$150000$6JV4Kr8F5RTA$5LO+EMEZ53Ssu1aYZbePAuoAmx5lOmyTmgR0id1ZnnU=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'wasd@d.casd\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(152, '2019-09-24 16:00:01.276699', 'superuser', '2019-09-24 16:00:01.276749', 'superuser', 'DELETED', 'USER', 35, '{\'id\': 35, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 15, 46, 40, 514860), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000035\', \'name\': \'testst\', \'username\': \'test\', \'password\': \'pbkdf2_sha256$150000$Wq5zNUwj5GZ6$vMPisLOxTerBqQcIPtqXq0fKLAE/Ketb+mhX64IIL4E=\', \'doa\': None, \'contact_no\': \'-1\', \'email\': \'trest@mail.cm\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(153, '2019-09-24 16:02:04.200996', 'superuser', '2019-09-24 16:02:04.201045', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(154, '2019-09-24 16:03:03.255325', 'superuser', '2019-09-24 16:03:03.255380', 'superuser', 'DELETED', 'USER', 37, '{\'id\': 37, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 16, 0, 36, 28596), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000037\', \'name\': \'zxc\', \'username\': \'zxcz\', \'password\': \'pbkdf2_sha256$150000$CXZZz56SH6H6$3liOoJtO3tvkIpjCcFBe7xWUs5QQ4Xx74JH+WqeYi90=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'xczx@cv.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(155, '2019-09-24 16:03:06.679121', 'superuser', '2019-09-24 16:03:06.679186', 'superuser', 'DELETED', 'USER', 34, '{\'id\': 34, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 15, 32, 13, 231268), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000034\', \'name\': \'coxlee\', \'username\': \'coxlee\', \'password\': \'pbkdf2_sha256$150000$u81C5Jz5bDk3$zlkOF1STFERc+uX9Xd1PUonzEeEF0vqIblgMe1TnxiI=\', \'doa\': None, \'contact_no\': \'3\', \'email\': \'johnredsmedrano@gmail.comsd\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(156, '2019-09-24 16:03:10.735508', 'superuser', '2019-09-24 16:03:10.735566', 'superuser', 'DELETED', 'USER', 33, '{\'id\': 33, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 15, 30, 43, 253190), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000033\', \'name\': \'jeff\', \'username\': \'jeff\', \'password\': \'pbkdf2_sha256$150000$7tBrA9y3byyO$x9JusZOWJ8jIdZHmLc+Tm/By36JDvN6SFCmV6WtQ/Cc=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'jeff@mail.coom\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', ''),
	(157, '2019-09-24 16:15:52.977465', 'superuser', '2019-09-24 16:15:52.977513', 'superuser', 'Update', 'USER', 39, '{\'id\': 39, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 16, 8, 42, 902318), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000039\', \'name\': \'testsdfs\', \'username\': \'testdf\', \'password\': \'pbkdf2_sha256$150000$iji7IowAr6hR$FSvb2wd55Xl01ZwD///HL4JsGpvgpWul+i7PptdSPt0=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'test@he.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 39, \'code\': \'USER-20190924-0000039\', \'name\': \'testsdfs\', \'username\': \'testdf\', \'contact_no\': \'123\', \'email\': \'test@he.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(158, '2019-09-24 16:32:03.234510', 'superuser', '2019-09-24 16:32:03.234558', 'superuser', 'Update', 'USER', 40, '{\'id\': 40, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 16, 24, 16, 302733), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000040\', \'name\': \'hary\', \'username\': \'hary\', \'password\': \'pbkdf2_sha256$150000$OdyoqCsocxAl$e3LWCdE25oR5B00LZP8Ov04xjDh1HbWtxmARlOQxCJ0=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'hary@yahoo.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 40, \'code\': \'USER-20190924-0000040\', \'name\': \'hary\', \'username\': \'hary\', \'contact_no\': \'123\', \'email\': \'hary@yahoo.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(159, '2019-09-24 16:32:19.508193', 'superuser', '2019-09-24 16:32:19.508242', 'superuser', 'Update', 'USER', 40, '{\'id\': 40, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 16, 24, 16, 302733), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000040\', \'name\': \'hary\', \'username\': \'hary\', \'password\': \'pbkdf2_sha256$150000$OdyoqCsocxAl$e3LWCdE25oR5B00LZP8Ov04xjDh1HbWtxmARlOQxCJ0=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'hary@yahoo.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 40, \'code\': \'USER-20190924-0000040\', \'name\': \'hary\', \'username\': \'hary\', \'contact_no\': \'123\', \'email\': \'hary@yahoo.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(160, '2019-09-24 16:34:44.493141', 'superuser', '2019-09-24 16:34:44.493185', 'superuser', 'Update', 'USER', 40, '{\'id\': 40, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 16, 24, 16, 302733), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000040\', \'name\': \'hary\', \'username\': \'hary\', \'password\': \'pbkdf2_sha256$150000$OdyoqCsocxAl$e3LWCdE25oR5B00LZP8Ov04xjDh1HbWtxmARlOQxCJ0=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'hary@yahoo.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 40, \'code\': \'USER-20190924-0000040\', \'name\': \'hary\', \'username\': \'hary\', \'contact_no\': \'123\', \'email\': \'hary@yahoo.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(161, '2019-09-24 16:35:52.121665', 'superuser', '2019-09-24 16:35:52.121711', 'superuser', 'Update', 'USER', 40, '{\'id\': 40, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 16, 24, 16, 302733), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000040\', \'name\': \'hary\', \'username\': \'hary\', \'password\': \'pbkdf2_sha256$150000$OdyoqCsocxAl$e3LWCdE25oR5B00LZP8Ov04xjDh1HbWtxmARlOQxCJ0=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'hary@yahoo.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 40, \'code\': \'USER-20190924-0000040\', \'name\': \'hary\', \'username\': \'hary\', \'contact_no\': \'123\', \'email\': \'hary@yahoo.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(162, '2019-09-24 16:36:52.685735', 'superuser', '2019-09-24 16:36:52.685772', 'superuser', 'Update', 'USER', 40, '{\'id\': 40, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 16, 24, 16, 302733), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000040\', \'name\': \'hary\', \'username\': \'hary\', \'password\': \'pbkdf2_sha256$150000$OdyoqCsocxAl$e3LWCdE25oR5B00LZP8Ov04xjDh1HbWtxmARlOQxCJ0=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'hary@yahoo.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 40, \'code\': \'USER-20190924-0000040\', \'name\': \'hary\', \'username\': \'hary\', \'contact_no\': \'123\', \'email\': \'hary@yahoo.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(163, '2019-09-24 16:38:23.653226', 'superuser', '2019-09-24 16:38:23.653275', 'superuser', 'Update', 'USER', 40, '{\'id\': 40, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 16, 24, 16, 302733), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000040\', \'name\': \'hary\', \'username\': \'hary\', \'password\': \'pbkdf2_sha256$150000$OdyoqCsocxAl$e3LWCdE25oR5B00LZP8Ov04xjDh1HbWtxmARlOQxCJ0=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'hary@yahoo.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 40, \'code\': \'USER-20190924-0000040\', \'name\': \'hary\', \'username\': \'hary\', \'contact_no\': \'123\', \'email\': \'hary@yahoo.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(164, '2019-09-24 16:38:51.981515', 'superuser', '2019-09-24 16:38:51.981561', 'superuser', 'Update', 'USER', 40, '{\'id\': 40, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 16, 24, 16, 302733), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000040\', \'name\': \'hary\', \'username\': \'hary\', \'password\': \'pbkdf2_sha256$150000$OdyoqCsocxAl$e3LWCdE25oR5B00LZP8Ov04xjDh1HbWtxmARlOQxCJ0=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'hary@yahoo.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 40, \'code\': \'USER-20190924-0000040\', \'name\': \'hary\', \'username\': \'hary\', \'contact_no\': \'123\', \'email\': \'hary@yahoo.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(165, '2019-09-24 16:41:12.168803', 'superuser', '2019-09-24 16:41:12.168854', 'superuser', 'Update', 'USER', 40, '{\'id\': 40, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 16, 24, 16, 302733), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000040\', \'name\': \'hary\', \'username\': \'hary\', \'password\': \'pbkdf2_sha256$150000$OdyoqCsocxAl$e3LWCdE25oR5B00LZP8Ov04xjDh1HbWtxmARlOQxCJ0=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'hary@yahoo.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 40, \'code\': \'USER-20190924-0000040\', \'name\': \'hary\', \'username\': \'hary\', \'contact_no\': \'123\', \'email\': \'hary@yahoo.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(166, '2019-09-24 16:47:38.907921', 'superuser', '2019-09-24 16:47:38.907974', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(167, '2019-09-24 16:48:09.190341', 'superuser', '2019-09-24 16:48:09.190390', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(168, '2019-09-24 16:48:36.199697', 'superuser', '2019-09-24 16:48:36.199738', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(169, '2019-09-24 16:50:02.795720', 'superuser', '2019-09-24 16:50:02.795766', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(170, '2019-09-24 16:51:03.689856', 'superuser', '2019-09-24 16:51:03.689918', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(171, '2019-09-24 16:51:36.403458', 'superuser', '2019-09-24 16:51:36.403507', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(172, '2019-09-24 16:53:34.547879', 'superuser', '2019-09-24 16:53:34.547945', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(173, '2019-09-24 16:54:00.427606', 'superuser', '2019-09-24 16:54:00.427649', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(174, '2019-09-24 16:54:33.976661', 'superuser', '2019-09-24 16:54:33.976714', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(175, '2019-09-24 16:54:56.496303', 'superuser', '2019-09-24 16:54:56.496350', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(176, '2019-09-24 16:55:40.143166', 'superuser', '2019-09-24 16:55:40.143210', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(177, '2019-09-24 16:56:05.888390', 'superuser', '2019-09-24 16:56:05.888430', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(178, '2019-09-24 16:56:33.179489', 'superuser', '2019-09-24 16:56:33.179536', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(179, '2019-09-24 16:56:59.726140', 'superuser', '2019-09-24 16:56:59.726178', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(180, '2019-09-24 16:57:18.088073', 'superuser', '2019-09-24 16:57:18.088119', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(181, '2019-09-24 16:58:26.083479', 'superuser', '2019-09-24 16:58:26.083524', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(182, '2019-09-24 16:59:55.144116', 'superuser', '2019-09-24 16:59:55.144162', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(183, '2019-09-24 17:00:34.661379', 'superuser', '2019-09-24 17:00:34.661426', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(184, '2019-09-24 17:09:13.996632', 'superuser', '2019-09-24 17:09:13.996680', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(185, '2019-09-24 17:09:33.819847', 'superuser', '2019-09-24 17:09:33.819891', 'superuser', 'Update', 'USER', 23, '{\'id\': 23, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 23, 17, 26, 8, 184477), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'password\': \'pbkdf2_sha256$150000$Q2BcrQvMRylt$Aa96HZJdl5+d1Wh9oDcGUfDbgsTKR55I3yIFD+9/XPk=\', \'doa\': None, \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 23, \'code\': \'USER-20190924-0000023\', \'name\': \'sdf\', \'username\': \'sdfgfd\', \'contact_no\': \'23\', \'email\': \'asdf@sadf.om\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(186, '2019-09-24 17:12:24.705264', 'superuser', '2019-09-24 17:12:24.705309', 'superuser', 'Update', 'USER', 40, '{\'id\': 40, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 16, 24, 16, 302733), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'code\': \'USER-20190924-0000040\', \'name\': \'hary\', \'username\': \'hary\', \'password\': \'pbkdf2_sha256$150000$OdyoqCsocxAl$e3LWCdE25oR5B00LZP8Ov04xjDh1HbWtxmARlOQxCJ0=\', \'doa\': None, \'contact_no\': \'123\', \'email\': \'hary@yahoo.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 40, \'code\': \'USER-20190924-0000040\', \'name\': \'hary\', \'username\': \'hary\', \'contact_no\': \'123\', \'email\': \'hary@yahoo.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'DUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(187, '2019-09-24 17:15:22.352751', 'superuser', '2019-09-24 17:15:22.352800', 'superuser', 'Update', 'USER', 41, '{\'id\': 41, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 17, 15, 4, 409001), \'department\': \'DEPARTMENT-20190923-0000002\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'password\': \'pbkdf2_sha256$150000$olNZcVXGWmdD$LYt/O1uklgpNjwLd7NU8RYd8ptBXg+P5QhUVvsbnBAM=\', \'doa\': None, \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Change Request Management System>]}', '{\'id\': 41, \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 2, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000002\', \'name\': \'Business Develsopment\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(188, '2019-09-24 17:15:31.919690', 'superuser', '2019-09-24 17:15:31.919736', 'superuser', 'Update', 'USER', 41, '{\'id\': 41, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 17, 15, 4, 409001), \'department\': \'DEPARTMENT-20190923-0000002\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'password\': \'pbkdf2_sha256$150000$olNZcVXGWmdD$LYt/O1uklgpNjwLd7NU8RYd8ptBXg+P5QhUVvsbnBAM=\', \'doa\': None, \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Change Request Management System>]}', '{\'id\': 41, \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 2, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000002\', \'name\': \'Business Develsopment\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(189, '2019-09-24 17:15:51.550018', 'superuser', '2019-09-24 17:15:51.550055', 'superuser', 'Update', 'USER', 41, '{\'id\': 41, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 17, 15, 4, 409001), \'department\': \'DEPARTMENT-20190923-0000002\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'password\': \'pbkdf2_sha256$150000$olNZcVXGWmdD$LYt/O1uklgpNjwLd7NU8RYd8ptBXg+P5QhUVvsbnBAM=\', \'doa\': None, \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Change Request Management System>]}', '{\'id\': 41, \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 2, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000002\', \'name\': \'Business Develsopment\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(190, '2019-09-24 17:16:03.183963', 'superuser', '2019-09-24 17:16:03.184009', 'superuser', 'Update', 'USER', 41, '{\'id\': 41, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 17, 15, 4, 409001), \'department\': \'DEPARTMENT-20190923-0000002\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'password\': \'pbkdf2_sha256$150000$olNZcVXGWmdD$LYt/O1uklgpNjwLd7NU8RYd8ptBXg+P5QhUVvsbnBAM=\', \'doa\': None, \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Change Request Management System>]}', '{\'id\': 41, \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 2, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000002\', \'name\': \'Business Develsopment\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(191, '2019-09-24 17:16:17.278267', 'superuser', '2019-09-24 17:16:17.278316', 'superuser', 'Update', 'USER', 41, '{\'id\': 41, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 17, 15, 4, 409001), \'department\': \'DEPARTMENT-20190923-0000002\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'password\': \'pbkdf2_sha256$150000$olNZcVXGWmdD$LYt/O1uklgpNjwLd7NU8RYd8ptBXg+P5QhUVvsbnBAM=\', \'doa\': None, \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Change Request Management System>]}', '{\'id\': 41, \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 2, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000002\', \'name\': \'Business Develsopment\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(192, '2019-09-24 17:16:53.493169', 'superuser', '2019-09-24 17:16:53.493213', 'superuser', 'Update', 'USER', 41, '{\'id\': 41, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 17, 15, 4, 409001), \'department\': \'DEPARTMENT-20190923-0000002\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'password\': \'pbkdf2_sha256$150000$olNZcVXGWmdD$LYt/O1uklgpNjwLd7NU8RYd8ptBXg+P5QhUVvsbnBAM=\', \'doa\': None, \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Change Request Management System>]}', '{\'id\': 41, \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 2, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000002\', \'name\': \'Business Develsopment\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(193, '2019-09-24 18:22:41.587988', 'superuser', '2019-09-24 18:22:41.588040', 'superuser', 'Update', 'USER', 42, '{\'id\': 42, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 18, 21, 20, 427951), \'department\': \'DEPARTMENT-20190923-0000001\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'code\': \'USER-20190924-0000042\', \'name\': \'testEdit\', \'username\': \'testEdit\', \'password\': \'pbkdf2_sha256$150000$bu7eaAT9s8Ky$CZ/zBr34mpEXGOGR3NSL6KyoKLNY5tQA8ZalZBdKts4=\', \'doa\': None, \'contact_no\': \'132\', \'email\': \'testEdit@mail.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Change Request Management System>]}', '{\'id\': 42, \'code\': \'USER-20190924-0000042\', \'name\': \'testEdit\', \'username\': \'testEdit\', \'contact_no\': \'132\', \'email\': \'testEdit@mail.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000001\', \'name\': \'ADMIN\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(194, '2019-09-24 18:30:16.848339', 'superuser', '2019-09-24 18:30:16.848390', 'superuser', 'Update', 'USER', 41, '{\'id\': 41, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 17, 15, 4, 409001), \'department\': \'DEPARTMENT-20190923-0000002\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'password\': \'pbkdf2_sha256$150000$olNZcVXGWmdD$LYt/O1uklgpNjwLd7NU8RYd8ptBXg+P5QhUVvsbnBAM=\', \'doa\': None, \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Change Request Management System>]}', '{\'id\': 41, \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 2, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000002\', \'name\': \'Business Develsopment\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(195, '2019-09-24 18:50:11.470767', 'superuser', '2019-09-24 18:50:11.470819', 'superuser', 'Update', 'USER', 41, '{\'id\': 41, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 17, 15, 4, 409001), \'department\': \'DEPARTMENT-20190923-0000002\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'password\': \'pbkdf2_sha256$150000$olNZcVXGWmdD$LYt/O1uklgpNjwLd7NU8RYd8ptBXg+P5QhUVvsbnBAM=\', \'doa\': None, \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Change Request Management System>]}', '{\'id\': 41, \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 2, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000002\', \'name\': \'Business Develsopment\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(196, '2019-09-24 19:02:07.828024', 'superuser', '2019-09-24 19:02:07.828079', 'superuser', 'Update', 'USER', 41, '{\'id\': 41, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 17, 15, 4, 409001), \'department\': \'DEPARTMENT-20190923-0000002\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'password\': \'pbkdf2_sha256$150000$olNZcVXGWmdD$LYt/O1uklgpNjwLd7NU8RYd8ptBXg+P5QhUVvsbnBAM=\', \'doa\': None, \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Change Request Management System>]}', '{\'id\': 41, \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 2, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000002\', \'name\': \'Business Develsopment\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(197, '2019-09-24 19:03:41.818645', 'superuser', '2019-09-24 19:03:41.818678', 'superuser', 'DELETED', 'COMPANY', 2, '{\'id\': 2, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000002\', \'name\': \'Total Integrated Resources\', \'contact_details\': \'2152509\'}', '{\'id\': 2, \'created\': \'2019-09-23T13:05:24.438314\', \'createdby\': \'superuser\', \'modified\': \'2019-09-24T19:03:41.816103\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000002\', \'name\': \'Total Integrated Resources\', \'contact_details\': \'2152509\'}'),
	(198, '2019-09-24 19:08:35.604737', 'superuser', '2019-09-24 19:08:35.604790', 'superuser', 'Update', 'USER', 41, '{\'id\': 41, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 17, 15, 4, 409001), \'department\': \'DEPARTMENT-20190923-0000002\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'password\': \'pbkdf2_sha256$150000$olNZcVXGWmdD$LYt/O1uklgpNjwLd7NU8RYd8ptBXg+P5QhUVvsbnBAM=\', \'doa\': None, \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Change Request Management System>]}', '{\'id\': 41, \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 2, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000002\', \'name\': \'Business Develsopment\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(199, '2019-09-24 19:09:03.341355', 'superuser', '2019-09-24 19:09:03.341405', 'superuser', 'Update', 'USER', 41, '{\'id\': 41, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 17, 15, 4, 409001), \'department\': \'DEPARTMENT-20190923-0000002\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'password\': \'pbkdf2_sha256$150000$olNZcVXGWmdD$LYt/O1uklgpNjwLd7NU8RYd8ptBXg+P5QhUVvsbnBAM=\', \'doa\': None, \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Change Request Management System>]}', '{\'id\': 41, \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 2, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000002\', \'name\': \'Business Develsopment\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(200, '2019-09-24 19:09:18.753563', 'superuser', '2019-09-24 19:09:18.753596', 'superuser', 'DELETED', 'COMPANY', 2, '{\'id\': 2, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190924-0000002\', \'name\': \'Total Integrated Resources\', \'contact_details\': \'2152509\'}', '{\'id\': 2, \'created\': \'2019-09-23T13:05:24.438314\', \'createdby\': \'superuser\', \'modified\': \'2019-09-24T19:09:18.751018\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190924-0000002\', \'name\': \'Total Integrated Resources\', \'contact_details\': \'2152509\'}'),
	(201, '2019-09-24 19:10:15.368404', 'superuser', '2019-09-24 19:10:15.368435', 'superuser', 'DELETED', 'COMPANY', 2, '{\'id\': 2, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190924-0000002\', \'name\': \'Total Integrated Resources\', \'contact_details\': \'2152509\'}', '{\'id\': 2, \'created\': \'2019-09-23T13:05:24.438314\', \'createdby\': \'superuser\', \'modified\': \'2019-09-24T19:10:15.365772\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190924-0000002\', \'name\': \'Total Integrated Resources\', \'contact_details\': \'2152509\'}'),
	(202, '2019-09-24 19:11:44.436152', 'superuser', '2019-09-24 19:11:44.436187', 'superuser', 'DELETED', 'DEPARTMENT', 3, '{\'id\': 3, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190924-0000002\', \'code\': \'DEPARTMENT-20190924-0000003\', \'name\': \'Quality Assurance\'}', '{\'id\': 3, \'created\': \'2019-09-24T19:08:55.157409\', \'createdby\': \'superuser\', \'modified\': \'2019-09-24T19:11:44.432156\', \'modifiedby\': \'superuser\', \'code\': \'DEPARTMENT-20190924-0000003\', \'name\': \'Quality Assurance\', \'company\': {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 13, 5, 24, 438314), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 24, 19, 10, 15, 365772), \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190924-0000002\', \'name\': \'Total Integrated Resources\', \'contact_details\': \'2152509\'}}'),
	(203, '2019-09-24 19:28:31.744688', 'superuser', '2019-09-24 19:28:31.744722', 'superuser', 'DELETED', 'DEPARTMENT', 4, '{\'id\': 4, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190924-0000002\', \'code\': \'DEPARTMENT-20190924-0000004\', \'name\': \'test\'}', '{\'id\': 4, \'created\': \'2019-09-24T19:26:55.183828\', \'createdby\': \'superuser\', \'modified\': \'2019-09-24T19:28:31.740683\', \'modifiedby\': \'superuser\', \'code\': \'DEPARTMENT-20190924-0000004\', \'name\': \'test\', \'company\': {\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 45, 31, 58709), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 13, 15, 45, 68355), \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}}'),
	(204, '2019-09-24 19:28:42.659926', 'superuser', '2019-09-24 19:28:42.659960', 'superuser', 'DELETED', 'DEPARTMENT', 4, '{\'id\': 4, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190924-0000004\', \'name\': \'test\'}', '{\'id\': 4, \'created\': \'2019-09-24T19:26:55.183828\', \'createdby\': \'superuser\', \'modified\': \'2019-09-24T19:28:42.656045\', \'modifiedby\': \'superuser\', \'code\': \'DEPARTMENT-20190924-0000004\', \'name\': \'test\', \'company\': {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 13, 5, 24, 438314), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 24, 19, 10, 15, 365772), \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190924-0000002\', \'name\': \'Total Integrated Resources\', \'contact_details\': \'2152509\'}}'),
	(205, '2019-09-24 19:28:48.221293', 'superuser', '2019-09-24 19:28:48.221340', 'superuser', 'DELETED', 'DEPARTMENT', 4, '{\'id\': 4, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190924-0000002\', \'code\': \'DEPARTMENT-20190924-0000004\', \'name\': \'test\'}', ''),
	(206, '2019-09-25 10:11:07.933360', 'superuser', '2019-09-25 10:11:07.933397', 'superuser', 'DELETED', 'COMPANY', 1, '{\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}', '{\'id\': 1, \'created\': \'2019-09-23T12:45:31.058709\', \'createdby\': \'superuser\', \'modified\': \'2019-09-25T10:11:07.931567\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}'),
	(207, '2019-09-25 10:21:32.360524', 'superuser', '2019-09-25 10:21:32.360568', 'superuser', 'Update', 'USER', 43, '{\'id\': 43, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 19, 10, 1, 481071), \'department\': \'DEPARTMENT-20190924-0000003\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'code\': \'USER-20190924-0000043\', \'name\': \'test2\', \'username\': \'test2\', \'password\': \'pbkdf2_sha256$150000$SDrfFVquBGr8$E0jn5bG5HUN9R91MnmKUEFT/AjAMlMMVL8DfvnZWOIk=\', \'doa\': None, \'contact_no\': \'1232131\', \'email\': \'red@tirsolutions.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Change Request Management System>]}', '{\'id\': 43, \'code\': \'USER-20190924-0000043\', \'name\': \'Ritas\', \'username\': \'test33\', \'contact_no\': \'1312313\', \'email\': \'test@gmail.com\', \'default_app\': \'APP-20190923-0000001\', \'user_type\': \'OUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 2, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000002\', \'name\': \'Business Develsopment\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(208, '2019-09-25 10:22:03.979841', 'superuser', '2019-09-25 10:22:03.979873', 'superuser', 'DELETED', 'COMPANY', 1, '{\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}', '{\'id\': 1, \'created\': \'2019-09-23T12:45:31.058709\', \'createdby\': \'superuser\', \'modified\': \'2019-09-25T10:22:03.978427\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}'),
	(209, '2019-09-25 10:22:07.704459', 'superuser', '2019-09-25 10:22:07.704501', 'superuser', 'Update', 'USER', 43, '{\'id\': 43, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 19, 10, 1, 481071), \'department\': \'DEPARTMENT-20190923-0000002\', \'default_app\': \'APP-20190923-0000001\', \'user_type\': \'OUA\', \'code\': \'USER-20190924-0000043\', \'name\': \'Ritas\', \'username\': \'test33\', \'password\': \'pbkdf2_sha256$150000$SDrfFVquBGr8$E0jn5bG5HUN9R91MnmKUEFT/AjAMlMMVL8DfvnZWOIk=\', \'doa\': None, \'contact_no\': \'1312313\', \'email\': \'test@gmail.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Resource Management System>, <Application: Change Request Management System>]}', '{\'id\': 43, \'code\': \'USER-20190924-0000043\', \'name\': \'Ritas\', \'username\': \'test33\', \'contact_no\': \'1312313\', \'email\': \'test@gmail.com\', \'default_app\': \'APP-20190923-0000001\', \'user_type\': \'OUA\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 2, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000002\', \'name\': \'Business Develsopment\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 1, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 33, 754098), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000001\', \'name\': \'Resource Management System\'}, {\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}'),
	(210, '2019-09-25 10:22:18.785701', 'superuser', '2019-09-25 10:22:18.785747', 'superuser', 'Update', 'USER', 41, '{\'id\': 41, \'last_login\': None, \'is_superuser\': False, \'first_name\': \'\', \'last_name\': \'\', \'is_staff\': False, \'is_active\': True, \'date_joined\': datetime.datetime(2019, 9, 24, 17, 15, 4, 409001), \'department\': \'DEPARTMENT-20190923-0000002\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'password\': \'pbkdf2_sha256$150000$olNZcVXGWmdD$LYt/O1uklgpNjwLd7NU8RYd8ptBXg+P5QhUVvsbnBAM=\', \'doa\': None, \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'groups\': [], \'user_permissions\': [], \'application\': [<Application: Change Request Management System>]}', '{\'id\': 41, \'code\': \'USER-20190924-0000041\', \'name\': \'Wownman\', \'username\': \'Wownman\', \'contact_no\': \'13213\', \'email\': \'red@tirsolutions.com\', \'default_app\': \'APP-20190923-0000002\', \'user_type\': \'USR\', \'is_active\': True, \'doa\': None, \'department\': {\'id\': 2, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'company\': \'COMPANY-20190923-0000001\', \'code\': \'DEPARTMENT-20190923-0000002\', \'name\': \'Business Develsopment\'}, \'company\': {\'id\': 1, \'createdby\': \'superuser\', \'modifiedby\': \'superuser\', \'code\': \'COMPANY-20190923-0000001\', \'name\': \'Oneberry Technologies Pte Ltd.\', \'contact_details\': \'2152509\'}, \'application\': <QuerySet [{\'id\': 2, \'created\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'createdby\': \'superuser\', \'modified\': datetime.datetime(2019, 9, 23, 12, 43, 40, 512905), \'modifiedby\': \'superuser\', \'code\': \'APP-20190923-0000002\', \'name\': \'Change Request Management System\'}]>}');
/*!40000 ALTER TABLE `entity_logs` ENABLE KEYS */;

-- Dumping structure for table rms_db.modules
CREATE TABLE IF NOT EXISTS `modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `parent` int(11) DEFAULT NULL,
  `sort_id` int(11) NOT NULL,
  `component` varchar(255) DEFAULT NULL,
  `application_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`),
  KEY `modules_application_id_f285bf5b_fk_applications_code` (`application_id`),
  CONSTRAINT `modules_application_id_f285bf5b_fk_applications_code` FOREIGN KEY (`application_id`) REFERENCES `applications` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.modules: ~9 rows (approximately)
DELETE FROM `modules`;
/*!40000 ALTER TABLE `modules` DISABLE KEYS */;
INSERT INTO `modules` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `code`, `name`, `parent`, `sort_id`, `component`, `application_id`) VALUES
	(1, '2019-09-23 12:46:12.211187', 'superuser', '2019-09-23 12:46:12.211187', 'superuser', 'MODULE-20190923-0000001', 'RMS HEADER', 0, 8, NULL, 'APP-20190923-0000001'),
	(2, '2019-09-23 12:46:31.481209', 'superuser', '2019-09-23 12:46:31.481209', 'superuser', 'MODULE-20190923-0000002', 'Application Management', 1, 1, 'rms/application-management', 'APP-20190923-0000001'),
	(3, '2019-09-23 12:46:48.031401', 'superuser', '2019-09-23 12:46:48.031401', 'superuser', 'MODULE-20190923-0000003', 'Company Management', 1, 2, 'rms/company-management', 'APP-20190923-0000001'),
	(4, '2019-09-23 12:46:52.207690', 'superuser', '2019-09-23 12:46:52.207690', 'superuser', 'MODULE-20190923-0000004', 'Department Management', 1, 3, 'rms/department-management', 'APP-20190923-0000001'),
	(5, '2019-09-23 12:46:57.033689', 'superuser', '2019-09-23 12:46:57.033689', 'superuser', 'MODULE-20190923-0000005', 'Module Management', 1, 4, 'rms/module-management', 'APP-20190923-0000001'),
	(6, '2019-09-23 12:47:02.615922', 'superuser', '2019-09-23 12:47:02.615922', 'superuser', 'MODULE-20190923-0000006', 'User Management', 1, 5, 'rms/user-management', 'APP-20190923-0000001'),
	(7, '2019-09-23 13:02:59.128530', 'superuser', '2019-09-23 13:02:59.128530', 'superuser', 'MODULE-20190923-0000007', 'CMS HEADER', 0, 2, NULL, 'APP-20190923-0000002'),
	(8, '2019-09-23 13:10:14.026641', 'superuser', '2019-09-23 13:10:14.026641', 'superuser', 'MODULE-20190923-0000008', 'AMS HEADER', 0, 1, NULL, 'APP-20190923-0000003'),
	(9, '2019-09-23 14:25:25.469618', 'superuser', '2019-09-23 14:25:25.469668', 'superuser', 'MODULE-20190923-0000009', 'Change Request Template', 7, 1, 'cms/change-request/template/', 'APP-20190923-0000002');
/*!40000 ALTER TABLE `modules` ENABLE KEYS */;

-- Dumping structure for table rms_db.notifications
CREATE TABLE IF NOT EXISTS `notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `notif_type` varchar(20) NOT NULL,
  `message` varchar(255) DEFAULT NULL,
  `is_read` tinyint(1) DEFAULT NULL,
  `created` datetime(6) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `account_no` varchar(255) DEFAULT NULL,
  `app` varchar(255) DEFAULT NULL,
  `form_code` varchar(255) DEFAULT NULL,
  `sender_account_no` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.notifications: ~0 rows (approximately)
DELETE FROM `notifications`;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;

-- Dumping structure for table rms_db.password_resets
CREATE TABLE IF NOT EXISTS `password_resets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` datetime(6) NOT NULL,
  `timeout_at` datetime(6) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `code` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.password_resets: ~0 rows (approximately)
DELETE FROM `password_resets`;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;

-- Dumping structure for table rms_db.permissions
CREATE TABLE IF NOT EXISTS `permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.permissions: ~0 rows (approximately)
DELETE FROM `permissions`;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;

-- Dumping structure for table rms_db.roles
CREATE TABLE IF NOT EXISTS `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.roles: ~0 rows (approximately)
DELETE FROM `roles`;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;

-- Dumping structure for table rms_db.role_permissions
CREATE TABLE IF NOT EXISTS `role_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `permission_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `role_permissions_permission_id_ad343843_fk_permissions_id` (`permission_id`),
  KEY `role_permissions_role_id_216516f2_fk_roles_id` (`role_id`),
  CONSTRAINT `role_permissions_role_id_216516f2_fk_roles_id` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`),
  CONSTRAINT `role_permissions_permission_id_ad343843_fk_permissions_id` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.role_permissions: ~0 rows (approximately)
DELETE FROM `role_permissions`;
/*!40000 ALTER TABLE `role_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_permissions` ENABLE KEYS */;

-- Dumping structure for table rms_db.status_set
CREATE TABLE IF NOT EXISTS `status_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `ref` varchar(10) NOT NULL,
  `code` varchar(10) NOT NULL,
  `name` varchar(10) NOT NULL,
  `description` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Dumping data for table rms_db.status_set: ~0 rows (approximately)
DELETE FROM `status_set`;
/*!40000 ALTER TABLE `status_set` DISABLE KEYS */;
/*!40000 ALTER TABLE `status_set` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
