from app.entities import models
from rest_framework import serializers
from app.applicationlayer.utils import model_to_dict


class AssetTypeSerializer(serializers.ModelSerializer):

    def to_representation(self, instance):
        ret = super().to_representation(instance)

        assets = instance.ams_asset_type.select_related()
        ams_stock_counter = 0

        for asset in assets:
            ams_stock_counter = ams_stock_counter + models.AMSAsset.objects.get(code=asset.code).ams_asset_to_assetdetail.count()
        
        ret['asset_count'] = assets.count()
        ret['asset_stock_count'] = ams_stock_counter
        
        return ret

    class Meta:
        model = models.AMSAssetType
        fields = '__all__'
        read_only_fields = ['created', 'created_by', 'code']