import copy
from rest_framework import status, viewsets
from rest_framework.response import Response
from app.entities.models import MasterAttachment
from app.applicationlayer.master.attachment.serializer import MasterAttachmentSerializer
from app.applicationlayer.utils import CustomPagination, status_message_response
from django.db import transaction
from rest_framework.exceptions import ValidationError


class MasterAttachmentViewSet(viewsets.ModelViewSet):
    queryset = MasterAttachment.objects.all()
    serializer_class = MasterAttachmentSerializer
    pagination_class = CustomPagination
    # @decorators.rms.user_list
    def list(self, request, *args, **kwargs):

        queryset = self.filter_queryset(self.get_queryset())
        page = self.paginate_queryset(queryset)

        if page is not None:
            serializer = self.get_serializer(page, many=True)

            message = status_message_response(
                200,
                'success',
                'list of Attachment found',
                serializer.data
            )

            return self.get_paginated_response(message)

        serializer = self.get_serializer(queryset, many=True)

        return Response(
            serializer.data,
            status=status.HTTP_200_OK
        )

    @transaction.atomic
    def create(self, request, *args, **kwargs):
        attachments = []
        for instance in self.request.data:

            body = {}
            data = MasterAttachment.objects.create(
                url=instance,
                attch_ref=str(request.data[instance])
            )

            body['id'] = data.id
            body['file_name'] = str(request.data[instance])
            body['attch_ref'] = instance
            attachments.append(body)

        return Response(
            {"results": attachments},
            status=status.HTTP_201_CREATED
        )
