from django.db import models
from django.utils import timezone


class Application(models.Model):
    application_no = models.CharField(max_length=250)
    name = models.CharField(max_length=200, unique=True)
    theme = models.IntegerField()
    code = models.CharField(max_length=300)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    deleted_at = models.DateTimeField(null=True, blank=True)

    def delete(self):
        self.deleted_at = timezone.now()
        self.save()

    def __str__(self):
        return self.name

    class Meta:
        db_table = 'application'


class APIService(models.Model):
    api_service_no = models.CharField(max_length=250)
    name = models.CharField(max_length=200)
    service_token = models.CharField(max_length=200, unique=True)
    base_url = models.CharField(max_length=200)
    service_url = models.CharField(max_length=200)
    application = models.ForeignKey(Application, on_delete=models.DO_NOTHING)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    deleted_at = models.DateTimeField(null=True, blank=True)

    def delete(self):
        self.deleted_at = timezone.now()
        self.save()

    def __str__(self):
        return self.name

    class Meta:
        db_table = 'api_services'


class APIEndpoint(models.Model):
    api_endpoint_no = models.CharField(max_length=250)
    service = models.ForeignKey(APIService, on_delete=models.DO_NOTHING)
    name = models.CharField(max_length=200)
    description = models.CharField(max_length=255, null=True, blank=True)
    http_method = models.CharField(max_length=100)
    endpoint_url = models.CharField(max_length=200)
    is_need_auth = models.BooleanField(default=False)
    is_active = models.BooleanField(default=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)
    deleted_at = models.DateTimeField(null=True, blank=True)

    def delete(self):
        self.deleted_at = timezone.now()
        self.save()

    def __str__(self):
        return self.name

    class Meta:
        db_table = 'api_endpoints'
