from rest_framework.views import APIView
from rest_framework.response import Response
from app.entities import enums
from app.applicationlayer.utils import main_threading
from app.helper.email_service import sender
from rest_framework.permissions import AllowAny


class UserTypeViewSet(APIView):

    def get(self, request, format=None):
        enums_super = enums.UserTypeEnum.SUPER_USER.value
        enums_OUA = enums.UserTypeEnum.OVERALL_USER_ADMIN.value
        enums_company = enums.UserTypeEnum.COMPANY_USER_ADMIN.value
        enums_department = enums.UserTypeEnum.DEPARTMENT_USER_ADMIN.value
        enums_user = enums.UserTypeEnum.USER.value

        enums_super_key = str(enums.UserTypeEnum.SUPER_USER.name).replace('_',' ')
        enums_OUA_key = str(enums.UserTypeEnum.OVERALL_USER_ADMIN.name).replace('_',' ')
        enums_company_key = str(enums.UserTypeEnum.COMPANY_USER_ADMIN.name).replace('_',' ')
        enums_department_key = str(enums.UserTypeEnum.DEPARTMENT_USER_ADMIN.name).replace('_',' ')
        enums_user_key = str(enums.UserTypeEnum.USER.name).replace('_',' ')

        data = {
            "code": "200",
            "status": "success",
            "message": "list of user types",
            "results":
            # [
                {
                    enums_super_key : enums_super,
                    enums_OUA_key : enums_OUA,
                    enums_company_key : enums_company, 
                    enums_department_key : enums_department,
                    enums_user_key : enums_user
                }
            # ]
        }

        # if self.request.user.user_type == enums_OUA:
        #     del data['Super user']
        #     del data['Overall user admin']
        # elif self.request.user.user_type == enums_company:
        #     del data['Super user']
        #     del data['Overall user admin']
        #     del data['Company user admin']
        if self.request.user.user_type != enums_super:
            del data['results'][str(enums.UserTypeEnum.SUPER_USER.name)]
            del data['results'][str(enums.UserTypeEnum.OVERALL_USER_ADMIN.name)]
            del data['results'][str(enums.UserTypeEnum.COMPANY_USER_ADMIN.name)]
            del data['results'][str(enums.UserTypeEnum.DEPARTMENT_USER_ADMIN.name)]

        return Response(data)


class cronjob(APIView):

    permission_classes = (AllowAny,)

    def get(self, request, format=None):
        args =  ''
        main_threading(args, sender.cronjob)

        return Response("sent")
