from .base import *
import configparser

DEBUG = True

ALLOWED_HOSTS = ['*']

INSTALLED_APPS += [
    'rest_framework_swagger',
]

REST_FRAMEWORK = {
    'EXCEPTION_HANDLER': 'rest_framework.views.exception_handler',
    'UNAUTHENTICATED_USER': None,
}

config = configparser.ConfigParser()
config.read('env.ini')

DATABASES = {
    'default': {
        'ENGINE': config['LOCAL']['DATABASE_ENGINE'],
        'NAME': config['LOCAL']['DATABASE_NAME'],
        'USER': config['LOCAL']['DATABASE_USER'],
        'PASSWORD': config['LOCAL']['DATABASE_PASSWORD'],
        'HOST': config['LOCAL']['DATABASE_HOST'],
        'PORT': config['LOCAL']['DATABASE_PORT'],
    }
}


AUTHENTICATOR_IP = config['SERVICE']['AUTHENTICATOR_IP']
AUTHENTICATOR_PATH = '/api/v1/authenticator'

VALIDATE_TOKEN_URL = f'http://{AUTHENTICATOR_IP}{AUTHENTICATOR_PATH}/validate-token/'
ACCOUNT_GROUP = f'http://{AUTHENTICATOR_IP}{AUTHENTICATOR_PATH}/account-dependent'
