from rest_framework.response import Response
from rest_framework import status
import json
from rest_framework.exceptions import ParseError
from functools import wraps
from rest_framework.authtoken.models import Token
from app.entities.models import User, Department, Company
from app.entities import enums
from django.db.models import Q
from app.businesslayer.changerequest.change_request_template import (
    tmp_add_edit_delete,
    validation_approver_same_level,
    validation_existing_vendor_requestor,
    validation_existing_approver
)


def error_safe(function):
    def wrap(request, *args, **kwargs):
        stat = status.HTTP_500_INTERNAL_SERVER_ERROR
        try:
            return function(request, *args, **kwargs)
        # except 'DoesNotExist' as ex:
        #     print('ddd')
        #     stat = status.HTTP_404_NOT_FOUND

        except Exception as ex:
            data = ''
            try:
                data = str(ex)
                print(f'ERROR: {data}')
            except Exception as ex2:
                pass
            return Response(data={"message": data},
                            status=stat)

    wrap.__doc__ = function.__doc__
    wrap.__name__ = function.__name__
    return wrap


class rms:

    # variables
    enums_super = enums.UserTypeEnum.SUPER_USER.value
    enums_OUA = enums.UserTypeEnum.OVERALL_USER_ADMIN.value
    enums_company = enums.UserTypeEnum.COMPANY_USER_ADMIN.value
    enums_department = enums.UserTypeEnum.DEPARTMENT_USER_ADMIN.value
    enums_user = enums.UserTypeEnum.USER.value
    access_error = "Logged user is unauthorize to access this section"
    department_error = 'Department should be same with the logged user'
    company_error = 'Company should be same with the logged user'

    def user(self):
        return self.request.user

    def user_type(self):
        return rms.user(self).user_type

    def superuser_create(self):
        if rms.user_type(self) != rms.enums_super:
            raise ParseError(rms.access_error)
        else:
            return True

    @staticmethod
    def user_create(function):
        @wraps(function)
        def wrapper(self, request, *args, **kwargs):
            print(rms.user_type(self))
            if rms.user_type(self) == rms.enums_user:
                # raise ParseError(
                #     rms.access_error
                # )
                return Response(
                    {"message": rms.access_error},
                    status=status.HTTP_400_BAD_REQUEST
                )
            elif rms.user_type(self) == rms.enums_department:
                if request.data['department'] != rms.user(self).department.code:
                    return Response(
                        {"message": rms.department_error},
                        status=status.HTTP_400_BAD_REQUEST
                    )
            elif rms.user_type(self) == rms.enums_company:
                user_company = rms.user(self).department.company
                request_department = Department.objects.filter(
                    Q(code=request.data['department']) &
                    Q(company=user_company)
                )
                if not request_department:
                    return Response(
                        {"message": rms.company_error},
                        status=status.HTTP_400_BAD_REQUEST
                    )
            return function(self, request, *args, **kwargs)
        return wrapper


    @staticmethod
    def ApplicationValidation(function):
        @wraps(function)
        def wrapper(self, request, *args, **kwargs):
            payload = request.data
            if not 'excel_code' in payload:
                return Response(
                    {"message": "Excel code is required"}
                )
            elif len(payload['excel_code'].strip()) == 0:
                return Response(
                    {"message": "Excel code is may not be blank"}
                )
            is_excel_code_exist = self.queryset.filter(
                excel_code=payload['excel_code']
            )
            if is_excel_code_exist:
                return Response(
                    {"message": "This excel code is already exists"}
                )
            return function(self, request, *args, **kwargs)
        return wrapper


    @staticmethod
    def AccountValidation(function):
        @wraps(function)
        def wrapper(self, request, *args, **kwargs):
            payload = request.data
            username = self.queryset.filter(username=payload['username'])
            if username.count() >= 1:
                return Response(
                    {
                        "message": f"username {username.first().username} is already taken"
                    },
                    status=status.HTTP_400_BAD_REQUEST
                )
            # rms.user_create(self, request, *args, **kwargs)
            
            return function(self, request, *args, **kwargs)
        return wrapper

    @staticmethod
    def reset_password(function):
        @wraps(function)
        def wrapper(self, request, *args, **kwargs):
            if rms.user_type(self) == rms.enums_user:
                raise ParseError(
                    rms.access_error
                )
            elif rms.user_type(self) == rms.enums_department:
                instance = self.get_object()
                if rms.user(self).department.code != instance.department.code:
                    raise ParseError(
                        rms.department_error
                    )
            elif rms.user_type(self) == rms.enums_company:
                user_company = rms.user(self).department.company
                request_department = Department.objects.filter(
                    Q(code=request.user.department.code) &
                    Q(company=user_company)
                )
                if not request_department:
                    raise ParseError(rms.company_error)

            return function(self, request, *args, **kwargs)
        return wrapper

    @staticmethod
    def company_crate(function):
        @wraps(function)
        def wrapper(self, request, *args, **kwargs):
            rms.superuser_create(self)
            return function(self, request, *args, **kwargs)
        return wrapper

    @staticmethod
    def department_crate(function):
        @wraps(function)
        def wrapper(self, request, *args, **kwargs):
            rms.superuser_create(self)
            return function(self, request, *args, **kwargs)
        return wrapper

    @staticmethod
    def application_crate(function):
        @wraps(function)
        def wrapper(self, request, *args, **kwargs):
            rms.superuser_create(self)
            return function(self, request, *args, **kwargs)
        return wrapper

    @staticmethod
    def module_crate(function):
        @wraps(function)
        def wrapper(self, request, *args, **kwargs):
            rms.superuser_create(self)
            return function(self, request, *args, **kwargs)
        return wrapper

    @staticmethod
    def company_list(function):
        @wraps(function)
        def wrapper(self, request, *args, **kwargs):

            if rms.user_type(self) == rms.enums_company or rms.user_type(self) == rms.enums_department:

                id = rms.user(self).department.company.id

                self.queryset = self.queryset.filter(
                    id=id
                )
            elif rms.user_type(self) == rms.enums_super:
                pass
            elif rms.user_type(self) == rms.enums_OUA:
                pass
            else:
                raise ParseError(
                    rms.access_error
                )

            return function(self, request, *args, **kwargs)
        return wrapper

    @staticmethod
    def department_list(function):
        @wraps(function)
        def wrapper(self, request, *args, **kwargs):

            if rms.user_type(self) == rms.enums_department:
                id = rms.user(self).department.id

                self.queryset = self.queryset.filter(
                    id=id
                )
            elif rms.user_type(self) == rms.enums_OUA:
                pass
            elif rms.user_type(self) == rms.enums_company:
                pass
            elif rms.user_type(self) == rms.enums_super:
                pass
            else:
                raise ParseError(
                    rms.access_error
                )

            return function(self, request, *args, **kwargs)
        return wrapper


    @staticmethod
    def user_list(function):
        @wraps(function)
        def wrapper(self, request, *args, **kwargs):

            if rms.user_type(self) == rms.enums_department:
                code = rms.user(self).department.code

                self.queryset = self.queryset.filter(
                    department=str(code)
                )

            elif rms.user_type(self) == rms.enums_company:
                code = rms.user(self).department.company.code
                self.queryset = self.queryset.filter(
                    department__company=str(code)
                )
            elif rms.user_type(self) == rms.enums_super:
                pass
            elif rms.user_type(self) == rms.enums_OUA:
                pass
            else:
                raise ParseError(
                    rms.access_error
                )

            return function(self, request, *args, **kwargs)
        return wrapper


def TemplateValidation(function):
    @wraps(function)
    def wrapper(self, request, *args, **kwargs):
        template_header = request.data

        if (template_header['created_by_department'] == 'DEPARTMENT-20190923-0000001' or
                template_header['requested_to_department'] == 'DEPARTMENT-20190923-0000001'):
            message = {
                'code': 400,
                'status': 'failed',
                'message': 'Superuser department cannot be selected',
            }
            return Response(message,
                            status=status.HTTP_400_BAD_REQUEST)

        tmp_approvers = template_header['tmp_approvers']

        # Check if Vendor and Requestor are existing on routing table
        if len(tmp_approvers) < 2:
            message = {
                'code': 400,
                'status': 'failed',
                'message': 'Please make sure to add an Approver, Vendor and Requestor into routing table',
            }
            return Response(message,
                            status=status.HTTP_400_BAD_REQUEST)
        else:
            result = validation_existing_vendor_requestor(tmp_approvers)

            if result is False:
                message = {
                    'code': 400,
                    'status': 'failed',
                    'message': 'Please add Vendor/Implementor and Requestor into routing table',
                }
                return Response(message,
                                status=status.HTTP_400_BAD_REQUEST)

        # Do not allow adding an approver for the same level
        validation_result = validation_approver_same_level(tmp_approvers)
        if validation_result is not None:
            message = {
                'code': 400,
                'status': 'failed',
                'message': validation_result + ' is already exist for the same level of approval.',
            }
            return Response(message,
                            status=status.HTTP_400_BAD_REQUEST)

        return function(self, request, *args, **kwargs)
    return wrapper


def FormValidation(function):
    @wraps(function)
    def wrapper(self, request, *args, **kwargs):
        form_header = request.data

        # restrict superuser department
        if (form_header['requested_by_department'] == 'DEPARTMENT-20190923-0000001' or
                form_header['requested_to_department'] == 'DEPARTMENT-20190923-0000001'):
            message = {
                'code': 400,
                'status': 'failed',
                'message': 'Superuser department cannot be selected',
            }
            return Response(message,
                            status=status.HTTP_400_BAD_REQUEST)
        
        frm_approvers = form_header['frm_approvers']
        
        # Check if Vendor and Requestor are existing on routing table
        if len(frm_approvers) < 2:
            message = {
                'code': 400,
                'status': 'failed',
                'message': 'Please make sure to add an Approver, Vendor and Requestor into routing table',
            }
            return Response(message,
                            status=status.HTTP_400_BAD_REQUEST)
        else:
            result = validation_existing_vendor_requestor(frm_approvers)

            if result is False:
                message = {
                    'code': 400,
                    'status': 'failed',
                    'message': 'Please add Vendor/Implementor and Requestor into routing table',
                }
                return Response(message,
                                status=status.HTTP_400_BAD_REQUEST)

        # Do not allow adding an approver for the same level
        validation_result = validation_approver_same_level(frm_approvers)            
        if validation_result is not None:
            message = {
                'code': 400,
                'status': 'failed',
                'message': validation_result + ' is already exist for the same level of approval.',
            }
            return Response(message,
                            status=status.HTTP_400_BAD_REQUEST)
        
        # Restrict a requestor to submit a CR without atleast 1 approver
        counter = validation_existing_approver(frm_approvers)
        if form_header['status'].lower() == 'pending' and counter == 0:
            message = {
                'code': 400,
                'status': 'failed',
                'message': 'Please select at least 1 approver before submitting this request.',
            }
            return Response(message, status=status.HTTP_400_BAD_REQUEST)

        return function(self, request, *args, **kwargs)
    return wrapper
