from rest_framework import viewsets, status
from rest_framework.response import Response
from django.forms.models import model_to_dict
from rest_framework.filters import SearchFilter, OrderingFilter
from django_filters import rest_framework as filters
from app.entities.models import Department, AllowedCompany
from app.applicationlayer.utils import (
    CustomPagination, status_message_response
)

from django_filters.rest_framework import DjangoFilterBackend
from app.applicationlayer.master.department import serializer
from app.applicationlayer.cms.master.form.department.table_filters import (
    ChangeRequestDepartmentFilterSet
)
from app.helper.decorators import rms
from django.db.models import Q
from rest_framework.exceptions import ParseError


class ChangeRequestDepartmentFormViewSet(viewsets.ModelViewSet):
    queryset = Department.objects.all()
    serializer_class = serializer.AdminDepartmentSerializer
    pagination_class = CustomPagination
    lookup_field = 'code'
    filter_backends = (DjangoFilterBackend, SearchFilter, OrderingFilter)
    filterset_class = ChangeRequestDepartmentFilterSet
    ordering_fields = '__all__'
    search_fields = ('name', 'company__name', 'code')

    # @rms.department_list
    def list(self, request, *args, **kwargs):
        company = self.request.query_params['company_code']
        queryset = self.filter_queryset(self.get_queryset())
        allowed = AllowedCompany.objects.filter(
            Q(id_number=self.request.user.code) &
            Q(company_pivot=company) &
            Q(create_change_request_template=True)
        ).values('group_pivots')
        queryset = queryset.filter(code__in=allowed)
        page = self.paginate_queryset(queryset)

        if page is not None:
            serializer = self.get_serializer(page, many=True)

            message = status_message_response(
                200,
                'success',
                'list of Department found',
                serializer.data
            )
            return self.get_paginated_response(message)

        serializer = self.get_serializer(queryset, many=True)
        return Response(serializer.data)
