from rest_framework import serializers
from app.entities.models import User
from app.applicationlayer.utils import model_to_dict


class AdminAccountSerializer(serializers.ModelSerializer):

    def to_representation(self, instance):
        ret = super().to_representation(instance)
        ret['department'] = model_to_dict(instance.department)
        ret['company'] = model_to_dict(instance.department.company)
        application = instance.application.values()
        ret['application'] = application

        return ret

    class Meta:
        model = User
        # fields = '__all__'
        read_only_fields = (
            'created', 'createdby', 'modified', 'modifiedby', 'code',
        )
        exclude = ('password',)
