import copy
import threading
import pandas as pd
import csv
import io, os
from app.entities import enums
from django.db import transaction
from app.helper import decorators
from django.db import IntegrityError
from app.helper.email_service import sender
from rest_framework import status, viewsets
from rest_framework.response import Response
from app.applicationlayer.management.batchupload.serializer import (
    ExtractTransformLoadSerializer,
    UserHistorySerializer
)
from app.entities.models import (
    User, Application, ExtractTransformLoad,
    AllowedCompany, Company, Department, UserHistory
)
from app.applicationlayer.utils import (
    CustomPagination, status_message_response,
    main_threading
)
from rest_framework.exceptions import ParseError
from django.db.models import Q
from rest_framework.decorators import action
from django.contrib.auth.hashers import make_password
from app.entities import enums


class BatchUploadViewSet(viewsets.ModelViewSet):
    queryset = ExtractTransformLoad.objects.all()
    serializer_class = ExtractTransformLoadSerializer
    pagination_class = CustomPagination
    lookup_field = 'code'


    def list(self, request, *args, **kwargs):
        logged_user = request.user.username
        queryset = self.get_queryset().filter(createdby=logged_user)

        page = self.paginate_queryset(queryset)

        if page is not None:
            serializer = self.get_serializer(page, many=True)

            message = status_message_response(
                200,
                'success',
                'list of Users found',
                serializer.data
            )

            return self.get_paginated_response(message)

        serializer = self.get_serializer(queryset, many=True)

        return Response(
            serializer.data,
            status=status.HTTP_200_OK
        )

    @action(
        detail=True, methods=['get'],
        url_path='users', name='list of batch upload users'
    )
    def Users(self, request, code=None):
        self.serializer_class = UserHistorySerializer
        queryset = UserHistory.objects.filter(file_name=code)
        page = self.paginate_queryset(queryset)

        serializer = self.get_serializer(page, many=True)
        message = status_message_response(
            200,
            'success',
            'List of Change Request Form found',
            serializer.data
        )

        return self.get_paginated_response(message)

    # @decorators.error_safe
    @transaction.atomic
    def create(self, request, *args, **kwargs):
        csv_file = request.FILES['file']
        df = pd.read_csv(csv_file, sep=',', skiprows=0)
        logged_user_type = request.user.user_type
        logged_user_company = request.user.department.company.name
        logged_user_department = request.user.department.name
        logged_user_email = request.user.email
        email_users = []
        etl = ExtractTransformLoad.objects.create(
            file_name=str(csv_file),
            model_type=enums.GenerateCode.USER.value
        )
        etl2 = ExtractTransformLoad.objects.get(id=etl.id)

        for data, keys in df.iterrows():
            try:
                user_department = Department.objects.filter(
                    Q(name__icontains=keys['department']) &
                    Q(company__name__icontains=logged_user_company)
                ).first()
                if logged_user_type == 'CUA':
                    user_department = Department.objects.filter(
                        Q(name__icontains=keys['department']) &
                        Q(company__name__icontains=logged_user_company)
                    ).first()
                if user_department == None:
                    msg = f"company is not the same with the logged user at row {data + 2}"
                    return Response(
                        {"message": msg},
                        status=status.HTTP_400_BAD_REQUEST
                    )
                elif logged_user_type == 'DUA':
                    user_department = Department.objects.get(
                        name__icontains=logged_user_department
                    )
                elif logged_user_type == 'USR':
                    return Response(
                            {"message": "Logged User is not allowed"},
                            status=status.HTTP_400_BAD_REQUEST
                        )
                else:
                    user_department = Department.objects.get(
                        name__icontains=keys['department']
                    )

                default_app = Application.objects.filter(
                    excel_code=keys['default_app']
                ).first()

                enums_super = enums.UserTypeEnum.SUPER_USER.value
                enums_OUA = enums.UserTypeEnum.OVERALL_USER_ADMIN.value
                enums_company = enums.UserTypeEnum.COMPANY_USER_ADMIN.value
                enums_department = enums.UserTypeEnum.DEPARTMENT_USER_ADMIN.value
                enums_user = enums.UserTypeEnum.USER.value

                if keys['user_type'].lower() == 'super user' and logged_user_type == enums_super:
                    user_type = enums.UserTypeEnum.SUPER_USER.value
                elif keys['user_type'].lower() == 'super user' and logged_user_type != enums_super:
                    return Response(
                        {"message": f"This user is not allowed to create super user. data error at row {data + 2}"},
                        status=status.HTTP_201_CREATED
                    )
                elif keys['user_type'].lower() == 'overall user admin':
                    user_type = enums.UserTypeEnum.OVERALL_USER_ADMIN.value
                elif keys['user_type'].lower() == 'company user admin':
                    user_type = enums.UserTypeEnum.COMPANY_USER_ADMIN.value
                elif keys['user_type'].lower() == 'department user admin':
                    user_type = enums.UserTypeEnum.DEPARTMENT_USER_ADMIN.value
                else:
                    user_type = enums.UserTypeEnum.USER.value
                users = {
                    "username": keys['username'],
                    "name": keys['name'],
                    "department": user_department,
                    "email": keys['email'],
                    "contact_no": keys['contact_no'],
                    "default_app": default_app,
                    "user_type": user_type
                }
                current_user = User.objects.create(
                    **users
                )

                password = User.objects.make_random_password(length=10)
                password_hash = make_password(password)
                current_user.password = password_hash
                current_user.save()

                app = Application.objects.filter(
                    excel_code__in=keys['application'].split(',')
                )

                update_user = current_user.application.set(app)

                for instance in keys['privilege'].split(';'):

                    privilege_list = instance.split(',')

                    this_company = Company.objects.filter(
                        name__icontains=privilege_list[0]
                    ).first()

                    this_department = Department.objects.filter(
                        name__icontains=privilege_list[1]
                    ).first()

                    if privilege_list[2] == 0:
                        privilege_list[2] = False
                    else:
                        privilege_list[2] = True

                    if privilege_list[3] == 0:
                        privilege_list[3] = False
                    else:
                        privilege_list[3] = True

                    if privilege_list[4] == 0:
                        privilege_list[4] = False
                    else:
                        privilege_list[4] = True

                    current_user = User.objects.get(id=current_user.id)
                    try:
                        privilege_object = {
                            "id_number": current_user,
                            "company_pivot": this_company,
                            "group_pivots": this_department,
                            "create_change_request": privilege_list[2],
                            "create_change_request_template": privilege_list[3],
                            "view_all_change_request": privilege_list[4],
                            "approve_cr": privilege_list[5]
                        }
                        AllowedCompany.objects.create(**privilege_object)
                    except IntegrityError as e:
                        return Response(
                            {"message": str(e)},
                            # {"message": f"Duplicate user privilege at row {data + 2}"},
                            status=status.HTTP_400_BAD_REQUEST
                        )

            except IntegrityError as e:
                return Response(
                    # {"message": f"Record already exist at row {data + 2}"},
                    {"message": str(e)},
                    status=status.HTTP_400_BAD_REQUEST
                )

            except KeyError as e:
                return Response(
                    {"message": "Missing column user_type"},
                    status=status.HTTP_400_BAD_REQUEST
                )

            del users['department']
            del users['contact_no']
            del users['default_app']
            del users['user_type']

            users['password'] = password

            UserHistory.objects.create(
                **users,
                file_name=etl2
            )
            users['admin'] = logged_user_email

        send_mail = UserHistory.objects.filter(sent=False).values(
            'name', 'username', 'email', 'password'
        )

        df = pd.DataFrame(send_mail)
        df.to_csv("users.csv", index=False)


        args = ["users.csv", logged_user_email]
        main_threading(args, sender.batch_email_admin)

        args = [send_mail, logged_user_email, etl.code]
        main_threading(args, sender.batch_email_users)

        return Response(
            {"message": "File already uploaded"},
            status=status.HTTP_201_CREATED
        )
