from rest_framework import viewsets, status
from rest_framework.response import Response
from app.entities.models import MasterAttachment
from app.applicationlayer.utils import (
    CustomPagination, status_message_response, log_save
)
# from django_filters.rest_framework import DjangoFilterBackend
from app.applicationlayer.download.batch_upload.serializer import (
    BatchUploadSerializer
)

import os
import configparser

config = configparser.ConfigParser()
config_file = os.path.join('./', 'env.ini')
config.read(config_file)


class BatchUploadFormatViewSet(viewsets.ModelViewSet):
    queryset = MasterAttachment.objects.filter(
        url__contains=config['SETTINGS']['BATCH_UPLOAD_FORMAT_FILENAME']
    )
    serializer_class = BatchUploadSerializer
