from rest_framework import viewsets, status
from rest_framework.views import APIView
from rest_framework.decorators import action
from rest_framework.response import Response
from django_filters.rest_framework import DjangoFilterBackend
from .models import APIService, APIEndpoint, Application
from .utils import (APIEndpointFilter, Helper)


class APIGatewayList(APIView):

    def _response(self, request, **kwargs):
        service = kwargs.get('service')
        endpoint_url = kwargs.get('endpoint_url')
        api = Helper().get_endpoint(request, service, endpoint_url)
        return Response(api['data'],
                        status=api['status_code'],
                        headers=api['headers'])

    def get(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)

    def post(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)

    def delete(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)


class APIGatewaySlugDetail(APIView):

    def _response(self, request, **kwargs):
        service = kwargs.get('service')
        endpoint_url = kwargs.get('endpoint_url')
        api = Helper().get_endpoint(
            request, service, f"{endpoint_url}/slug")
        return Response(api['data'],
                        status=api['status_code'],
                        headers=api['headers'])

    def get(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)

    def put(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)

    def patch(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)

    def delete(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)


class APIGatewaySlugModelDetail(APIView):

    def _response(self, request, **kwargs):
        service = kwargs.get('service')
        endpoint_url = kwargs.get('endpoint_url')
        api = Helper().get_endpoint(
            request, service, f"{endpoint_url}/slug/model")
        return Response(api['data'],
                        status=api['status_code'],
                        headers=api['headers'])

    def get(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)

    def post(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)

    def put(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)

    def patch(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)

    def delete(self, request, format=None, **kwargs):
        return self._response(request, **kwargs)
