from app.entities.models import AMSAssetStock
from rest_framework import serializers


class AMSAssetStockSerializer(serializers.ModelSerializer):
    
    def to_representation(self, instance):
        ret = super().to_representation(instance)
        ret['asset_group'] = instance.asset_group.name
        ret['asset'] = instance.asset.name
        ret['asset_type'] = instance.asset.asset_type.name
        return ret


    class Meta:
        model = AMSAssetStock
        fields = '__all__'