from rest_framework import serializers
from app.applicationlayer import serializers as app_serializers
from app.entities import models
from django.db.models import Q
from app.applicationlayer.management.module.serializer import ModuleSerializer
from app.entities import enums


# Used for Create and Update
class UserManagementSerializer(serializers.ModelSerializer):
    image = serializers.SerializerMethodField()

    class Meta:
        model = models.User
        exclude = ['password']

    def get_image(self, user):
        request = self.context.get('request')

        primayPic = user.user_images.filter(is_primary=True).first()
        if primayPic:
            print(primayPic.image.url)
            return request.build_absolute_uri(primayPic.image.url)
        else:
            return request.build_absolute_uri('/media/no-user.png')


# Used for Retrieve and List
class UserManagementRoleSerializer(serializers.ModelSerializer):
    permissions = serializers.SlugRelatedField(many=True,
                                               read_only=True,
                                               slug_field='code')

    class Meta:
        model = models.Role
        fields = '__all__'
        read_only_fields = ['createdby', 'modifiedby', 'created', 'modified']


# Used for Retrieve and List
class UserManagementRetreiveSerializer(serializers.ModelSerializer):
    image = serializers.SerializerMethodField()
    applications = serializers.SerializerMethodField()
    department = serializers.SerializerMethodField()
    company = serializers.SerializerMethodField()

    class Meta:
        model = models.User
        fields = (
            'id',
            'code', 'name',
            'username', 'contact_no',
            'image', 'company',
            'department', 'applications',
            'email', 'default_app',
            'user_type', 'is_active',
            'doa',
        )
        # exclude = ['password', 'application', 'groups', 'user_permissions']


    def get_department(self, user):
        data = {
            "id": user.department.id,
            "code": user.department.code,
            "name": user.department.name
        }
        return data

    def get_company(self, user):
        data = {
            "id": user.department.company.id,
            "code": user.department.company.code,
            "name": user.department.company.name
        }
        return data

    def get_image(self, user):
        request = self.context.get('request')

        primayPic = user.user_images.filter(is_primary=True).first()
        if primayPic:
            print(primayPic.image.url)
            return request.build_absolute_uri(primayPic.image.url)
        else:
            return request.build_absolute_uri('/media/no-user.png')

    def get_applications(self, user):
        # app = user.application.exclude(id=1)
        if user.user_type.upper() == enums.UserTypeEnum.USER.value:
            app = user.application.exclude(id=1)
        else:
            app = user.application.all()
        list_app = []
        initial_mod = {}
        rms = models.Application.objects.filter(id=1).values().first()

        for data in app:
            mod = data.modules.filter(~Q(name__icontains='header'))
            if user.user_type.upper() != enums.UserTypeEnum.USER.value:
                if user.user_type.upper() != enums.UserTypeEnum.USER.value:
                    user_module = models.Module.objects.filter(
                        name__icontains="user"
                    )
                    mod = mod.union(mod, user_module)
            mod = mod.order_by("parent", "sort_id")

            mod = ModuleSerializer(data=mod, many=True)
            mod.is_valid()

            app_body = {}
            app_body['app_code'] = data.code
            app_body['name'] = data.name
            app_body['modules'] = mod.data
            list_app.append(app_body)
        return list_app


class ChangePasswordSerializer(serializers.Serializer):
    old_password = serializers.CharField(max_length=100, required=True)
    new_password = serializers.CharField(max_length=100, required=True)
    new_password_confirm = serializers.CharField(max_length=100, required=True)

    class Meta:
        fields = '__all__'


# class UserSpecialPermissionSerializer(serializers.Serializer):
#     special_permissions = app_serializers.PermissionSerializer(required=True,
#                                                                many=True)

#     class Meta:
#         fields = '__all__'
