# Generated by Django 2.2 on 2020-03-16 18:13

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('entities', '0005_amsprivilege'),
    ]

    operations = [
        migrations.CreateModel(
            name='AMSAsset',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=255, unique=True)),
                ('name', models.CharField(max_length=255, unique=True)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('deleted_at', models.DateTimeField(blank=True, null=True)),
            ],
            options={
                'db_table': 'ams_assets',
                'ordering': ['-created'],
            },
        ),
        migrations.CreateModel(
            name='AMSAssetGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=255, unique=True)),
                ('name', models.CharField(max_length=255, unique=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('deleted_at', models.DateTimeField(blank=True, null=True)),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ams_asset_group_created_by', to=settings.AUTH_USER_MODEL, to_field='code')),
            ],
            options={
                'db_table': 'ams_asset_groups',
                'ordering': ['-created'],
            },
        ),
        migrations.CreateModel(
            name='AMSAssetStock',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=255, unique=True)),
                ('unique_identifier', models.CharField(max_length=255, unique=True)),
                ('status', models.CharField(choices=[('In-Store', 'In-Store'), ('Deployed', 'Deployed'), ('Returned', 'Returned'), ('Written Off', 'Written Off'), ('Faulty', 'Faulty')], default='In-Store', max_length=100)),
                ('acquisition_type', models.CharField(choices=[('Owned', 'Owned'), ('Loan', 'Loan')], default='Owned', max_length=100)),
                ('location', models.CharField(max_length=255)),
                ('dynamic_field', models.TextField(blank=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('deleted_at', models.DateTimeField(blank=True, null=True)),
                ('asset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='entities.AMSAsset', to_field='code')),
                ('asset_group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='entities.AMSAssetGroup', to_field='code')),
                ('manager', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ams_asset_manager', to=settings.AUTH_USER_MODEL, to_field='code')),
                ('user_client', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ams_asset_user_client', to=settings.AUTH_USER_MODEL, to_field='code')),
            ],
            options={
                'db_table': 'ams_asset_stocks',
                'ordering': ['-created'],
            },
        ),
        migrations.AlterField(
            model_name='amsprivilege',
            name='ams_user_type',
            field=models.CharField(choices=[('MANAGER', 'MANAGER'), ('USER_CLIENT', 'USER_CLIENT'), ('SUPPORT', 'SUPPORT'), ('VIEWER', 'VIEWER')], default='MANAGER', max_length=100),
        ),
        migrations.AlterField(
            model_name='extracttransformload',
            name='model_type',
            field=models.CharField(choices=[('APP', 'APP'), ('MODULE', 'MODULE'), ('COMPANY', 'COMPANY'), ('DEPARTMENT', 'DEPARTMENT'), ('USER', 'USER'), ('DELEGATION', 'DELEGATION'), ('NOTIF', 'NOTIF'), ('TMP', 'TMP'), ('TMPAPR', 'TMPAPR'), ('TMPSTK', 'TMPSTK'), ('TMPATCH', 'TMPATCH'), ('TMPDETAIL', 'TMPDETAIL'), ('FRM', 'FRM'), ('FRMAPR', 'FRMAPR'), ('FRMSTK', 'FRMSTK'), ('FRMATCH', 'FRMATCH'), ('FRMDETAIL', 'FRMDETAIL'), ('ETL', 'ETL'), ('CMSSET', 'CMSSET'), ('ASSTTYPE', 'ASSTTYPE'), ('ASST', 'ASST'), ('ASSTSTOCK', 'ASSTSTOCK'), ('ASSTGRP', 'ASSTGRP'), ('ASSTSTOCKSUP', 'ASSTSTOCKSUP'), ('RPTTYPE', 'RPTTYPE'), ('RPT', 'RPT'), ('FRMASSET', 'FRMASSET')], default='USER', max_length=100),
        ),
        migrations.CreateModel(
            name='ChangeRequestFormAssets',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=255, unique=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('deleted_at', models.DateTimeField(blank=True, null=True)),
                ('asset_stock', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='entities.AMSAssetStock', to_field='code')),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='cms_form_assets_created_by', to=settings.AUTH_USER_MODEL, to_field='code')),
                ('form_code', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='change_request_form_assets', to='entities.ChangeRequestFormHeader', to_field='form_code')),
            ],
            options={
                'db_table': 'change_request_form_assets',
                'ordering': ['-created'],
            },
        ),
        migrations.CreateModel(
            name='AMSReportType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=255, unique=True)),
                ('name', models.CharField(max_length=255, unique=True)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('dynamic_field', models.TextField(blank=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('deleted_at', models.DateTimeField(blank=True, null=True)),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ams_report_type_created_by', to=settings.AUTH_USER_MODEL, to_field='code')),
            ],
            options={
                'db_table': 'ams_report_types',
                'ordering': ['-created'],
            },
        ),
        migrations.CreateModel(
            name='AMSReport',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=255, unique=True)),
                ('name', models.CharField(max_length=255, unique=True)),
                ('dynamic_field', models.TextField(blank=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('deleted_at', models.DateTimeField(blank=True, null=True)),
                ('asset_stock', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='entities.AMSAssetStock', to_field='code')),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ams_report_created_by', to=settings.AUTH_USER_MODEL, to_field='code')),
                ('report_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='entities.AMSReportType', to_field='code')),
            ],
            options={
                'db_table': 'ams_reports',
                'ordering': ['-created'],
            },
        ),
        migrations.CreateModel(
            name='AMSAuditTrail',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=255, unique=True)),
                ('name', models.CharField(max_length=255, unique=True)),
                ('description', models.CharField(blank=True, max_length=255, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('deleted_at', models.DateTimeField(blank=True, null=True)),
                ('asset_stock', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='entities.AMSAssetStock', to_field='code')),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ams_audit_trail_created_by', to=settings.AUTH_USER_MODEL, to_field='code')),
            ],
            options={
                'db_table': 'ams_audit_trail',
                'ordering': ['-created'],
            },
        ),
        migrations.CreateModel(
            name='AMSAssetType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=255, unique=True)),
                ('name', models.CharField(max_length=255, unique=True)),
                ('dynamic_field', models.TextField(blank=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('deleted_at', models.DateTimeField(blank=True, null=True)),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ams_asset_type_created_by', to=settings.AUTH_USER_MODEL, to_field='code')),
            ],
            options={
                'db_table': 'ams_asset_types',
                'ordering': ['-created'],
            },
        ),
        migrations.CreateModel(
            name='AMSAssetStockSupport',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=255, unique=True)),
                ('name', models.CharField(max_length=255, unique=True)),
                ('start_date', models.DateTimeField(blank=True, null=True)),
                ('end_date', models.DateTimeField(blank=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('deleted_at', models.DateTimeField(blank=True, null=True)),
                ('asset_stock', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='entities.AMSAssetStock', to_field='code')),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ams_asset_stock_created_by', to=settings.AUTH_USER_MODEL, to_field='code')),
            ],
            options={
                'db_table': 'ams_asset_stock_supports',
                'ordering': ['-created'],
            },
        ),
        migrations.AddField(
            model_name='amsasset',
            name='asset_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ams_asset_type', to='entities.AMSAssetType', to_field='code'),
        ),
        migrations.AddField(
            model_name='amsasset',
            name='created_by',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='ams_asset_created_by', to=settings.AUTH_USER_MODEL, to_field='code'),
        ),
    ]
