from app.entities import models
from rest_framework import serializers
from app.applicationlayer.utils import model_to_dict


class AssetGroupSerializer(serializers.ModelSerializer):

    def to_representation(self, instance):
        ret = super().to_representation(instance)
        ret['asset_type_count'] = 0
        ret['asset_count'] = 0
        ret['asset_stock_count'] = instance.ams_asset_to_assetgroup.count()
        
        return ret

    class Meta:
        model = models.AMSAssetGroup
        fields = '__all__'
        read_only_fields = ['created', 'created_by', 'code']