from app.entities import models
from rest_framework import serializers
from django.db.models import Q
from app.applicationlayer.cms.utils_cr import logged_user
from drf_writable_nested import WritableNestedModelSerializer


class ChangeRequestFormApproversSerializer(
    serializers.ModelSerializer
):
    # def to_representation(self, instance):
    #     ret = super().to_representation(instance)
    #     try:
    #         user = instance.user
            
    #         user_details = get_account_details(user)
    #         name = user_details['name']
    #         group = user_details['groups'][0]['name']
    #         company = user_details['groups'][0]['company__name']

    #         ret['name'] = name
    #         ret['department'] = group
    #         ret['company'] = company
    #         return ret

    #     except Exception as e:
    #         ret['name'] = "none"
    #         ret['department'] = "none"
    #         ret['company'] = "none"
    #         return ret

    class Meta:
        model = models.ChangeRequestFormApprovers
        fields = '__all__'
        read_only_fields = ['created', 'archived_at', 'code']


class ChangeRequestFormStakeHoldersSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestFormStakeHolders
        fields = '__all__'
        read_only_fields = ['created', 'archived_at', 'code']


class ChangeRequestFormAttachmentsSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestFormAttachments
        fields = '__all__'
        read_only_fields = ['created', 'archived_at', 'code']


class ChangeRequestFormDetailsSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestFormDetails
        fields = '__all__'
        read_only_fields = ['created', 'archived_at', 'code']


class ChangeRequestFormHeaderSerializer(
    serializers.ModelSerializer
):
    frm_approvers = ChangeRequestFormApproversSerializer(
        many=True, required=False)
    frm_stakes = ChangeRequestFormStakeHoldersSerializer(
        many=True, required=False)
    frm_attachments = ChangeRequestFormAttachmentsSerializer(
        many=True, required=False)
    frm_details = ChangeRequestFormDetailsSerializer(
        many=True, required=False)

    def to_representation(self, instance):
        ret = super().to_representation(instance)
        try:
            # id_number = self.context.get('request').META.get('user')
            
            id_number = "USER-20190909-0000005"
            current_level = models.ChangeRequestFormApprovers.objects.filter(
                Q(form_code=ret['form_code']) &
                Q(archived_at=None) &
                (Q(action='') | Q(action=None))
            ).order_by('level')

            if current_level.first()['user'] == id_number:
                if instance.status.lower() == 'rejected':
                    approver = 'No'
                elif instance.status.lower() == 'cancelled':
                    approver = 'No'
                elif instance.status.lower() == 'closed':
                    approver = 'No'
                else:
                    approver = 'Yes'
            else:
                approver = 'No'
            ret['action'] = approver
            return ret
        except Exception as e:
            ret['action'] = "No"
            return ret

    class Meta:
        model = models.ChangeRequestFormHeader
        fields = '__all__'
        read_only_fields = ['created', 'archived_at', 'form_code']
