import copy
from app.entities import enums
from django.db import transaction
from app.helper.decorators import rms, error_safe
from rest_framework import viewsets, status
from rest_framework.response import Response
from django.forms.models import model_to_dict
from rest_framework.filters import SearchFilter, OrderingFilter
from django_filters import rest_framework as filters
from django.contrib.auth.hashers import make_password
from app.entities.models import User, EntityLog
from app.applicationlayer.utils import (
    CustomPagination, status_message_response, log_save
)
from django_filters.rest_framework import DjangoFilterBackend
from app.applicationlayer.management.account import serializer
from app.applicationlayer.management.account.table_filters import UserFilterSet
from rest_framework.decorators import action
from app.helper import decorators
from django.contrib.auth import authenticate
from app.helper.email_service import sender
import threading


class UserViewSet(viewsets.ModelViewSet):
    queryset = User.objects.all()
    serializer_class = serializer.UserSerializer
    pagination_class = CustomPagination
    filter_backends = (DjangoFilterBackend, SearchFilter, OrderingFilter)
    filterset_class = UserFilterSet
    ordering_fields = '__all__'
    search_fields = ('name',)

    # @check.user_type
    @rms.user_create
    @transaction.atomic
    def create(self, request, *args, **kwargs):
        serializer = self.get_serializer(data=request.data)
        serializer.is_valid(raise_exception=True)
        self.perform_create(serializer)
        password = User.objects.make_random_password(length=10)
        password_hash = make_password(password)
        User.objects.filter(
            id=serializer.data['id']
        ).update(password=password_hash)
        message = status_message_response(
            201, 'success',
            'New Users created', serializer.data
        )
        args = [request.data['name'], request.data['username'], password, request.user.email]
        t1 = threading.Thread(target=sender.account_created, args=(args,))
        t1.start()

        return Response(
            message
        )

    def list(self, request, *args, **kwargs):
        queryset = self.filter_queryset(self.get_queryset())
        page = self.paginate_queryset(queryset)

        if page is not None:
            serializer = self.get_serializer(page, many=True)

            message = status_message_response(
                200,
                'success',
                'list of Users found',
                serializer.data
            )
            return self.get_paginated_response(message)

        serializer = self.get_serializer(queryset, many=True)
        return Response(serializer.data)


    @error_safe
    @transaction.atomic
    def destroy(self, request, *args, **kwargs):

        instance = self.get_object()
        new_instance = model_to_dict(instance)
        self.perform_destroy(instance)

        log_save(
            enums.LogEnum.DELETED.value,
            enums.LogEntitiesEnum.USER.value,
            new_instance['id'],
            new_instance,
            ''
        )

        return Response(status=status.HTTP_204_NO_CONTENT)

    @transaction.atomic
    def update(self, request, *args, **kwargs):

        partial = kwargs.pop('partial', False)
        instance = self.get_object()
        serializer = self.get_serializer(instance, data=request.data, partial=partial)
        serializer.is_valid(raise_exception=True)

        old_instance = model_to_dict(instance)
        self.perform_update(serializer)
        new_instance = serializer.data

        log_save(
            enums.LogEnum.UPDATE.value,
            enums.LogEntitiesEnum.USER.value,
            new_instance['id'],
            old_instance,
            new_instance
        )

        return Response(serializer.data)


    # @action(detail=True,
    #         methods=['put'],
    #         url_path='upload-profile-picture',
    #         name="Uploads Profile Picture of User")
    # @decorators.error_safe
    # @transaction.atomic
    # def UploadProfilePicture(self, request, pk=None):
    #     existingUser = models.User.objects.filter(id=pk).first()
    #     if existingUser:

    #         eximages = models.UserImage.objects.filter(user_id=pk)

    #         if (eximages):
    #             for item in eximages:
    #                 item.delete()
    #                 # DELETE FROM PHYSICAL
    #                 FileHelper.DeleteFile(path=item.image.path)

    #         self.serializer_class = app_serializers.UserImageSerializer

    #         serializer = self.get_serializer(data=request.data)
    #         serializer.is_valid(raise_exception=True)
    #         self.perform_create(serializer)
    #         headers = self.get_success_headers(serializer.data)

    #         return Response(serializer.data,
    #                         status=status.HTTP_201_CREATED,
    #                         headers=headers)
    #     else:
    #         raise Exception('User not found')
    #     return Response(data={"detail": "Success"})

    # @action(detail=True,
    #         methods=['put'],
    #         url_path='reset-password',
    #         name="Reset Password of User")
    # @decorators.error_safe
    # @transaction.atomic
    # def ResetPassword(self, request, pk=None):
    #     existingUser = models.User.objects.filter(id=pk).first()
    #     if existingUser:
    #         existingUser.set_password(settings.USER_DEFAULT_PASSWORD)

    #         fromObj = copy.copy(existingUser)
    #         existingUser.save()
    #         toObj = copy.copy(existingUser)
    #         log_save.log_save(
    #             enums.LogEnum.UPDATE.value,
    #             enums.LogEntitiesEnum.ROBOT.value,
    #             model_to_dict(fromObj),
    #             model_to_dict(toObj))
    #     else:
    #         raise Exception('User not found')
    #     return Response(data={"detail": "Success"})

    @action(detail=True,
            methods=['put'],
            url_path='change-password',
            name="Change Password of User")
    @decorators.error_safe
    @transaction.atomic
    def ChangePassword(self, request, pk=None):
        self.serializer_class = serializer.ChangePasswordSerializer

        data = self.get_serializer(data=request.data)
        if data.is_valid():

            form = copy.deepcopy(data.validated_data)

            if form['new_password'] != form['new_password_confirm']:
                raise Exception('Passwords must match')

            existingUser = User.objects.filter(id=pk).first()
            if existingUser:
                user = authenticate(
                    username=existingUser.username,
                    password=form['old_password'])
                if user:
                    existingUser.set_password(form['new_password_confirm'])
                    # password = make_password(request.data['password'])

                    fromObj = copy.copy(existingUser)
                    existingUser.save()
                    toObj = copy.copy(existingUser)

                    # log_save.log_save(
                    #     enums.LogEnum.UPDATE.value,
                    #     enums.LogEntitiesEnum.ROBOT.value,
                    #     model_to_dict(fromObj),
                    #     model_to_dict(toObj))

                    return Response(data={"detail": "Success"},
                                    status=200)
                else:
                    raise Exception("Invalid Old Password")
            else:
                raise Exception('User not found')
        else:
            serializer.is_valid(raise_exception=True)

        return Response(data={"detail": "Error"}, status=500)
