from app.entities import models
from rest_framework import viewsets, status
from rest_framework.response import Response
from django_filters import rest_framework as filters
from django_filters.rest_framework import DjangoFilterBackend
from rest_framework.filters import SearchFilter, OrderingFilter
from app.applicationlayer.cms.form.approver.table_filters import ApproverFilter
from app.applicationlayer.cms.form.approver import serializers
from app.applicationlayer.utils import (
    CustomPagination, status_message_response
)


class ChangeRequestFormApproversViewset(viewsets.ModelViewSet):

    queryset = models.ChangeRequestFormApprovers.objects.all().order_by('level')
    serializer_class = serializers.ChangeRequestFormApproversSerializer
    pagination_class = CustomPagination
    lookup_field = 'code'
    filter_backends = (DjangoFilterBackend, SearchFilter, OrderingFilter)
    filterset_class = ApproverFilter
    ordering_fields = '__all__'
    search_fields = (
        'name', 'code',
        'department__company__name',
        'department__name',
        'email', 'contact_no'
    )
    
    def list(self, request, *args, **kwargs):

        queryset = self.filter_queryset(self.get_queryset())

        page = self.paginate_queryset(queryset)

        if page is not None:
            serializer = self.get_serializer(page, many=True)

            message = status_message_response(
                200,
                'success',
                'List of Form Approvers found',
                serializer.data
            )

            return self.get_paginated_response(message)

        serializer = self.get_serializer(self.queryset, many=True)

        return Response(
            serializer.data,
            status=status.HTTP_200_OK
        )
    
    def retrieve(self, request, *args, **kwargs):
        instance = self.get_object()
        serializer = self.get_serializer(instance)
        return Response(serializer.data)