from .base import *
import configparser

DEBUG = True

config = configparser.ConfigParser()
config_file = os.path.join(BASE_DIR, 'env.ini')
config.read(config_file)

DATABASES = {
    'default': {
        'ENGINE': config['LOCAL']['DATABASE_ENGINE'],
        'NAME': config['LOCAL']['DATABASE_NAME'],
        'USER': config['LOCAL']['DATABASE_USER'],
        'PASSWORD': config['LOCAL']['DATABASE_PASSWORD'],
        'HOST': config['LOCAL']['DATABASE_HOST'],
        'PORT': config['LOCAL']['DATABASE_PORT'],
    }
}

# ****************
# PROGRAM SETTINGS
# ****************
SESSION_TIMEOUT = config['LOCAL']['SESSION_TIMEOUT']
FRONT_END_URL = config['LOCAL']['FRONT_END_URL']
AUTH_ACCESSS_TOKEN_TIMEOUT = config['LOCAL']['AUTH_ACCESSS_TOKEN_TIMEOUT']
USER_DEFAULT_PASSWORD = config['LOCAL']['USER_DEFAULT_PASSWORD']
REALTIMESERVER_IP = config['NOTIFICATION']['REALTIMESERVER_IP']

# Notification Messages
APPROVER_MESSAGE = config['NOTIFICATION_EMAIL']['APPROVER_MESSAGE']
REQUESTOR_MESSAGE = config['NOTIFICATION_EMAIL']['REQUESTOR_MESSAGE']
REQUESTOR_REJECT_MESSAGE = config['NOTIFICATION_EMAIL']['REQUESTOR_REJECT_MESSAGE']
VENDOR_ACKNOWLEDGE_MESSAGE = config['NOTIFICATION_EMAIL']['VENDOR_ACKNOWLEDGE_MESSAGE']
REQUESTOR_ACKNOWLEDGE_MESSAGE = config['NOTIFICATION_EMAIL']['REQUESTOR_ACKNOWLEDGE_MESSAGE']
REQUESTOR_COMPLETION_MESSAGE = config['NOTIFICATION_EMAIL']['REQUESTOR_COMPLETION_MESSAGE']
VENDOR_ACCEPTANCE_MESSAGE = config['NOTIFICATION_EMAIL']['VENDOR_ACCEPTANCE_MESSAGE']
VENDOR_REJECT_MESSAGE = config['NOTIFICATION_EMAIL']['VENDOR_REJECT_MESSAGE']

#ADMIN PROFILE
CATCH_EMAIL = config['ADMIN']['CATCH_EMAIL']
