from .base import *
import configparser

DEBUG = True

ALLOWED_HOSTS = ['*']

config = configparser.ConfigParser()
config_file = os.path.join('./', 'env.ini')
config.read(config_file)

CHANNEL_LAYERS = {
    'default': {
        'BACKEND': 'channels_redis.core.RedisChannelLayer',
        'CONFIG': {
            "hosts": [('172.17.0.1', 6379)],
        },
    },
}

DATABASES = {
    'default': {
        'ENGINE': config['staging']['DATABASE_ENGINE'],
        'NAME': config['staging']['DATABASE_NAME'],
        'USER': config['staging']['DATABASE_USER'],
        'PASSWORD': config['staging']['DATABASE_PASSWORD'],
        'HOST': config['staging']['DATABASE_HOST'],
        'PORT': config['staging']['DATABASE_PORT'],
    }
}

# ****************
# PROGRAM SETTINGS
# ****************
SESSION_TIMEOUT = config['staging']['SESSION_TIMEOUT']
FRONT_END_URL = config['staging']['FRONT_END_URL']
AUTH_ACCESSS_TOKEN_TIMEOUT = config['staging']['AUTH_ACCESSS_TOKEN_TIMEOUT']
USER_DEFAULT_PASSWORD = config['staging']['USER_DEFAULT_PASSWORD']
REALTIMESERVER_IP = config['staging']['REALTIMESERVER_IP']

# Notification Messages
APPROVER_MESSAGE = config['NOTIFICATION_EMAIL']['APPROVER_MESSAGE']
REQUESTOR_MESSAGE = config['NOTIFICATION_EMAIL']['REQUESTOR_MESSAGE']
REQUESTOR_REJECT_MESSAGE = config['NOTIFICATION_EMAIL']['REQUESTOR_REJECT_MESSAGE']
VENDOR_ACKNOWLEDGE_MESSAGE = config['NOTIFICATION_EMAIL']['VENDOR_ACKNOWLEDGE_MESSAGE']
REQUESTOR_ACKNOWLEDGE_MESSAGE = config['NOTIFICATION_EMAIL']['REQUESTOR_ACKNOWLEDGE_MESSAGE']
REQUESTOR_COMPLETION_MESSAGE = config['NOTIFICATION_EMAIL']['REQUESTOR_COMPLETION_MESSAGE']
VENDOR_ACCEPTANCE_MESSAGE = config['NOTIFICATION_EMAIL']['VENDOR_ACCEPTANCE_MESSAGE']
VENDOR_REJECT_MESSAGE = config['NOTIFICATION_EMAIL']['VENDOR_REJECT_MESSAGE']

#ADMIN PROFILE
CATCH_EMAIL = config['staging']['CATCH_EMAIL']

CR_FRONT_LINK = config['staging']['CR_LINK']
