from app.entities import models
from rest_framework import serializers
from django.db.models import Q
from django.conf import settings
from django.forms.models import model_to_dict
from drf_writable_nested import WritableNestedModelSerializer
from app.applicationlayer.cms.utils_cr import (get_account_details,
                                               get_dept_details,
                                               get_companies_details)


from app.applicationlayer.cms.template.approver.serializers import ChangeRequestTemplateApproversSerializer
from app.applicationlayer.cms.template.stakeholder.serializers import ChangeRequestTemplateStakeHoldersSerializer
from app.applicationlayer.cms.template.attachment.serializers import ChangeRequestTemplateAttachmentsSerializer
from app.applicationlayer.cms.template.details.serializers import ChangeRequestTemplateDetailsSerializer

from django.conf import settings


class ChangeRequestTemplatesSerializer(
    serializers.ModelSerializer
):
    tmp_approvers = ChangeRequestTemplateApproversSerializer(
        many=True, read_only=True)
    tmp_stakes = ChangeRequestTemplateStakeHoldersSerializer(
        many=True, read_only=True)
    tmp_attachments = ChangeRequestTemplateAttachmentsSerializer(
        many=True, read_only=True)
    tmp_details = ChangeRequestTemplateDetailsSerializer(
        many=True, read_only=True)

    def to_representation(self, instance):
        ret = super().to_representation(instance)
        try:
            
            requested_to_user_object = {
                "id": instance.requested_to_user.id,
                "name": instance.requested_to_user.name,
                "username": instance.requested_to_user.username,
                "code": instance.requested_to_user.code,
                "email": instance.requested_to_user.email,
                "contact_no": instance.requested_to_user.contact_no
            }

            ret['requested_to_company_object'] = model_to_dict(instance.requested_to_company)
            ret['requested_to_department_object'] = model_to_dict(instance.requested_to_department)
            ret['requested_to_user_object'] = requested_to_user_object

            ret['company'] = instance.requested_to_company.name
            ret['department'] = instance.requested_to_department.name
            ret['point_of_contact'] = instance.requested_to_user.name
            ret['created_by'] = instance.created_by_user.name

            return ret
        except Exception as e:

            ret['company'] = "none"
            ret['department'] = "none"
            ret['point_of_contact'] = "none"
            ret['created_by'] = "none"

            return ret

    class Meta:
        model = models.ChangeRequestTemplateHeader
        # fields = '__all__'
        fields = ('template_no', 'requested_to_template_name',
                  'requested_to_objective', 'requested_to_target_date',
                  'requested_to_priority', 'description', 'created',
                  'requested_to_template_id', 'requested_to_company',
                  'requested_to_department', 'requested_to_user',
                  'created_by_user', 'created_by_department',
                  'tmp_approvers', 'tmp_stakes', 'tmp_attachments',
                  'tmp_details')

        read_only_fields = ['created', 'template_no']


class ChangeRequestTemplatesSerializerList(
    serializers.ModelSerializer
):

    def to_representation(self, instance):
        ret = super().to_representation(instance)
        try:

            requested_to_user_object = {
                "id": instance.requested_to_user.id,
                "name": instance.requested_to_user.name,
                "username": instance.requested_to_user.username,
                "code": instance.requested_to_user.code,
                "email": instance.requested_to_user.email,
                "contact_no": instance.requested_to_user.contact_no
            }

            ret['requested_to_company_object'] = model_to_dict(instance.requested_to_company)
            ret['requested_to_department_object'] = model_to_dict(instance.requested_to_department)
            ret['requested_to_user_object'] = requested_to_user_object
            
            ret['company'] = instance.requested_to_company.name
            ret['department'] = instance.requested_to_department.name
            ret['point_of_contact'] = instance.requested_to_user.name
            ret['created_by'] = instance.created_by_user.name

            return ret
        except Exception as e:
            ret['company'] = "none"
            ret['department'] = "none"
            ret['point_of_contact'] = "none"
            ret['created_by'] = "none"
            
            return ret

    class Meta:
        model = models.ChangeRequestTemplateHeader
        fields = '__all__'
        read_only_fields = ['created', 'template_no']