from django_filters import rest_framework as filters
from rest_framework.filters import SearchFilter, OrderingFilter
from app.entities.models import (
    Company, Department, AMSPrivilege
)
from rest_framework import viewsets
from app.applicationlayer.utils import (CustomPagination,
                                        status_message_response)
from django_filters.rest_framework import DjangoFilterBackend
from app.applicationlayer.ams.master.ams_department import serializer
from app.applicationlayer.ams.master.ams_department.table_filter import (
    AMSDepartmentFilterSet
)
from rest_framework.response import Response
from django.db.models import Q
from rest_framework.decorators import action


class AMSDepartmentFormViewSet(viewsets.ModelViewSet):
    queryset = Department.objects.all()
    serializer_class = serializer.AMSDepartmentSerializer
    pagination_class = CustomPagination
    filter_backends = (DjangoFilterBackend, SearchFilter, OrderingFilter)
    filterset_class = AMSDepartmentFilterSet
    ordering_fields = '__all__'
    search_fields = ('name',)
    http_method_names = ['get']

    def list(self, request, *args, **kwargs):

        queryset = self.filter_queryset(self.get_queryset())
        allowed = AMSPrivilege.objects.filter(
            Q(id_number=self.request.user.code)
        ).values('department')
        queryset = queryset.filter(code__in=allowed)
        page = self.paginate_queryset(queryset)

        if page is not None:
            serializer = self.get_serializer(page, many=True)

            message = status_message_response(
                200,
                'success',
                'list of Department found',
                serializer.data
            )
            return self.get_paginated_response(message)

        serializer = self.get_serializer(queryset, many=True)
        return Response(serializer.data)
