from app.entities import models
from rest_framework import serializers
from django.db.models import Q
from drf_writable_nested import WritableNestedModelSerializer
from app.applicationlayer.cms.utils_cr import (get_account_details,
                                               get_dept_details,
                                               get_companies_details)


class ChangeRequestFormApproversSerializer(
    serializers.ModelSerializer
):
    def to_representation(self, instance):
        ret = super().to_representation(instance)
        try:
            user = instance.user
            
            user_details = get_account_details(user.code)
            name = user_details.values_list('name', flat=True)[0]
            dept_code = user_details.values_list('department', flat=True)[0]
            department_details = get_dept_details(dept_code)
            department = department_details.values_list('name', flat=True)[0]
            comp_code = department_details.values_list('company', flat=True)[0]
            company_details = get_companies_details(comp_code)
            company = company_details.values_list('name', flat=True)[0]
            
            ret['name'] = name
            ret['department'] = department
            ret['company'] = company
            return ret
        
        except Exception as e:
            ret['name'] = "none"
            ret['department'] = "none"
            ret['company'] = "none"
            return ret

    class Meta:
        model = models.ChangeRequestFormApprovers
        fields = '__all__'
        read_only_fields = ['created', 'code']


class ChangeRequestFormStakeHoldersSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestFormStakeHolders
        fields = '__all__'
        read_only_fields = ['created', 'code']


class ChangeRequestFormAttachmentsSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestFormAttachments
        fields = '__all__'
        read_only_fields = ['created', 'code']


class ChangeRequestFormDetailsSerializer(
    serializers.ModelSerializer
):
    class Meta:
        model = models.ChangeRequestFormDetails
        fields = '__all__'
        read_only_fields = ['created', 'code']


class ChangeRequestFormHeaderSerializer(
    serializers.ModelSerializer
):
    frm_approvers = ChangeRequestFormApproversSerializer(
        many=True, read_only=True)
    # frm_stakes = ChangeRequestFormStakeHoldersSerializer(
    #     many=True, required=False)
    frm_stakes = ChangeRequestFormStakeHoldersSerializer(
        many=True, read_only=True)
    frm_attachments = ChangeRequestFormAttachmentsSerializer(
        many=True, read_only=True)
    frm_details = ChangeRequestFormDetailsSerializer(
        many=True, read_only=True)

    # def update(self, instance, validated_data):

        
        # Update the book instance
        
        # instance.requested_to_template_name = validated_data['requested_to_template_name']
        # instance.requested_to_objective = validated_data['requested_to_objective']
        # instance.requested_to_target_date = validated_data['requested_to_target_date']
        # instance.requested_to_priority = validated_data['requested_to_priority']
        # instance.description = validated_data['description']
        # instance.status = validated_data['status']
        # instance.company_desc = validated_data['company_desc']
        # instance.department_desc = validated_data['department_desc']
        # instance.requested_desc = validated_data['requested_desc']
        # instance.requested_to_template_id = validated_data['requested_to_template_id']
        # instance.requested_to_company = validated_data['requested_to_company']
        # instance.requested_to_department = validated_data['requested_to_department']
        # instance.requested_to_user = validated_data['requested_to_user']
        # instance.requested_by_user = validated_data['requested_by_user']
        # instance.requested_by_department = validated_data['requested_by_department']
        # instance.template_no = validated_data['template_no']
        # instance.save()

        # Delete any pages not included in the request
        # approvers_ids = [item.id for item in validated_data['frm_approvers']]

        # for i in validated_data['frm_approvers']:
        #     print(i)

        # print(approvers_ids)
        # for page in instance.frm_approvers:
        #     if page.id not in approvers_ids:
        #         page.delete()

        # # Create or update page instances that are in the request
        # for item in validated_data['pages']:
        #     page = Page(id=item['page_id'], text=item['text'], book=instance)
        #     page.save()

        # return instance

    # def update(self, instance, validated_data):
    #     frm_approvers = validated_data.pop('frm_approvers')
    #     instance.requested_to_template_name = validated_data.get("requested_to_template_name", instance.requested_to_template_name)
    #     instance.requested_to_objective = validated_data.get("requested_to_objective", instance.requested_to_objective)
    #     instance.requested_to_target_date = validated_data.get("requested_to_target_date", instance.requested_to_target_date)
    #     instance.requested_to_priority = validated_data.get("requested_to_priority", instance.requested_to_priority)
    #     instance.description = validated_data.get("description", instance.description)
    #     instance.status = validated_data.get("status", instance.status)
    #     instance.company_desc = validated_data.get("company_desc", instance.company_desc)
    #     instance.department_desc = validated_data.get("department_desc", instance.department_desc)
    #     instance.requested_desc = validated_data.get("requested_desc", instance.requested_desc)
    #     instance.requested_to_template_id = validated_data.get("requested_to_template_id", instance.requested_to_template_id)
    #     instance.requested_to_company = validated_data.get("requested_to_company", instance.requested_to_company)
    #     instance.requested_to_department = validated_data.get("requested_to_department", instance.requested_to_department)
    #     instance.requested_to_user = validated_data.get("requested_to_user", instance.requested_to_user)
    #     instance.requested_by_user = validated_data.get("requested_by_user", instance.requested_by_user)
    #     instance.requested_by_department = validated_data.get("requested_by_department", instance.requested_by_department)
    #     instance.template_no = validated_data.get("template_no", instance.template_no)
    #     instance.save()

    #     print(instance.form_code)
    #     keep_choices = []
    #     for choice in frm_approvers:
    #         if "id" in choice.keys():
    #             if models.ChangeRequestFormApprovers.objects.filter(id=choice["id"]).exists():
    #                 c = models.ChangeRequestFormApprovers.objects.get(id=choice["id"])
    #                 c.text = choice.get('text', c.text)
    #                 c.save()
    #                 keep_choices.append(c.id)
    #             else:
    #                 continue
    #         else:
    #             c = models.ChangeRequestFormApprovers.objects.create(**choice)
    #             keep_choices.append(c.id)

        # for choice in instance.frm_approvers:
        #     if choice.id not in keep_choices:
        #         choice.delete()

        # return instance
    
    def to_representation(self, instance):
        ret = super().to_representation(instance)
        try:
            user = self.context['request'].user
            
            id_number = user.code
            current_level = models.ChangeRequestFormApprovers.objects.filter(
                Q(form_code=ret['form_code'])
                (Q(action='') | Q(action=None))
            ).order_by('level')

            if current_level.first()['user'] == id_number:
                if instance.status.lower() == 'rejected':
                    approver = 'No'
                elif instance.status.lower() == 'cancelled':
                    approver = 'No'
                elif instance.status.lower() == 'closed':
                    approver = 'No'
                else:
                    approver = 'Yes'
            else:
                approver = 'No'
            ret['action'] = approver
            return ret
        except Exception as e:
            ret['action'] = "No"
            return ret

    class Meta:
        model = models.ChangeRequestFormHeader
        # fields = '__all__'
        fields = ('form_code', 'requested_to_template_name', 'requested_to_objective',
                  'requested_to_target_date', 'requested_to_priority',
                  'description', 'created', 'cancel_date', 'status',
                  'company_desc', 'department_desc', 'requested_desc',
                  'requested_to_template_id', 'requested_to_company',
                  'requested_to_department', 'requested_to_user',
                  'requested_by_user', 'requested_by_department',
                  'template_no', 'frm_approvers', 'frm_stakes',
                  'frm_attachments', 'frm_details')

        read_only_fields = ['created', 'form_code']
