from django.urls import path, include
from rest_framework.routers import DefaultRouter
from api.viewsets.services import APIServiceViewSet
from api.viewsets.endpoints import APIEndpointViewSet
from api.viewsets.applications import (
    ApplicationViewSet, MainApplicationViewSet
)
from api.views import (
    APIGatewayList, APIGatewaySlugDetail, APIGatewaySlugModelDetail
)

router = DefaultRouter()
router.register(r'applications', ApplicationViewSet)
router.register(r'services', APIServiceViewSet)
router.register(r'endpoints', APIEndpointViewSet)
router.register(r'main-application', MainApplicationViewSet)

urlpatterns = [
    path('', include(router.urls)),
    path('<str:service>/<str:endpoint_url>/', APIGatewayList.as_view()),
    path('<str:service>/<str:endpoint_url>/<str:slug>/',
         APIGatewaySlugDetail.as_view()),
    path('<str:service>/<str:endpoint_url>/<str:slug>/<str:model>/',
         APIGatewaySlugModelDetail.as_view()),
]
