-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               10.3.13-MariaDB - mariadb.org binary distribution
-- Server OS:                    Win64
-- HeidiSQL Version:             10.1.0.5464
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


-- Dumping database structure for rms_db
CREATE DATABASE IF NOT EXISTS `rms_db` /*!40100 DEFAULT CHARACTER SET utf8 */;
USE `rms_db`;

-- Dumping structure for table rms_db.applications
CREATE TABLE IF NOT EXISTS `applications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.applications: ~3 rows (approximately)
DELETE FROM `applications`;
/*!40000 ALTER TABLE `applications` DISABLE KEYS */;
INSERT INTO `applications` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `code`, `name`) VALUES
	(1, '2019-09-09 15:33:32.000000', 'admin', '2019-09-09 15:33:34.000000', 'admin', 'app', 'Resource Management'),
	(2, '2019-09-09 15:38:19.470107', '', '2019-09-09 15:38:19.470107', 'superuser', 'APP-20190909-0000002', 'Change Management System'),
	(3, '2019-09-09 15:38:34.914003', '', '2019-09-09 15:38:34.914107', 'superuser', 'APP-20190909-0000003', 'Assets Management System');
/*!40000 ALTER TABLE `applications` ENABLE KEYS */;

-- Dumping structure for table rms_db.attachments
CREATE TABLE IF NOT EXISTS `attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.attachments: ~0 rows (approximately)
DELETE FROM `attachments`;
/*!40000 ALTER TABLE `attachments` DISABLE KEYS */;
/*!40000 ALTER TABLE `attachments` ENABLE KEYS */;

-- Dumping structure for table rms_db.authtoken_token
CREATE TABLE IF NOT EXISTS `authtoken_token` (
  `key` varchar(40) NOT NULL,
  `created` datetime(6) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`key`),
  UNIQUE KEY `user_id` (`user_id`),
  CONSTRAINT `authtoken_token_user_id_35299eff_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.authtoken_token: ~1 rows (approximately)
DELETE FROM `authtoken_token`;
/*!40000 ALTER TABLE `authtoken_token` DISABLE KEYS */;
INSERT INTO `authtoken_token` (`key`, `created`, `user_id`) VALUES
	('54272cd5f34ab29c52318041889a3b65dc8db6a2', '2019-09-16 10:40:03.878930', 5);
/*!40000 ALTER TABLE `authtoken_token` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_access_token
CREATE TABLE IF NOT EXISTS `auth_access_token` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(255) NOT NULL,
  `token` longtext NOT NULL,
  `passcode` varchar(255) NOT NULL,
  `timeout` int(11) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `auth_access_token_user_id_c480a680_fk_auth_user_id` (`user_id`),
  CONSTRAINT `auth_access_token_user_id_c480a680_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_access_token: ~0 rows (approximately)
DELETE FROM `auth_access_token`;
/*!40000 ALTER TABLE `auth_access_token` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_access_token` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_group
CREATE TABLE IF NOT EXISTS `auth_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_group: ~0 rows (approximately)
DELETE FROM `auth_group`;
/*!40000 ALTER TABLE `auth_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_group` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_group_permissions
CREATE TABLE IF NOT EXISTS `auth_group_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_group_permissions_group_id_permission_id_0cd325b0_uniq` (`group_id`,`permission_id`),
  KEY `auth_group_permissio_permission_id_84c5c92e_fk_auth_perm` (`permission_id`),
  CONSTRAINT `auth_group_permissio_permission_id_84c5c92e_fk_auth_perm` FOREIGN KEY (`permission_id`) REFERENCES `auth_permission` (`id`),
  CONSTRAINT `auth_group_permissions_group_id_b120cbf9_fk_auth_group_id` FOREIGN KEY (`group_id`) REFERENCES `auth_group` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_group_permissions: ~0 rows (approximately)
DELETE FROM `auth_group_permissions`;
/*!40000 ALTER TABLE `auth_group_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_group_permissions` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_permission
CREATE TABLE IF NOT EXISTS `auth_permission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `content_type_id` int(11) NOT NULL,
  `codename` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_permission_content_type_id_codename_01ab375a_uniq` (`content_type_id`,`codename`),
  CONSTRAINT `auth_permission_content_type_id_2f476e4b_fk_django_co` FOREIGN KEY (`content_type_id`) REFERENCES `django_content_type` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_permission: ~124 rows (approximately)
DELETE FROM `auth_permission`;
/*!40000 ALTER TABLE `auth_permission` DISABLE KEYS */;
INSERT INTO `auth_permission` (`id`, `name`, `content_type_id`, `codename`) VALUES
	(1, 'Can add log entry', 1, 'add_logentry'),
	(2, 'Can change log entry', 1, 'change_logentry'),
	(3, 'Can delete log entry', 1, 'delete_logentry'),
	(4, 'Can view log entry', 1, 'view_logentry'),
	(5, 'Can add permission', 2, 'add_permission'),
	(6, 'Can change permission', 2, 'change_permission'),
	(7, 'Can delete permission', 2, 'delete_permission'),
	(8, 'Can view permission', 2, 'view_permission'),
	(9, 'Can add group', 3, 'add_group'),
	(10, 'Can change group', 3, 'change_group'),
	(11, 'Can delete group', 3, 'delete_group'),
	(12, 'Can view group', 3, 'view_group'),
	(13, 'Can add content type', 4, 'add_contenttype'),
	(14, 'Can change content type', 4, 'change_contenttype'),
	(15, 'Can delete content type', 4, 'delete_contenttype'),
	(16, 'Can view content type', 4, 'view_contenttype'),
	(17, 'Can add session', 5, 'add_session'),
	(18, 'Can change session', 5, 'change_session'),
	(19, 'Can delete session', 5, 'delete_session'),
	(20, 'Can view session', 5, 'view_session'),
	(21, 'Can add Token', 6, 'add_token'),
	(22, 'Can change Token', 6, 'change_token'),
	(23, 'Can delete Token', 6, 'delete_token'),
	(24, 'Can view Token', 6, 'view_token'),
	(25, 'Can add user', 7, 'add_user'),
	(26, 'Can change user', 7, 'change_user'),
	(27, 'Can delete user', 7, 'delete_user'),
	(28, 'Can view user', 7, 'view_user'),
	(29, 'Can add application', 8, 'add_application'),
	(30, 'Can change application', 8, 'change_application'),
	(31, 'Can delete application', 8, 'delete_application'),
	(32, 'Can view application', 8, 'view_application'),
	(33, 'Can add attachment', 9, 'add_attachment'),
	(34, 'Can change attachment', 9, 'change_attachment'),
	(35, 'Can delete attachment', 9, 'delete_attachment'),
	(36, 'Can view attachment', 9, 'view_attachment'),
	(37, 'Can add change request form header', 10, 'add_changerequestformheader'),
	(38, 'Can change change request form header', 10, 'change_changerequestformheader'),
	(39, 'Can delete change request form header', 10, 'delete_changerequestformheader'),
	(40, 'Can view change request form header', 10, 'view_changerequestformheader'),
	(41, 'Can add change request history', 11, 'add_changerequesthistory'),
	(42, 'Can change change request history', 11, 'change_changerequesthistory'),
	(43, 'Can delete change request history', 11, 'delete_changerequesthistory'),
	(44, 'Can view change request history', 11, 'view_changerequesthistory'),
	(45, 'Can add change request template header', 12, 'add_changerequesttemplateheader'),
	(46, 'Can change change request template header', 12, 'change_changerequesttemplateheader'),
	(47, 'Can delete change request template header', 12, 'delete_changerequesttemplateheader'),
	(48, 'Can view change request template header', 12, 'view_changerequesttemplateheader'),
	(49, 'Can add company', 13, 'add_company'),
	(50, 'Can change company', 13, 'change_company'),
	(51, 'Can delete company', 13, 'delete_company'),
	(52, 'Can view company', 13, 'view_company'),
	(53, 'Can add entity log', 14, 'add_entitylog'),
	(54, 'Can change entity log', 14, 'change_entitylog'),
	(55, 'Can delete entity log', 14, 'delete_entitylog'),
	(56, 'Can view entity log', 14, 'view_entitylog'),
	(57, 'Can add permission', 15, 'add_permission'),
	(58, 'Can change permission', 15, 'change_permission'),
	(59, 'Can delete permission', 15, 'delete_permission'),
	(60, 'Can view permission', 15, 'view_permission'),
	(61, 'Can add role', 16, 'add_role'),
	(62, 'Can change role', 16, 'change_role'),
	(63, 'Can delete role', 16, 'delete_role'),
	(64, 'Can view role', 16, 'view_role'),
	(65, 'Can add status', 17, 'add_status'),
	(66, 'Can change status', 17, 'change_status'),
	(67, 'Can delete status', 17, 'delete_status'),
	(68, 'Can view status', 17, 'view_status'),
	(69, 'Can add user image', 18, 'add_userimage'),
	(70, 'Can change user image', 18, 'change_userimage'),
	(71, 'Can delete user image', 18, 'delete_userimage'),
	(72, 'Can view user image', 18, 'view_userimage'),
	(73, 'Can add role permission', 19, 'add_rolepermission'),
	(74, 'Can change role permission', 19, 'change_rolepermission'),
	(75, 'Can delete role permission', 19, 'delete_rolepermission'),
	(76, 'Can view role permission', 19, 'view_rolepermission'),
	(77, 'Can add notification', 20, 'add_notification'),
	(78, 'Can change notification', 20, 'change_notification'),
	(79, 'Can delete notification', 20, 'delete_notification'),
	(80, 'Can view notification', 20, 'view_notification'),
	(81, 'Can add module', 21, 'add_module'),
	(82, 'Can change module', 21, 'change_module'),
	(83, 'Can delete module', 21, 'delete_module'),
	(84, 'Can view module', 21, 'view_module'),
	(85, 'Can add department', 22, 'add_department'),
	(86, 'Can change department', 22, 'change_department'),
	(87, 'Can delete department', 22, 'delete_department'),
	(88, 'Can view department', 22, 'view_department'),
	(89, 'Can add change request template stake holders', 23, 'add_changerequesttemplatestakeholders'),
	(90, 'Can change change request template stake holders', 23, 'change_changerequesttemplatestakeholders'),
	(91, 'Can delete change request template stake holders', 23, 'delete_changerequesttemplatestakeholders'),
	(92, 'Can view change request template stake holders', 23, 'view_changerequesttemplatestakeholders'),
	(93, 'Can add change request template details', 24, 'add_changerequesttemplatedetails'),
	(94, 'Can change change request template details', 24, 'change_changerequesttemplatedetails'),
	(95, 'Can delete change request template details', 24, 'delete_changerequesttemplatedetails'),
	(96, 'Can view change request template details', 24, 'view_changerequesttemplatedetails'),
	(97, 'Can add change request template attachments', 25, 'add_changerequesttemplateattachments'),
	(98, 'Can change change request template attachments', 25, 'change_changerequesttemplateattachments'),
	(99, 'Can delete change request template attachments', 25, 'delete_changerequesttemplateattachments'),
	(100, 'Can view change request template attachments', 25, 'view_changerequesttemplateattachments'),
	(101, 'Can add change request template approvers', 26, 'add_changerequesttemplateapprovers'),
	(102, 'Can change change request template approvers', 26, 'change_changerequesttemplateapprovers'),
	(103, 'Can delete change request template approvers', 26, 'delete_changerequesttemplateapprovers'),
	(104, 'Can view change request template approvers', 26, 'view_changerequesttemplateapprovers'),
	(105, 'Can add change request form stake holders', 27, 'add_changerequestformstakeholders'),
	(106, 'Can change change request form stake holders', 27, 'change_changerequestformstakeholders'),
	(107, 'Can delete change request form stake holders', 27, 'delete_changerequestformstakeholders'),
	(108, 'Can view change request form stake holders', 27, 'view_changerequestformstakeholders'),
	(109, 'Can add change request form details', 28, 'add_changerequestformdetails'),
	(110, 'Can change change request form details', 28, 'change_changerequestformdetails'),
	(111, 'Can delete change request form details', 28, 'delete_changerequestformdetails'),
	(112, 'Can view change request form details', 28, 'view_changerequestformdetails'),
	(113, 'Can add change request form attachments', 29, 'add_changerequestformattachments'),
	(114, 'Can change change request form attachments', 29, 'change_changerequestformattachments'),
	(115, 'Can delete change request form attachments', 29, 'delete_changerequestformattachments'),
	(116, 'Can view change request form attachments', 29, 'view_changerequestformattachments'),
	(117, 'Can add change request form approvers', 30, 'add_changerequestformapprovers'),
	(118, 'Can change change request form approvers', 30, 'change_changerequestformapprovers'),
	(119, 'Can delete change request form approvers', 30, 'delete_changerequestformapprovers'),
	(120, 'Can view change request form approvers', 30, 'view_changerequestformapprovers'),
	(121, 'Can add auth token', 31, 'add_authtoken'),
	(122, 'Can change auth token', 31, 'change_authtoken'),
	(123, 'Can delete auth token', 31, 'delete_authtoken'),
	(124, 'Can view auth token', 31, 'view_authtoken');
/*!40000 ALTER TABLE `auth_permission` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user
CREATE TABLE IF NOT EXISTS `auth_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `last_login` datetime(6) DEFAULT NULL,
  `is_superuser` tinyint(1) NOT NULL,
  `first_name` varchar(30) NOT NULL,
  `last_name` varchar(150) NOT NULL,
  `is_staff` tinyint(1) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `date_joined` datetime(6) NOT NULL,
  `default_app` varchar(255) DEFAULT NULL,
  `user_type` varchar(100) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `username` varchar(255) NOT NULL,
  `password` varchar(255) DEFAULT NULL,
  `contact_no` varchar(255) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `department_id` int(11) NOT NULL,
  `doa_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `username` (`username`),
  KEY `auth_user_department_id_ff5fa3db_fk_departments_id` (`department_id`),
  KEY `auth_user_doa_id_5076b369_fk_auth_user_id` (`doa_id`),
  CONSTRAINT `auth_user_department_id_ff5fa3db_fk_departments_id` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`),
  CONSTRAINT `auth_user_doa_id_5076b369_fk_auth_user_id` FOREIGN KEY (`doa_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_user: ~5 rows (approximately)
DELETE FROM `auth_user`;
/*!40000 ALTER TABLE `auth_user` DISABLE KEYS */;
INSERT INTO `auth_user` (`id`, `last_login`, `is_superuser`, `first_name`, `last_name`, `is_staff`, `is_active`, `date_joined`, `default_app`, `user_type`, `code`, `name`, `username`, `password`, `contact_no`, `email`, `department_id`, `doa_id`) VALUES
	(5, NULL, 1, '', '', 1, 1, '2019-09-09 15:37:33.686243', NULL, 'SU', 'USER-20190909-0000005', 'xxx', 'superuser', 'pbkdf2_sha256$150000$XJ4yhC1Fcuxd$lPbvc4KrA1/jjKqQi8wPrWKSB+7g51HkqVq8wB/Eavg=', NULL, 'superuser@tirsolutions.com', 2, NULL),
	(6, NULL, 0, '', '', 0, 1, '2019-09-13 17:14:34.927269', 'RMS', 'OUA', 'USER-20190913-0000006', 'Gladys', 'gladys', 'pbkdf2_sha256$150000$l5iTq0MAmDpL$LCFoD73W7guJ/VUCZ2A8N1jIbOQh2kDhLPeTBjjE+gk=', '1312313', 'test@gmail.com', 1, NULL),
	(7, NULL, 0, '', '', 0, 1, '2019-09-13 17:16:07.000162', 'RMS', 'OUA', 'USER-20190913-0000007', 'Risty', 'risty', 'pbkdf2_sha256$150000$u46vJ6fcBmKv$mqqauIV+rFd/avebA7dzyAZTNRslRghmgEp8d7+5bDg=', '1312313', 'test@gmail.com', 1, NULL),
	(8, NULL, 0, '', '', 0, 1, '2019-09-13 17:16:21.271230', 'RMS', 'OUA', 'USER-20190913-0000008', 'Sam', 'sammy', 'pbkdf2_sha256$150000$DCYzCtYluXE3$J/53NfcTAfkkd1ChzOMbu+GK4w2Bv6tFJ7KgTSp6/Jk=', '1312313', 'test@gmail.com', 1, NULL),
	(9, NULL, 0, '', '', 0, 1, '2019-09-13 17:16:31.097103', 'RMS', 'OUA', 'USER-20190913-0000009', 'Kath', 'kath', 'pbkdf2_sha256$150000$vOzse18mbmbo$R7xhEe7Ivv1pQhUa92Cz6vvzLdBhvI/9H+yciuPKkQs=', '1312313', 'test@gmail.com', 1, NULL);
/*!40000 ALTER TABLE `auth_user` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user_application
CREATE TABLE IF NOT EXISTS `auth_user_application` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `application_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_user_application_user_id_application_id_4d89d44a_uniq` (`user_id`,`application_id`),
  KEY `auth_user_application_application_id_5c17d611_fk_applications_id` (`application_id`),
  CONSTRAINT `auth_user_application_application_id_5c17d611_fk_applications_id` FOREIGN KEY (`application_id`) REFERENCES `applications` (`id`),
  CONSTRAINT `auth_user_application_user_id_7b07e391_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_user_application: ~3 rows (approximately)
DELETE FROM `auth_user_application`;
/*!40000 ALTER TABLE `auth_user_application` DISABLE KEYS */;
INSERT INTO `auth_user_application` (`id`, `user_id`, `application_id`) VALUES
	(2, 5, 1),
	(4, 5, 2),
	(3, 5, 3);
/*!40000 ALTER TABLE `auth_user_application` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user_groups
CREATE TABLE IF NOT EXISTS `auth_user_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_user_groups_user_id_group_id_94350c0c_uniq` (`user_id`,`group_id`),
  KEY `auth_user_groups_group_id_97559544_fk_auth_group_id` (`group_id`),
  CONSTRAINT `auth_user_groups_group_id_97559544_fk_auth_group_id` FOREIGN KEY (`group_id`) REFERENCES `auth_group` (`id`),
  CONSTRAINT `auth_user_groups_user_id_6a12ed8b_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_user_groups: ~0 rows (approximately)
DELETE FROM `auth_user_groups`;
/*!40000 ALTER TABLE `auth_user_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_user_groups` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user_images
CREATE TABLE IF NOT EXISTS `auth_user_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `is_primary` tinyint(1) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `auth_user_images_user_id_7c29985d_fk_auth_user_id` (`user_id`),
  CONSTRAINT `auth_user_images_user_id_7c29985d_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_user_images: ~0 rows (approximately)
DELETE FROM `auth_user_images`;
/*!40000 ALTER TABLE `auth_user_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_user_images` ENABLE KEYS */;

-- Dumping structure for table rms_db.auth_user_user_permissions
CREATE TABLE IF NOT EXISTS `auth_user_user_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `auth_user_user_permissions_user_id_permission_id_14a6b632_uniq` (`user_id`,`permission_id`),
  KEY `auth_user_user_permi_permission_id_1fbb5f2c_fk_auth_perm` (`permission_id`),
  CONSTRAINT `auth_user_user_permi_permission_id_1fbb5f2c_fk_auth_perm` FOREIGN KEY (`permission_id`) REFERENCES `auth_permission` (`id`),
  CONSTRAINT `auth_user_user_permissions_user_id_a95ead1b_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.auth_user_user_permissions: ~0 rows (approximately)
DELETE FROM `auth_user_user_permissions`;
/*!40000 ALTER TABLE `auth_user_user_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `auth_user_user_permissions` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_form_approvers
CREATE TABLE IF NOT EXISTS `change_request_form_approvers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` varchar(50) DEFAULT NULL,
  `delegation` varchar(50) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `remarks` varchar(255) DEFAULT NULL,
  `action` varchar(50) DEFAULT NULL,
  `date_sent` datetime(6) DEFAULT NULL,
  `form_code_id` varchar(255) NOT NULL,
  `tmp_approver_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_form__form_code_id_5dfe5c56_fk_change_re` (`form_code_id`),
  KEY `change_request_form__tmp_approver_id_fff34e6d_fk_change_re` (`tmp_approver_id`),
  KEY `change_request_form_approvers_user_id_3a71dffe_fk_auth_user_code` (`user_id`),
  CONSTRAINT `change_request_form__form_code_id_5dfe5c56_fk_change_re` FOREIGN KEY (`form_code_id`) REFERENCES `change_request_form_headers` (`form_code`),
  CONSTRAINT `change_request_form__tmp_approver_id_fff34e6d_fk_change_re` FOREIGN KEY (`tmp_approver_id`) REFERENCES `change_request_template_approvers` (`code`),
  CONSTRAINT `change_request_form_approvers_user_id_3a71dffe_fk_auth_user_code` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_form_approvers: ~9 rows (approximately)
DELETE FROM `change_request_form_approvers`;
/*!40000 ALTER TABLE `change_request_form_approvers` DISABLE KEYS */;
INSERT INTO `change_request_form_approvers` (`id`, `level`, `delegation`, `created`, `code`, `remarks`, `action`, `date_sent`, `form_code_id`, `tmp_approver_id`, `user_id`) VALUES
	(1, '1', 'HOD', '2019-09-13 17:52:28.672540', 'FRMAPR-20190913-0000001', NULL, NULL, NULL, 'FRM-20190913-0000001', 'TMPAPR-20190913-0000001', 'USER-20190913-0000008'),
	(2, '2', 'Approver', '2019-09-13 17:52:28.765551', 'FRMAPR-20190913-0000002', NULL, NULL, NULL, 'FRM-20190913-0000001', 'TMPAPR-20190913-0000002', 'USER-20190913-0000009'),
	(3, '3', 'Approver', '2019-09-13 17:52:28.815514', 'FRMAPR-20190913-0000003', NULL, NULL, NULL, 'FRM-20190913-0000001', 'TMPAPR-20190913-0000003', 'USER-20190913-0000008'),
	(4, '1', 'HOD', '2019-09-13 18:00:28.709135', 'FRMAPR-20190913-0000004', NULL, NULL, NULL, 'FRM-20190913-0000002', 'TMPAPR-20190913-0000001', 'USER-20190913-0000008'),
	(5, '2', 'Approver', '2019-09-13 18:00:28.784049', 'FRMAPR-20190913-0000005', NULL, NULL, NULL, 'FRM-20190913-0000002', 'TMPAPR-20190913-0000002', 'USER-20190913-0000009'),
	(6, '3', 'Approver', '2019-09-13 18:00:28.817052', 'FRMAPR-20190913-0000006', NULL, NULL, NULL, 'FRM-20190913-0000002', 'TMPAPR-20190913-0000003', 'USER-20190913-0000008'),
	(7, '1', 'HOD', '2019-09-16 10:40:04.214928', 'FRMAPR-20190916-0000007', NULL, NULL, NULL, 'FRM-20190916-0000004', 'TMPAPR-20190916-0000004', 'USER-20190913-0000008'),
	(8, '2', 'Approver', '2019-09-16 10:40:04.298003', 'FRMAPR-20190916-0000008', NULL, NULL, NULL, 'FRM-20190916-0000004', 'TMPAPR-20190913-0000002', 'USER-20190913-0000009'),
	(9, '3', 'Approver', '2019-09-16 10:40:04.331213', 'FRMAPR-20190916-0000009', NULL, NULL, NULL, 'FRM-20190916-0000004', 'TMPAPR-20190913-0000003', 'USER-20190913-0000008');
/*!40000 ALTER TABLE `change_request_form_approvers` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_form_attachments
CREATE TABLE IF NOT EXISTS `change_request_form_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_type` varchar(255) NOT NULL,
  `attachment_name` varchar(255) NOT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `file_upload` varchar(100) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `form_code_id` varchar(255) NOT NULL,
  `tmp_attach_id` varchar(255) DEFAULT NULL,
  `uploaded_by_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_form__form_code_id_6f991ff9_fk_change_re` (`form_code_id`),
  KEY `change_request_form__tmp_attach_id_14c2eae7_fk_change_re` (`tmp_attach_id`),
  KEY `change_request_form__uploaded_by_id_3187c462_fk_auth_user` (`uploaded_by_id`),
  CONSTRAINT `change_request_form__form_code_id_6f991ff9_fk_change_re` FOREIGN KEY (`form_code_id`) REFERENCES `change_request_form_headers` (`form_code`),
  CONSTRAINT `change_request_form__tmp_attach_id_14c2eae7_fk_change_re` FOREIGN KEY (`tmp_attach_id`) REFERENCES `change_request_template_attachments` (`code`),
  CONSTRAINT `change_request_form__uploaded_by_id_3187c462_fk_auth_user` FOREIGN KEY (`uploaded_by_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_form_attachments: ~6 rows (approximately)
DELETE FROM `change_request_form_attachments`;
/*!40000 ALTER TABLE `change_request_form_attachments` DISABLE KEYS */;
INSERT INTO `change_request_form_attachments` (`id`, `attachment_type`, `attachment_name`, `file_name`, `description`, `file_upload`, `created`, `code`, `form_code_id`, `tmp_attach_id`, `uploaded_by_id`) VALUES
	(1, 'Hello', 'heyu', 'Sample', 'Sameple Desc', '', '2019-09-13 17:52:28.990512', 'FRMATCH-20190913-0000001', 'FRM-20190913-0000001', 'TMPATCH-20190913-0000001', 'USER-20190913-0000006'),
	(2, 'Hello', 'heyu', 'Sample', 'Sameple Desc', '', '2019-09-13 17:52:29.090515', 'FRMATCH-20190913-0000002', 'FRM-20190913-0000001', 'TMPATCH-20190913-0000002', 'USER-20190913-0000006'),
	(3, 'Hello', 'heyu', 'Sample', 'Sameple Desc', '', '2019-09-13 18:00:29.100785', 'FRMATCH-20190913-0000003', 'FRM-20190913-0000002', 'TMPATCH-20190913-0000001', 'USER-20190913-0000006'),
	(4, 'Hello', 'heyu', 'Sample', 'Sameple Desc', '', '2019-09-13 18:00:29.201312', 'FRMATCH-20190913-0000004', 'FRM-20190913-0000002', 'TMPATCH-20190913-0000002', 'USER-20190913-0000006'),
	(5, 'Hello', 'heyu', 'Sample', 'Sameple Desc', '', '2019-09-16 10:40:04.448249', 'FRMATCH-20190916-0000005', 'FRM-20190916-0000004', 'TMPATCH-20190913-0000001', 'USER-20190913-0000006'),
	(6, 'Hello', 'heyu', 'Sample', 'Sameple Desc', '', '2019-09-16 10:40:04.573173', 'FRMATCH-20190916-0000006', 'FRM-20190916-0000004', 'TMPATCH-20190913-0000002', 'USER-20190913-0000006');
/*!40000 ALTER TABLE `change_request_form_attachments` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_form_details
CREATE TABLE IF NOT EXISTS `change_request_form_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_idx` longtext NOT NULL,
  `field_ref` longtext NOT NULL,
  `field_val` longtext NOT NULL,
  `field_props` longtext NOT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `form_code_id` varchar(255) NOT NULL,
  `tmp_detail_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_form__form_code_id_b66d4e40_fk_change_re` (`form_code_id`),
  KEY `change_request_form__tmp_detail_id_315fbb6d_fk_change_re` (`tmp_detail_id`),
  CONSTRAINT `change_request_form__form_code_id_b66d4e40_fk_change_re` FOREIGN KEY (`form_code_id`) REFERENCES `change_request_form_headers` (`form_code`),
  CONSTRAINT `change_request_form__tmp_detail_id_315fbb6d_fk_change_re` FOREIGN KEY (`tmp_detail_id`) REFERENCES `change_request_template_details` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_form_details: ~6 rows (approximately)
DELETE FROM `change_request_form_details`;
/*!40000 ALTER TABLE `change_request_form_details` DISABLE KEYS */;
INSERT INTO `change_request_form_details` (`id`, `field_idx`, `field_ref`, `field_val`, `field_props`, `created`, `code`, `form_code_id`, `tmp_detail_id`) VALUES
	(1, 'Hello', 'heyu', 'Sample', 'Sameple Desc', '2019-09-13 17:52:29.148568', 'FRMDETAIL-20190913-0000001', 'FRM-20190913-0000001', 'TMPDETAIL-20190913-0000001'),
	(2, 'Hello', 'heyu', 'Sample', 'Sameple Desc', '2019-09-13 17:52:29.199518', 'FRMDETAIL-20190913-0000002', 'FRM-20190913-0000001', 'TMPDETAIL-20190913-0000002'),
	(3, 'Hello', 'heyu', 'Sample', 'Sameple Desc', '2019-09-13 18:00:29.401617', 'FRMDETAIL-20190913-0000003', 'FRM-20190913-0000002', 'TMPDETAIL-20190913-0000001'),
	(4, 'Hello', 'heyu', 'Sample', 'Sameple Desc', '2019-09-13 18:00:29.497078', 'FRMDETAIL-20190913-0000004', 'FRM-20190913-0000002', 'TMPDETAIL-20190913-0000002'),
	(5, 'Hello', 'heyu', 'Sample', 'Sameple Desc', '2019-09-16 10:40:04.646211', 'FRMDETAIL-20190916-0000005', 'FRM-20190916-0000004', 'TMPDETAIL-20190913-0000001'),
	(6, 'Hello', 'heyu', 'Sample', 'Sameple Desc', '2019-09-16 10:40:04.688154', 'FRMDETAIL-20190916-0000006', 'FRM-20190916-0000004', 'TMPDETAIL-20190913-0000002');
/*!40000 ALTER TABLE `change_request_form_details` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_form_headers
CREATE TABLE IF NOT EXISTS `change_request_form_headers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `requested_to_template_name` varchar(255) NOT NULL,
  `requested_to_template_id` varchar(255) NOT NULL,
  `requested_to_objective` varchar(255) DEFAULT NULL,
  `requested_to_target_date` datetime(6) DEFAULT NULL,
  `requested_to_priority` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created` datetime(6) NOT NULL,
  `form_code` varchar(255) NOT NULL,
  `cancel_date` datetime(6) DEFAULT NULL,
  `status` varchar(50) NOT NULL,
  `company_desc` varchar(255) DEFAULT NULL,
  `department_desc` varchar(255) DEFAULT NULL,
  `requested_desc` varchar(255) DEFAULT NULL,
  `old_form_code` varchar(255) DEFAULT NULL,
  `requested_by_department_id` varchar(255) NOT NULL,
  `requested_by_user_id` varchar(255) NOT NULL,
  `requested_to_company_id` varchar(255) NOT NULL,
  `requested_to_department_id` varchar(255) NOT NULL,
  `requested_to_user_id` varchar(255) NOT NULL,
  `template_no_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `form_code` (`form_code`),
  KEY `change_request_form__requested_by_departm_af6aa045_fk_departmen` (`requested_by_department_id`),
  KEY `change_request_form__requested_by_user_id_3287070c_fk_auth_user` (`requested_by_user_id`),
  KEY `change_request_form__requested_to_company_33982877_fk_companies` (`requested_to_company_id`),
  KEY `change_request_form__requested_to_departm_c5d594cd_fk_departmen` (`requested_to_department_id`),
  KEY `change_request_form__requested_to_user_id_11252c8d_fk_auth_user` (`requested_to_user_id`),
  KEY `change_request_form__template_no_id_20abd55c_fk_change_re` (`template_no_id`),
  CONSTRAINT `change_request_form__requested_by_departm_af6aa045_fk_departmen` FOREIGN KEY (`requested_by_department_id`) REFERENCES `departments` (`code`),
  CONSTRAINT `change_request_form__requested_by_user_id_3287070c_fk_auth_user` FOREIGN KEY (`requested_by_user_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `change_request_form__requested_to_company_33982877_fk_companies` FOREIGN KEY (`requested_to_company_id`) REFERENCES `companies` (`code`),
  CONSTRAINT `change_request_form__requested_to_departm_c5d594cd_fk_departmen` FOREIGN KEY (`requested_to_department_id`) REFERENCES `departments` (`code`),
  CONSTRAINT `change_request_form__requested_to_user_id_11252c8d_fk_auth_user` FOREIGN KEY (`requested_to_user_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `change_request_form__template_no_id_20abd55c_fk_change_re` FOREIGN KEY (`template_no_id`) REFERENCES `change_request_template_headers` (`template_no`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_form_headers: ~4 rows (approximately)
DELETE FROM `change_request_form_headers`;
/*!40000 ALTER TABLE `change_request_form_headers` DISABLE KEYS */;
INSERT INTO `change_request_form_headers` (`id`, `requested_to_template_name`, `requested_to_template_id`, `requested_to_objective`, `requested_to_target_date`, `requested_to_priority`, `description`, `created`, `form_code`, `cancel_date`, `status`, `company_desc`, `department_desc`, `requested_desc`, `old_form_code`, `requested_by_department_id`, `requested_by_user_id`, `requested_to_company_id`, `requested_to_department_id`, `requested_to_user_id`, `template_no_id`) VALUES
	(1, 'Sample Template', 'JTC-20190916-0000003', 'Sample Objective', '2019-09-03 13:59:29.694560', 'High', 'sample description', '2019-09-13 17:52:28.509708', 'FRM-20190913-0000001', NULL, 'Draft', 'Oneberry', 'Oneberry Superuser', 'Super User', NULL, 'admin', 'USER-20190913-0000006', 'COMPANY-20190909-0000002', 'DEPARTMENT-20190909-0000002', 'USER-20190913-0000007', 'TMP-20190913-0000001'),
	(2, 'Sample Template', 'JTC-20190913-0000002', 'Sample Objective', '2019-09-03 13:59:29.694560', 'High', 'sample description', '2019-09-13 18:00:28.575041', 'FRM-20190913-0000002', NULL, 'Pending', 'Oneberry', 'Oneberry Superuser', 'Super User', NULL, 'admin', 'USER-20190913-0000006', 'COMPANY-20190909-0000002', 'DEPARTMENT-20190909-0000002', 'USER-20190913-0000007', 'TMP-20190913-0000001'),
	(3, 'Sample Template', 'JTC-20190916-0000001', 'Sample Objective', '2019-09-03 13:59:29.694560', 'High', 'sample description', '2019-09-16 10:39:42.475417', 'FRM-20190916-0000003', NULL, 'Pending', 'Oneberry', 'Oneberry Superuser', 'Super User', NULL, 'admin', 'USER-20190913-0000006', 'COMPANY-20190909-0000002', 'DEPARTMENT-20190909-0000002', 'USER-20190913-0000007', 'TMP-20190916-0000002'),
	(4, 'Sample Template', 'JTC-20190916-0000002', 'Sample Objective', '2019-09-03 13:59:29.694560', 'High', 'sample description', '2019-09-16 10:40:03.976962', 'FRM-20190916-0000004', NULL, 'Pending', 'Oneberry', 'Oneberry Superuser', 'Super User', NULL, 'admin', 'USER-20190913-0000006', 'COMPANY-20190909-0000002', 'DEPARTMENT-20190909-0000002', 'USER-20190913-0000007', 'TMP-20190916-0000002');
/*!40000 ALTER TABLE `change_request_form_headers` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_form_stakeholders
CREATE TABLE IF NOT EXISTS `change_request_form_stakeholders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `delegation` varchar(255) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `date_added` datetime(6) DEFAULT NULL,
  `form_code_id` varchar(255) NOT NULL,
  `tmp_stake_id` varchar(255) DEFAULT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_form__form_code_id_350d3c3d_fk_change_re` (`form_code_id`),
  KEY `change_request_form__tmp_stake_id_fe1f7139_fk_change_re` (`tmp_stake_id`),
  KEY `change_request_form__user_id_378bdf3e_fk_auth_user` (`user_id`),
  CONSTRAINT `change_request_form__form_code_id_350d3c3d_fk_change_re` FOREIGN KEY (`form_code_id`) REFERENCES `change_request_form_headers` (`form_code`),
  CONSTRAINT `change_request_form__tmp_stake_id_fe1f7139_fk_change_re` FOREIGN KEY (`tmp_stake_id`) REFERENCES `change_request_template_stakeholders` (`code`),
  CONSTRAINT `change_request_form__user_id_378bdf3e_fk_auth_user` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_form_stakeholders: ~6 rows (approximately)
DELETE FROM `change_request_form_stakeholders`;
/*!40000 ALTER TABLE `change_request_form_stakeholders` DISABLE KEYS */;
INSERT INTO `change_request_form_stakeholders` (`id`, `delegation`, `created`, `code`, `date_added`, `form_code_id`, `tmp_stake_id`, `user_id`) VALUES
	(1, 'Mandatory Stakeholder', '2019-09-13 17:52:28.882514', 'FRMSTK-20190913-0000001', '2019-09-03 13:59:29.694560', 'FRM-20190913-0000001', 'TMPSTK-20190913-0000001', 'USER-20190913-0000009'),
	(2, 'Stake Approver', '2019-09-13 17:52:28.932512', 'FRMSTK-20190913-0000002', '2019-09-03 13:59:29.694560', 'FRM-20190913-0000001', 'TMPSTK-20190913-0000002', 'USER-20190913-0000008'),
	(3, 'Mandatory Stakeholder', '2019-09-13 18:00:28.927599', 'FRMSTK-20190913-0000003', '2019-09-03 13:59:29.694560', 'FRM-20190913-0000002', 'TMPSTK-20190913-0000001', 'USER-20190913-0000009'),
	(4, 'Stake Approver', '2019-09-13 18:00:29.009324', 'FRMSTK-20190913-0000004', '2019-09-03 13:59:29.694560', 'FRM-20190913-0000002', 'TMPSTK-20190913-0000002', 'USER-20190913-0000008'),
	(5, 'Mandatory Stakeholder', '2019-09-16 10:40:04.373161', 'FRMSTK-20190916-0000005', '2019-09-03 13:59:29.694560', 'FRM-20190916-0000004', 'TMPSTK-20190913-0000001', 'USER-20190913-0000009'),
	(6, 'Stake Approver', '2019-09-16 10:40:04.406158', 'FRMSTK-20190916-0000006', '2019-09-03 13:59:29.694560', 'FRM-20190916-0000004', 'TMPSTK-20190913-0000002', 'USER-20190913-0000008');
/*!40000 ALTER TABLE `change_request_form_stakeholders` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_history
CREATE TABLE IF NOT EXISTS `change_request_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `action` varchar(50) NOT NULL,
  `entity` varchar(50) NOT NULL,
  `form_code` varchar(255) DEFAULT NULL,
  `fromValue` longtext DEFAULT NULL,
  `toValue` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_history: ~0 rows (approximately)
DELETE FROM `change_request_history`;
/*!40000 ALTER TABLE `change_request_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `change_request_history` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_template_approvers
CREATE TABLE IF NOT EXISTS `change_request_template_approvers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` varchar(50) DEFAULT NULL,
  `delegation` varchar(50) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `archived_at` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `template_no_id` varchar(255) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_templ_template_no_id_fba2afd7_fk_change_re` (`template_no_id`),
  KEY `change_request_templ_user_id_958c925a_fk_auth_user` (`user_id`),
  CONSTRAINT `change_request_templ_template_no_id_fba2afd7_fk_change_re` FOREIGN KEY (`template_no_id`) REFERENCES `change_request_template_headers` (`template_no`),
  CONSTRAINT `change_request_templ_user_id_958c925a_fk_auth_user` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_template_approvers: ~6 rows (approximately)
DELETE FROM `change_request_template_approvers`;
/*!40000 ALTER TABLE `change_request_template_approvers` DISABLE KEYS */;
INSERT INTO `change_request_template_approvers` (`id`, `level`, `delegation`, `created`, `archived_at`, `code`, `template_no_id`, `user_id`) VALUES
	(1, '1', 'HOD', '2019-09-13 17:16:45.525242', NULL, 'TMPAPR-20190913-0000001', 'TMP-20190913-0000001', 'USER-20190913-0000008'),
	(2, '2', 'Approver', '2019-09-13 17:16:45.575241', NULL, 'TMPAPR-20190913-0000002', 'TMP-20190913-0000001', 'USER-20190913-0000009'),
	(3, '3', 'Approver', '2019-09-13 17:16:45.577244', NULL, 'TMPAPR-20190913-0000003', 'TMP-20190913-0000001', 'USER-20190913-0000008'),
	(4, '1', 'HOD', '2019-09-16 10:38:32.312918', NULL, 'TMPAPR-20190916-0000004', 'TMP-20190916-0000002', NULL),
	(5, '2', 'Approver', '2019-09-16 10:38:32.379920', NULL, 'TMPAPR-20190916-0000005', 'TMP-20190916-0000002', 'USER-20190913-0000009'),
	(6, '3', 'Approver', '2019-09-16 10:38:32.383919', NULL, 'TMPAPR-20190916-0000006', 'TMP-20190916-0000002', 'USER-20190913-0000008');
/*!40000 ALTER TABLE `change_request_template_approvers` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_template_attachments
CREATE TABLE IF NOT EXISTS `change_request_template_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attachment_type` varchar(255) NOT NULL,
  `attachment_name` varchar(255) NOT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `file_upload` varchar(100) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `archived_at` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `template_no_id` varchar(255) NOT NULL,
  `uploaded_by_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_templ_template_no_id_d0247a80_fk_change_re` (`template_no_id`),
  KEY `change_request_templ_uploaded_by_id_f9c6493a_fk_auth_user` (`uploaded_by_id`),
  CONSTRAINT `change_request_templ_template_no_id_d0247a80_fk_change_re` FOREIGN KEY (`template_no_id`) REFERENCES `change_request_template_headers` (`template_no`),
  CONSTRAINT `change_request_templ_uploaded_by_id_f9c6493a_fk_auth_user` FOREIGN KEY (`uploaded_by_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_template_attachments: ~4 rows (approximately)
DELETE FROM `change_request_template_attachments`;
/*!40000 ALTER TABLE `change_request_template_attachments` DISABLE KEYS */;
INSERT INTO `change_request_template_attachments` (`id`, `attachment_type`, `attachment_name`, `file_name`, `description`, `file_upload`, `created`, `archived_at`, `code`, `template_no_id`, `uploaded_by_id`) VALUES
	(1, 'Hello', 'heyu', 'Sample', 'Sameple Desc', '', '2019-09-13 17:16:45.598239', NULL, 'TMPATCH-20190913-0000001', 'TMP-20190913-0000001', 'USER-20190913-0000006'),
	(2, 'Hello', 'heyu', 'Sample', 'Sameple Desc', '', '2019-09-13 17:16:45.648239', NULL, 'TMPATCH-20190913-0000002', 'TMP-20190913-0000001', 'USER-20190913-0000006'),
	(3, 'Hello', 'heyu', 'Sample', 'Sameple Desc', '', '2019-09-16 10:38:32.404923', NULL, 'TMPATCH-20190916-0000003', 'TMP-20190916-0000002', 'USER-20190913-0000006'),
	(4, 'Hello', 'heyu', 'Sample', 'Sameple Desc', '', '2019-09-16 10:38:32.445917', NULL, 'TMPATCH-20190916-0000004', 'TMP-20190916-0000002', 'USER-20190913-0000006');
/*!40000 ALTER TABLE `change_request_template_attachments` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_template_details
CREATE TABLE IF NOT EXISTS `change_request_template_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_idx` longtext NOT NULL,
  `field_ref` longtext NOT NULL,
  `field_val` longtext NOT NULL,
  `field_props` longtext NOT NULL,
  `created` datetime(6) DEFAULT NULL,
  `archived_at` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `template_no_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_templ_template_no_id_d2ba31c2_fk_change_re` (`template_no_id`),
  CONSTRAINT `change_request_templ_template_no_id_d2ba31c2_fk_change_re` FOREIGN KEY (`template_no_id`) REFERENCES `change_request_template_headers` (`template_no`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_template_details: ~4 rows (approximately)
DELETE FROM `change_request_template_details`;
/*!40000 ALTER TABLE `change_request_template_details` DISABLE KEYS */;
INSERT INTO `change_request_template_details` (`id`, `field_idx`, `field_ref`, `field_val`, `field_props`, `created`, `archived_at`, `code`, `template_no_id`) VALUES
	(1, 'Hello', 'heyu', 'Sample', 'Sameple Desc', '2019-09-13 17:16:45.654237', NULL, 'TMPDETAIL-20190913-0000001', 'TMP-20190913-0000001'),
	(2, 'Hello', 'heyu', 'Sample', 'Sameple Desc', '2019-09-13 17:16:45.655237', NULL, 'TMPDETAIL-20190913-0000002', 'TMP-20190913-0000001'),
	(3, 'Hello', 'heyu', 'Sample', 'Sameple Desc', '2019-09-16 10:38:32.459914', NULL, 'TMPDETAIL-20190916-0000003', 'TMP-20190916-0000002'),
	(4, 'Hello', 'heyu', 'Sample', 'Sameple Desc', '2019-09-16 10:38:32.462956', NULL, 'TMPDETAIL-20190916-0000004', 'TMP-20190916-0000002');
/*!40000 ALTER TABLE `change_request_template_details` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_template_headers
CREATE TABLE IF NOT EXISTS `change_request_template_headers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `requested_to_template_name` varchar(255) NOT NULL,
  `requested_to_template_id` varchar(255) NOT NULL,
  `requested_to_objective` varchar(255) DEFAULT NULL,
  `requested_to_target_date` varchar(10) DEFAULT NULL,
  `requested_to_priority` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `created` datetime(6) NOT NULL,
  `archived_at` datetime(6) DEFAULT NULL,
  `template_no` varchar(255) NOT NULL,
  `created_by_department_id` varchar(255) NOT NULL,
  `created_by_user_id` varchar(255) NOT NULL,
  `requested_to_company_id` varchar(255) NOT NULL,
  `requested_to_department_id` varchar(255) NOT NULL,
  `requested_to_user_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `template_no` (`template_no`),
  UNIQUE KEY `change_request_template__requested_to_template_id_003b5f7c_uniq` (`requested_to_template_id`),
  KEY `change_request_templ_created_by_departmen_f5629a3a_fk_departmen` (`created_by_department_id`),
  KEY `change_request_templ_created_by_user_id_ed6f2326_fk_auth_user` (`created_by_user_id`),
  KEY `change_request_templ_requested_to_company_1063b954_fk_companies` (`requested_to_company_id`),
  KEY `change_request_templ_requested_to_departm_e7b33c56_fk_departmen` (`requested_to_department_id`),
  KEY `change_request_templ_requested_to_user_id_cfad98f0_fk_auth_user` (`requested_to_user_id`),
  CONSTRAINT `change_request_templ_created_by_departmen_f5629a3a_fk_departmen` FOREIGN KEY (`created_by_department_id`) REFERENCES `departments` (`code`),
  CONSTRAINT `change_request_templ_created_by_user_id_ed6f2326_fk_auth_user` FOREIGN KEY (`created_by_user_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `change_request_templ_requested_to_company_1063b954_fk_companies` FOREIGN KEY (`requested_to_company_id`) REFERENCES `companies` (`code`),
  CONSTRAINT `change_request_templ_requested_to_departm_e7b33c56_fk_departmen` FOREIGN KEY (`requested_to_department_id`) REFERENCES `departments` (`code`),
  CONSTRAINT `change_request_templ_requested_to_user_id_cfad98f0_fk_auth_user` FOREIGN KEY (`requested_to_user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_template_headers: ~2 rows (approximately)
DELETE FROM `change_request_template_headers`;
/*!40000 ALTER TABLE `change_request_template_headers` DISABLE KEYS */;
INSERT INTO `change_request_template_headers` (`id`, `requested_to_template_name`, `requested_to_template_id`, `requested_to_objective`, `requested_to_target_date`, `requested_to_priority`, `description`, `created`, `archived_at`, `template_no`, `created_by_department_id`, `created_by_user_id`, `requested_to_company_id`, `requested_to_department_id`, `requested_to_user_id`) VALUES
	(1, 'Sample Template', 'JTC', 'Sample Objective', '10', 'High', 'sample description', '2019-09-13 17:16:45.427264', NULL, 'TMP-20190913-0000001', 'admin', 'USER-20190913-0000006', 'COMPANY-20190909-0000002', 'DEPARTMENT-20190909-0000002', 'USER-20190913-0000007'),
	(2, 'Sample Template', 'JTC2', 'Sample Objective', '10', 'High', 'sample description', '2019-09-16 10:38:32.219948', NULL, 'TMP-20190916-0000002', 'admin', 'USER-20190913-0000006', 'COMPANY-20190909-0000002', 'DEPARTMENT-20190909-0000002', 'USER-20190913-0000007');
/*!40000 ALTER TABLE `change_request_template_headers` ENABLE KEYS */;

-- Dumping structure for table rms_db.change_request_template_stakeholders
CREATE TABLE IF NOT EXISTS `change_request_template_stakeholders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `delegation` varchar(255) DEFAULT NULL,
  `created` datetime(6) DEFAULT NULL,
  `archived_at` datetime(6) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `template_no_id` varchar(255) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `change_request_templ_template_no_id_31bc8d14_fk_change_re` (`template_no_id`),
  KEY `change_request_templ_user_id_63128227_fk_auth_user` (`user_id`),
  CONSTRAINT `change_request_templ_template_no_id_31bc8d14_fk_change_re` FOREIGN KEY (`template_no_id`) REFERENCES `change_request_template_headers` (`template_no`),
  CONSTRAINT `change_request_templ_user_id_63128227_fk_auth_user` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.change_request_template_stakeholders: ~4 rows (approximately)
DELETE FROM `change_request_template_stakeholders`;
/*!40000 ALTER TABLE `change_request_template_stakeholders` DISABLE KEYS */;
INSERT INTO `change_request_template_stakeholders` (`id`, `delegation`, `created`, `archived_at`, `code`, `template_no_id`, `user_id`) VALUES
	(1, 'Mandatory Stakeholder', '2019-09-13 17:16:45.585237', NULL, 'TMPSTK-20190913-0000001', 'TMP-20190913-0000001', 'USER-20190913-0000009'),
	(2, 'Stake Approver', '2019-09-13 17:16:45.587237', NULL, 'TMPSTK-20190913-0000002', 'TMP-20190913-0000001', 'USER-20190913-0000008'),
	(3, 'Mandatory Stakeholder', '2019-09-16 10:38:32.390915', NULL, 'TMPSTK-20190916-0000003', 'TMP-20190916-0000002', 'USER-20190913-0000009'),
	(4, 'Stake Approver', '2019-09-16 10:38:32.392946', NULL, 'TMPSTK-20190916-0000004', 'TMP-20190916-0000002', 'USER-20190913-0000008');
/*!40000 ALTER TABLE `change_request_template_stakeholders` ENABLE KEYS */;

-- Dumping structure for table rms_db.companies
CREATE TABLE IF NOT EXISTS `companies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `contact_details` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.companies: ~2 rows (approximately)
DELETE FROM `companies`;
/*!40000 ALTER TABLE `companies` DISABLE KEYS */;
INSERT INTO `companies` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `code`, `name`, `contact_details`) VALUES
	(1, '2019-09-09 15:28:25.000000', 'admin', '2019-09-09 15:28:27.000000', 'admin', 'tir', 'Total Integrated Resources', '13213'),
	(2, '2019-09-09 15:44:03.184742', '', '2019-09-09 15:44:03.185729', 'superuser', 'COMPANY-20190909-0000002', 'Oneberry', '2152509');
/*!40000 ALTER TABLE `companies` ENABLE KEYS */;

-- Dumping structure for table rms_db.departments
CREATE TABLE IF NOT EXISTS `departments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `company_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`),
  KEY `departments_company_id_0d17e9ca_fk_companies_id` (`company_id`),
  CONSTRAINT `departments_company_id_0d17e9ca_fk_companies_id` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.departments: ~2 rows (approximately)
DELETE FROM `departments`;
/*!40000 ALTER TABLE `departments` DISABLE KEYS */;
INSERT INTO `departments` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `code`, `name`, `company_id`) VALUES
	(1, '2019-09-09 15:29:05.000000', 'admin', '2019-09-09 15:29:07.000000', 'admin', 'admin', 'Superuser', 1),
	(2, '2019-09-09 15:51:49.648114', 'admin', '2019-09-09 15:51:49.649079', 'superuser', 'DEPARTMENT-20190909-0000002', 'Super User', 2);
/*!40000 ALTER TABLE `departments` ENABLE KEYS */;

-- Dumping structure for table rms_db.django_admin_log
CREATE TABLE IF NOT EXISTS `django_admin_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `action_time` datetime(6) NOT NULL,
  `object_id` longtext DEFAULT NULL,
  `object_repr` varchar(200) NOT NULL,
  `action_flag` smallint(5) unsigned NOT NULL,
  `change_message` longtext NOT NULL,
  `content_type_id` int(11) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `django_admin_log_content_type_id_c4bce8eb_fk_django_co` (`content_type_id`),
  KEY `django_admin_log_user_id_c564eba6_fk_auth_user_id` (`user_id`),
  CONSTRAINT `django_admin_log_content_type_id_c4bce8eb_fk_django_co` FOREIGN KEY (`content_type_id`) REFERENCES `django_content_type` (`id`),
  CONSTRAINT `django_admin_log_user_id_c564eba6_fk_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.django_admin_log: ~0 rows (approximately)
DELETE FROM `django_admin_log`;
/*!40000 ALTER TABLE `django_admin_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `django_admin_log` ENABLE KEYS */;

-- Dumping structure for table rms_db.django_content_type
CREATE TABLE IF NOT EXISTS `django_content_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app_label` varchar(100) NOT NULL,
  `model` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `django_content_type_app_label_model_76bd3d3b_uniq` (`app_label`,`model`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.django_content_type: ~31 rows (approximately)
DELETE FROM `django_content_type`;
/*!40000 ALTER TABLE `django_content_type` DISABLE KEYS */;
INSERT INTO `django_content_type` (`id`, `app_label`, `model`) VALUES
	(1, 'admin', 'logentry'),
	(3, 'auth', 'group'),
	(2, 'auth', 'permission'),
	(6, 'authtoken', 'token'),
	(4, 'contenttypes', 'contenttype'),
	(8, 'entities', 'application'),
	(9, 'entities', 'attachment'),
	(31, 'entities', 'authtoken'),
	(30, 'entities', 'changerequestformapprovers'),
	(29, 'entities', 'changerequestformattachments'),
	(28, 'entities', 'changerequestformdetails'),
	(10, 'entities', 'changerequestformheader'),
	(27, 'entities', 'changerequestformstakeholders'),
	(11, 'entities', 'changerequesthistory'),
	(26, 'entities', 'changerequesttemplateapprovers'),
	(25, 'entities', 'changerequesttemplateattachments'),
	(24, 'entities', 'changerequesttemplatedetails'),
	(12, 'entities', 'changerequesttemplateheader'),
	(23, 'entities', 'changerequesttemplatestakeholders'),
	(13, 'entities', 'company'),
	(22, 'entities', 'department'),
	(14, 'entities', 'entitylog'),
	(21, 'entities', 'module'),
	(20, 'entities', 'notification'),
	(15, 'entities', 'permission'),
	(16, 'entities', 'role'),
	(19, 'entities', 'rolepermission'),
	(17, 'entities', 'status'),
	(7, 'entities', 'user'),
	(18, 'entities', 'userimage'),
	(5, 'sessions', 'session');
/*!40000 ALTER TABLE `django_content_type` ENABLE KEYS */;

-- Dumping structure for table rms_db.django_session
CREATE TABLE IF NOT EXISTS `django_session` (
  `session_key` varchar(40) NOT NULL,
  `session_data` longtext NOT NULL,
  `expire_date` datetime(6) NOT NULL,
  PRIMARY KEY (`session_key`),
  KEY `django_session_expire_date_a5c62663` (`expire_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.django_session: ~0 rows (approximately)
DELETE FROM `django_session`;
/*!40000 ALTER TABLE `django_session` DISABLE KEYS */;
/*!40000 ALTER TABLE `django_session` ENABLE KEYS */;

-- Dumping structure for table rms_db.email_logs
CREATE TABLE IF NOT EXISTS `email_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `template` varchar(255) NOT NULL,
  `recipients` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `is_sent` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.email_logs: ~4 rows (approximately)
DELETE FROM `email_logs`;
/*!40000 ALTER TABLE `email_logs` DISABLE KEYS */;
INSERT INTO `email_logs` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `template`, `recipients`, `content`, `is_sent`) VALUES
	(1, '2019-09-13 17:14:39.457923', 'superuser@tirsolutions.com', '2019-09-13 17:14:39.457923', 'superuser@tirsolutions.com', 'RMS-NEWUSER.html', 'test@gmail.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear Gladys,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>gladys<br><br>\n<b>Password</b><br>password123<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(2, '2019-09-13 17:16:10.381678', 'superuser@tirsolutions.com', '2019-09-13 17:16:10.381678', 'superuser@tirsolutions.com', 'RMS-NEWUSER.html', 'test@gmail.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear Risty,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>risty<br><br>\n<b>Password</b><br>password123<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(3, '2019-09-13 17:16:24.436345', 'superuser@tirsolutions.com', '2019-09-13 17:16:24.436345', 'superuser@tirsolutions.com', 'RMS-NEWUSER.html', 'test@gmail.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear Sam,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>sammy<br><br>\n<b>Password</b><br>password123<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1),
	(4, '2019-09-13 17:16:34.352466', 'superuser@tirsolutions.com', '2019-09-13 17:16:34.352466', 'superuser@tirsolutions.com', 'RMS-NEWUSER.html', 'test@gmail.com', '<!DOCTYPE html>\n<html>\n<head>\n<title>RMS: New User Created</title>\n</head>\n<body style="font-family: arial;">\n\n<div style="max-width:100px!important;">\n<img src="https://s18.directupload.net/images/190807/wjwrxx5i.jpg"/>\n</div>\n\n<h3>Resource Management System &#40;RMS&#41;</h3>\n<h3 style="color:#888888;">New User Created</h3><br>\n\n<p>Dear Kath,</p><br>\n<p>You have been created as a new user of RMS. Please see your default login details below.</p><br>\n    \n<b>Username</b><br>kath<br><br>\n<b>Password</b><br>password123<br><br>\n\n<p>You may change your password through the <u><a href="http://staging.rms.oneberrysystem.com/cms/profile/" style="text-decoration:underline;color:#007bff;" target="_blank">my profile</a></u> section of RMS any time.</p><br>\n    \n<p>Sincerely,</p>\n<p>RMS Team</p><br><br>\n    \n<p>Powered by</p>\n<img src="https://s18.directupload.net/images/190807/jaewp4nx.png" width="120px"/>\n    \n</body>\n</html>', 1);
/*!40000 ALTER TABLE `email_logs` ENABLE KEYS */;

-- Dumping structure for table rms_db.entity_logs
CREATE TABLE IF NOT EXISTS `entity_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `action` varchar(50) NOT NULL,
  `entity` varchar(50) NOT NULL,
  `row_id` int(11) NOT NULL,
  `fromValue` longtext DEFAULT NULL,
  `toValue` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.entity_logs: ~0 rows (approximately)
DELETE FROM `entity_logs`;
/*!40000 ALTER TABLE `entity_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `entity_logs` ENABLE KEYS */;

-- Dumping structure for table rms_db.modules
CREATE TABLE IF NOT EXISTS `modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `parent` int(11) DEFAULT NULL,
  `sort_id` int(11) NOT NULL,
  `component` varchar(255) DEFAULT NULL,
  `application_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`),
  KEY `modules_application_id_f285bf5b_fk_applications_id` (`application_id`),
  CONSTRAINT `modules_application_id_f285bf5b_fk_applications_id` FOREIGN KEY (`application_id`) REFERENCES `applications` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.modules: ~5 rows (approximately)
DELETE FROM `modules`;
/*!40000 ALTER TABLE `modules` DISABLE KEYS */;
INSERT INTO `modules` (`id`, `created`, `createdby`, `modified`, `modifiedby`, `code`, `name`, `parent`, `sort_id`, `component`, `application_id`) VALUES
	(1, '2019-09-09 15:54:07.799595', '', '2019-09-09 15:54:07.799595', 'superuser', 'MODULE-20190909-0000001', 'Application Management', 0, 1, NULL, 1),
	(2, '2019-09-09 15:54:21.116435', '', '2019-09-09 15:54:21.116435', 'superuser', 'MODULE-20190909-0000002', 'Company Management', 0, 2, NULL, 1),
	(3, '2019-09-09 15:54:35.994377', '', '2019-09-09 15:54:35.994377', 'superuser', 'MODULE-20190909-0000003', 'Department Management', 0, 3, NULL, 1),
	(4, '2019-09-09 15:54:48.479105', '', '2019-09-09 15:54:48.479105', 'superuser', 'MODULE-20190909-0000004', 'Module Management', 0, 4, NULL, 1),
	(5, '2019-09-09 15:54:55.066341', '', '2019-09-09 15:54:55.066341', 'superuser', 'MODULE-20190909-0000005', 'User Management', 0, 5, NULL, 1);
/*!40000 ALTER TABLE `modules` ENABLE KEYS */;

-- Dumping structure for table rms_db.notifications
CREATE TABLE IF NOT EXISTS `notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `notif_type` varchar(20) NOT NULL,
  `message` varchar(255) DEFAULT NULL,
  `is_read` tinyint(1) DEFAULT NULL,
  `created` datetime(6) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `account_no_id` varchar(255) NOT NULL,
  `app_id` varchar(255) NOT NULL,
  `form_code_id` varchar(255) NOT NULL,
  `sender_account_no_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `notifications_account_no_id_ff388d8f_fk_auth_user_code` (`account_no_id`),
  KEY `notifications_app_id_1b485e03_fk_applications_code` (`app_id`),
  KEY `notifications_form_code_id_a2f6cde7_fk_change_re` (`form_code_id`),
  KEY `notifications_sender_account_no_id_8d711c98_fk_auth_user_code` (`sender_account_no_id`),
  CONSTRAINT `notifications_account_no_id_ff388d8f_fk_auth_user_code` FOREIGN KEY (`account_no_id`) REFERENCES `auth_user` (`code`),
  CONSTRAINT `notifications_app_id_1b485e03_fk_applications_code` FOREIGN KEY (`app_id`) REFERENCES `applications` (`code`),
  CONSTRAINT `notifications_form_code_id_a2f6cde7_fk_change_re` FOREIGN KEY (`form_code_id`) REFERENCES `change_request_form_headers` (`form_code`),
  CONSTRAINT `notifications_sender_account_no_id_8d711c98_fk_auth_user_code` FOREIGN KEY (`sender_account_no_id`) REFERENCES `auth_user` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.notifications: ~0 rows (approximately)
DELETE FROM `notifications`;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;

-- Dumping structure for table rms_db.password_resets
CREATE TABLE IF NOT EXISTS `password_resets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` datetime(6) NOT NULL,
  `timeout_at` datetime(6) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `code` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.password_resets: ~0 rows (approximately)
DELETE FROM `password_resets`;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;

-- Dumping structure for table rms_db.permissions
CREATE TABLE IF NOT EXISTS `permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.permissions: ~0 rows (approximately)
DELETE FROM `permissions`;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;

-- Dumping structure for table rms_db.roles
CREATE TABLE IF NOT EXISTS `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.roles: ~0 rows (approximately)
DELETE FROM `roles`;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;

-- Dumping structure for table rms_db.role_permissions
CREATE TABLE IF NOT EXISTS `role_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `permission_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `role_permissions_permission_id_ad343843_fk_permissions_id` (`permission_id`),
  KEY `role_permissions_role_id_216516f2_fk_roles_id` (`role_id`),
  CONSTRAINT `role_permissions_permission_id_ad343843_fk_permissions_id` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`),
  CONSTRAINT `role_permissions_role_id_216516f2_fk_roles_id` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.role_permissions: ~0 rows (approximately)
DELETE FROM `role_permissions`;
/*!40000 ALTER TABLE `role_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_permissions` ENABLE KEYS */;

-- Dumping structure for table rms_db.status_set
CREATE TABLE IF NOT EXISTS `status_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime(6) NOT NULL,
  `createdby` varchar(255) NOT NULL,
  `modified` datetime(6) NOT NULL,
  `modifiedby` varchar(255) NOT NULL,
  `ref` varchar(10) NOT NULL,
  `code` varchar(10) NOT NULL,
  `name` varchar(10) NOT NULL,
  `description` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Dumping data for table rms_db.status_set: ~0 rows (approximately)
DELETE FROM `status_set`;
/*!40000 ALTER TABLE `status_set` DISABLE KEYS */;
/*!40000 ALTER TABLE `status_set` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
